/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.ux.admin.queries.configuration.file;

import crazydev.common.exception.CdError;
import crazydev.common.exception.CdErrorCode;
import crazydev.common.fs.CdVFileSystem;
import crazydev.common.utils.CdStringUtils;
import crazydev.iccube.fs.OlapFile;
import crazydev.iccube.fs.OlapFileSystem;
import crazydev.iccube.notification.OlapNotificationService;
import crazydev.iccube.olap.component.context.OlapEngineApplicationContext;
import crazydev.iccube.request.log.OlapRequestId;
import crazydev.iccube.server.configuration.IcCubeServerConfiguration;
import crazydev.iccube.server.context.IcCubeServerApplicationContext;
import crazydev.iccube.ux.admin.queries.UxAdminQuery;
import crazydev.iccube.ux.admin.queries.configuration.file.UxServerConfFileType;
import crazydev.iccube.ux.admin.queries.utils.UxFileWrapper;
import crazydev.iccube.ux.common.meta.UxQueryMeta;
import crazydev.iccube.ux.common.query.UxQueryContext;
import crazydev.iccube.ux.common.reply.UxAttachmentReply;
import crazydev.iccube.ux.common.reply.UxErrorCode;
import crazydev.iccube.ux.common.reply.UxReply;
import java.io.File;
import java.io.Serializable;
import org.jetbrains.annotations.Nullable;

public class UxDownloadServerConfFileQuery
extends UxAdminQuery {
    @Nullable
    private final String fileType;

    protected UxDownloadServerConfFileQuery(UxQueryMeta meta, OlapRequestId requestId, @Nullable String fileType) {
        super(meta, requestId);
        this.fileType = fileType;
    }

    @Override
    protected UxReply executeQuery(UxQueryContext queryContext) {
        UxServerConfFileType fileType_;
        if (CdStringUtils.isNullOrBlank((String)this.fileType)) {
            return UxReply.error(queryContext, CdError.create((CdErrorCode)UxErrorCode.FILE_UNKNOWN, (Serializable[])new Serializable[]{"n/a"}));
        }
        try {
            fileType_ = UxServerConfFileType.valueOf(this.fileType);
        }
        catch (IllegalArgumentException ex) {
            return UxReply.error(queryContext, CdError.create((CdErrorCode)UxErrorCode.FILE_UNKNOWN, (Serializable[])new Serializable[]{this.fileType}));
        }
        switch (fileType_) {
            case Conf: {
                return UxDownloadServerConfFileQuery.handleServerConfiguration(queryContext, fileType_);
            }
            case ConfNotifs: {
                return UxDownloadServerConfFileQuery.handleServerConfigurationNotification(queryContext, fileType_);
            }
        }
        return UxReply.error(queryContext, CdError.create((CdErrorCode)UxErrorCode.FILE_UNKNOWN, (Serializable[])new Serializable[]{this.fileType}));
    }

    private static UxReply handleServerConfiguration(UxQueryContext queryContext, UxServerConfFileType fileType) {
        IcCubeServerConfiguration configuration = queryContext.getApplicationContext().getConfiguration();
        File file = configuration.getXmlFile();
        return UxDownloadServerConfFileQuery.handleFile(queryContext, fileType, file);
    }

    private static UxReply handleServerConfigurationNotification(UxQueryContext queryContext, UxServerConfFileType fileType) {
        IcCubeServerApplicationContext appContext = queryContext.getApplicationContext();
        OlapEngineApplicationContext engineAppContext = appContext.getOlapEngineApplicationContext();
        OlapNotificationService service = engineAppContext.getNotificationService();
        File file = service.getConfigurationFile();
        return UxDownloadServerConfFileQuery.handleFile(queryContext, fileType, file);
    }

    private static UxReply handleFile(UxQueryContext queryContext, UxServerConfFileType fileType, @Nullable File file) {
        if (file == null || !file.exists()) {
            return UxReply.error(queryContext, CdError.create((CdErrorCode)UxErrorCode.FILE_NOT_FOUND, (Serializable[])new Serializable[]{fileType}));
        }
        String mimeType = queryContext.getMimeTypeByExtension(file.getName());
        OlapFileSystem fs = OlapFileSystem.createFileSystem((CdVFileSystem)queryContext.getVfs(), (File)file.getParentFile());
        OlapFile file_ = fs.create(file.getName());
        UxFileWrapper wrapper = UxFileWrapper.forOlapFile(file_, file.getName(), mimeType, false);
        return new UxAttachmentReply(wrapper, null);
    }
}

