/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.ux.admin.queries.alerts;

import crazydev.common.babylon.CdBabylonService;
import crazydev.common.exception.CdError;
import crazydev.common.utils.CdStringUtils;
import crazydev.iccube.olap.loggers.OlapLoggers;
import crazydev.iccube.request.log.OlapRequestId;
import crazydev.iccube.server.scheduler.errors.IcCubeSchedulerDefinitionError;
import crazydev.iccube.server.scheduler.errors.IcCubeSchedulerDefinitionErrorCode;
import crazydev.iccube.server.scheduler.errors.IcCubeSchedulerDefinitionErrorException;
import crazydev.iccube.server.scheduler.runtime.IcCubeScheduler;
import crazydev.iccube.server.scheduler.runtime.IcCubeSchedulerKind;
import crazydev.iccube.ux.UxActionContinuationKind;
import crazydev.iccube.ux.admin.queries.alerts.UxAlertQueryMeta;
import crazydev.iccube.ux.admin.queries.scheduler.common.UxAbstractSchedulerQuery;
import crazydev.iccube.ux.common.action.UxActionContinuation;
import crazydev.iccube.ux.common.meta.UxQueryMeta;
import crazydev.iccube.ux.common.query.UxQueryContext;
import crazydev.iccube.ux.common.reply.UxReply;
import crazydev.iccube.ux.common.utils.UxUtils;
import crazydev.iccube.ux.common.validation.UxValidationResult;
import java.io.Serializable;
import org.jetbrains.annotations.Nullable;

public class UxDuplicateAlertQuery
extends UxAbstractSchedulerQuery {
    @Nullable
    private final String info;
    private final int revNumber;
    @Nullable
    private final String uuid;
    private final String newAlertName;

    protected UxDuplicateAlertQuery(UxQueryMeta meta, OlapRequestId requestId, String info, int revNumber, @Nullable String uuid, String newAlertName) {
        super(meta, requestId);
        this.info = info;
        this.revNumber = revNumber;
        this.uuid = uuid;
        this.newAlertName = newAlertName;
    }

    @Override
    protected UxReply executeQuery(UxQueryContext queryContext) {
        String newUUID;
        if (this.uuid == null || CdStringUtils.isNullOrBlank((String)this.uuid)) {
            return UxReply.actionSuccess();
        }
        try {
            IcCubeScheduler scheduler = queryContext.getScheduler(IcCubeSchedulerKind.ALERTS);
            newUUID = scheduler.duplicateAndScheduleJobDefinition(queryContext.asRuntimeContext(), queryContext.getUserName(), this.revNumber, this.uuid, this.newAlertName);
        }
        catch (IcCubeSchedulerDefinitionErrorException ex) {
            OlapLoggers.SCHEDULER.error((Object)"[ALERT] duplicate alert [%s] [%s] error".formatted(this.uuid, this.newAlertName), (Throwable)((Object)ex));
            IcCubeSchedulerDefinitionError error = new IcCubeSchedulerDefinitionError(IcCubeSchedulerDefinitionErrorCode.SAVE_ALERT_ERROR, new Serializable[]{ex.getError().asMessage((CdBabylonService)queryContext.getOlapBabylonService())});
            UxValidationResult validation = UxUtils.setupValidationResult(queryContext, queryContext.getOlapBabylonService(), (CdError)error);
            return UxReply.validationErrors(validation);
        }
        UxActionContinuation continuation = null;
        if (!"table".equals(this.info) && newUUID != null) {
            continuation = new UxActionContinuation(UxActionContinuationKind.NAVIGATE, UxAlertQueryMeta.createUseCase(queryContext, newUUID, this.newAlertName, null));
        }
        return UxReply.actionSuccess(continuation);
    }
}

