/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.ux.admin.queries.alerts;

import crazydev.iccube.contextual.OlapContextualError;
import crazydev.iccube.olap.component.context.OlapRuntimeContext;
import crazydev.iccube.request.log.OlapRequestId;
import crazydev.iccube.server.scheduler.definition.IcCubeSchedulerAlertJobDefinition;
import crazydev.iccube.server.scheduler.definition.IcCubeSchedulerJobDefinition;
import crazydev.iccube.server.scheduler.runtime.IcCubeScheduler;
import crazydev.iccube.server.scheduler.runtime.IcCubeSchedulerKind;
import crazydev.iccube.ux.admin.queries.alerts.UxAlertQueryMeta;
import crazydev.iccube.ux.admin.queries.alerts.UxAlertsQueryMeta;
import crazydev.iccube.ux.admin.queries.scheduler.common.UxAbstractSchedulerQuery;
import crazydev.iccube.ux.admin.queries.scheduler.common.UxScheduledJob;
import crazydev.iccube.ux.admin.queries.scheduler.common.UxScheduledJobMode;
import crazydev.iccube.ux.admin.queries.scheduler.common.UxScheduledJobStatus;
import crazydev.iccube.ux.admin.usecase.UxAdminUseCaseName;
import crazydev.iccube.ux.common.action.UxAction;
import crazydev.iccube.ux.common.filter.UxEnumFilterType;
import crazydev.iccube.ux.common.filter.UxFilterMeta;
import crazydev.iccube.ux.common.filter.UxFilterMetas;
import crazydev.iccube.ux.common.meta.UxQueryMeta;
import crazydev.iccube.ux.common.query.UxQueryContext;
import crazydev.iccube.ux.common.reply.UxPayloadReply;
import crazydev.iccube.ux.common.reply.UxReply;
import crazydev.iccube.ux.common.style.UxStyleLevel;
import crazydev.iccube.ux.common.table.UxTable;
import crazydev.iccube.ux.common.table.UxTableCell;
import crazydev.iccube.ux.common.table.UxTableHeaders;
import crazydev.iccube.ux.common.table.UxTableMeta;
import crazydev.iccube.ux.common.table.UxTableOptions;
import crazydev.iccube.ux.common.table.UxTableRow;
import crazydev.iccube.ux.common.table.UxTableRowSearcher;
import crazydev.iccube.ux.common.table.UxTableSortType;
import crazydev.iccube.ux.common.table.UxTableWithUseCasesReplyPayload;
import crazydev.iccube.ux.common.usecase.UxUseCase;
import crazydev.iccube.ux.common.utils.UxUtils;
import crazydev.iccube.ux.processor.UxBabylonService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.Nullable;

public class UxAlertsQuery
extends UxAbstractSchedulerQuery {
    @Nullable
    private final UxTableOptions tableOptions;

    protected UxAlertsQuery(UxQueryMeta meta, OlapRequestId requestId, @Nullable UxTableOptions tableOptions) {
        super(meta, requestId);
        this.tableOptions = tableOptions;
    }

    @Override
    protected UxReply executeQuery(UxQueryContext queryContext) {
        OlapRuntimeContext rContext;
        UxBabylonService babylon = queryContext.getUxBabylonService();
        IcCubeScheduler scheduler = queryContext.getScheduler(IcCubeSchedulerKind.ALERTS);
        List<OlapContextualError> errors = scheduler.getApplyDefinitionErrors(rContext = queryContext.asRuntimeContext());
        if (errors != null && !errors.isEmpty()) {
            return UxReply.validationErrors(UxUtils.setupValidationResult(queryContext, queryContext.getOlapBabylonService(), errors));
        }
        UxTableHeaders header = UxTableHeaders.create(babylon, "schema", "name", "status", "mode", "errors", "nextTriggerTime");
        UxFilterMetas filterMetas = new UxFilterMetas(new UxFilterMeta<IcCubeSchedulerAlertJobDefinition>("schema", babylon.translate("filterAlertSchema", new Serializable[0]), IcCubeSchedulerAlertJobDefinition::getSchemaName), new UxFilterMeta<IcCubeSchedulerJobDefinition>("status", babylon.translate("filterAlertStatus", new Serializable[0]), UxEnumFilterType.create(babylon, UxScheduledJobStatus.class), row -> {
            UxScheduledJob job = (UxScheduledJob)row.getScheduledInfo();
            return job != null ? job.getStatus() : null;
        }), new UxFilterMeta<IcCubeSchedulerJobDefinition>("mode", babylon.translate("filterAlertMode", new Serializable[0]), UxEnumFilterType.create(babylon, UxScheduledJobMode.class), row -> {
            UxScheduledJob job = (UxScheduledJob)row.getScheduledInfo();
            return job != null ? job.getMode() : null;
        }));
        UxTableRowSearcher<IcCubeSchedulerAlertJobDefinition> searcher = new UxTableRowSearcher<IcCubeSchedulerAlertJobDefinition>(this){
            {
                Objects.requireNonNull(this$0);
            }

            @Override
            public boolean isAccepting(IcCubeSchedulerAlertJobDefinition row, String searchText) {
                return this.isContaining(searchText, row.getSchemaName(), row.getAlertName());
            }
        };
        List<IcCubeSchedulerJobDefinition> definitions_ = scheduler.getScheduleJobDefinitions(rContext);
        for (IcCubeSchedulerJobDefinition definition : definitions_) {
            definition.setScheduledInfo(UxScheduledJob.create(queryContext, scheduler.getScheduledJob(rContext, definition)));
        }
        List<IcCubeSchedulerJobDefinition> definitions = this.filter(this.tableOptions, searcher, filterMetas, definitions_);
        int totalRowCount = definitions.size();
        UxTableOptions options = UxTableOptions.extendWithMissings(this.tableOptions, UxTableOptions.createForFirstPageWithDefaults(queryContext.getApi(), "name", UxTableSortType.asc, totalRowCount));
        ArrayList<UxTableRow> rows = new ArrayList<UxTableRow>();
        for (IcCubeSchedulerJobDefinition definition : definitions) {
            rows.add(UxAlertsQuery.createRow(queryContext, definition));
        }
        int revNumber = scheduler.getCurrentRevNumber(rContext);
        List<UxAction> multiSelectionActions = UxAlertsQueryMeta.createMultiSelectionActions(queryContext, revNumber);
        UxTable table = UxTable.create(options, header, rows, multiSelectionActions);
        UxTableMeta tableMeta = new UxTableMeta(searcher != null, filterMetas);
        return UxReply.success(new UxTableWithUseCasesReplyPayload(tableMeta, table));
    }

    private static UxTableRow createRow(UxQueryContext context, IcCubeSchedulerJobDefinition definition) {
        boolean hasErrors;
        UxBabylonService babylon = context.getUxBabylonService();
        boolean disabled = !definition.isEnabled();
        IcCubeSchedulerAlertJobDefinition alert = (IcCubeSchedulerAlertJobDefinition)definition;
        UxScheduledJob job = (UxScheduledJob)alert.getScheduledInfo();
        ArrayList<UxTableCell> cells = new ArrayList<UxTableCell>();
        cells.add(new UxTableCell(alert.getSchemaName()));
        String latestRequestUuid = job != null ? job.getLatestRequestUUID() : null;
        UxUseCase useCase = UxAlertQueryMeta.createUseCase(context, alert.getUuid(), alert.getAlertName(), latestRequestUuid);
        cells.add(new UxTableCell((Object)alert.getAlertName(), useCase));
        UxScheduledJobStatus status = job != null ? job.getStatus() : null;
        UxScheduledJobMode mode = job != null ? job.getMode() : null;
        cells.add(new UxTableCell(status != null ? babylon.translateEnum(UxScheduledJobStatus.class, status.name()) : null).withValue_((Object)status));
        cells.add(new UxTableCell(mode != null ? babylon.translateEnum(UxScheduledJobMode.class, mode.name()) : null).withValue_((Object)mode));
        boolean bl = hasErrors = job != null && job.hasErrors();
        if (disabled) {
            cells.add(new UxTableCell(null));
        } else {
            cells.add(new UxTableCell(hasErrors ? babylon.translate("yesL", new Serializable[0]) : babylon.translate("noL", new Serializable[0])));
        }
        if (disabled) {
            cells.add(new UxTableCell(null).withValue_(-1L));
        } else {
            String nextTriggerTime = job != null ? job.getNextTriggerTime() : "-";
            long nextTriggerTimeMS = job != null ? job.getNextTriggerTimeMS() : -1L;
            cells.add(new UxTableCell(nextTriggerTime).withValue_(nextTriggerTimeMS));
        }
        UxStyleLevel styleLevel = hasErrors ? UxStyleLevel.ERROR : null;
        return new UxTableRow(cells).withStyle(styleLevel);
    }

    @Override
    protected void attachUseCase(UxQueryContext queryContext, UxPayloadReply reply) {
        reply.withUseCase(queryContext.getUseCase(UxAdminUseCaseName.Alerts));
    }
}

