/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.ux.admin.queries.alerts;

import crazydev.iccube.server.print.IcCubePrintComponentConfiguration;
import crazydev.iccube.server.request.processor.print.IcCubePrintService;
import crazydev.iccube.server.request.processor.print.paper.IcCubePaperSizes;
import crazydev.iccube.server.scheduler.definition.AlertAttachmentType;
import crazydev.iccube.server.scheduler.definition.IcCubeSchedulerAlertJobDefinition;
import crazydev.iccube.server.scheduler.definition.IcCubeSchedulerJobDefinition;
import crazydev.iccube.server.scheduler.runtime.IcCubeSchedulerKind;
import crazydev.iccube.ux.admin.queries.completion.UxCompleteQueryMeta;
import crazydev.iccube.ux.admin.queries.completion.UxCompletionType;
import crazydev.iccube.ux.admin.queries.scheduler.common.UxAbstractSchedulerTriggerModelType;
import crazydev.iccube.ux.admin.queries.scheduler.common.UxScheduledJobModelType;
import crazydev.iccube.ux.builder.queries.fs.UxFileChooserNodeType;
import crazydev.iccube.ux.builder.queries.fs.UxFileChooserQueryMeta;
import crazydev.iccube.ux.common.field.UxFieldEditorMeta;
import crazydev.iccube.ux.common.field.UxFieldTypes;
import crazydev.iccube.ux.common.model.UxModelType;
import crazydev.iccube.ux.common.query.UxQueryContext;
import crazydev.iccube.ux.processor.UxBabylonService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class UxAlertModelType
extends UxModelType<IcCubeSchedulerAlertJobDefinition> {
    public static final String GROUP_GENERAL = "group.alertGeneral";
    public static final String GROUP_TRIGGER = "group.alertTrigger";
    public static final String GROUP_MDX = "group.alertMdx";
    public static final String GROUP_EMAIL = "group.alertEMail";
    public static final String GROUP_ATTACHEMENT = "group.alertAttachment";
    public static final String GROUP_PDF_DEPRECATED = "group.alertPDF_deprecated";

    public UxAlertModelType() {
        super("alert", IcCubeSchedulerAlertJobDefinition.class);
    }

    @Override
    protected void doSetupProperties(UxQueryContext context, @Nullable Object modelOwner, @Nullable IcCubeSchedulerAlertJobDefinition model) {
        IcCubePrintComponentConfiguration configuration;
        IcCubePaperSizes paperSizes;
        UxBabylonService babylon = context.getUxBabylonService();
        this.addProperty(context, GROUP_GENERAL, IcCubeSchedulerJobDefinition.UUID_, UxFieldTypes.STRING, true, true, true);
        this.addProperty(context, GROUP_GENERAL, IcCubeSchedulerAlertJobDefinition.ALERT_NAME, UxFieldTypes.STRING, true, false, true);
        this.addProperty(context, GROUP_GENERAL, IcCubeSchedulerJobDefinition.DESCRIPTION, UxFieldTypes.STRING, true, false, true);
        this.addProperty(context, GROUP_GENERAL, IcCubeSchedulerJobDefinition.SCHEDULED_INFO, UxScheduledJobModelType.create(context), false, true, true, false);
        this.addProperty(context, GROUP_GENERAL, IcCubeSchedulerJobDefinition.ENABLED, UxFieldTypes.BOOLEAN, true, false, false);
        this.addProperty(context, GROUP_GENERAL, IcCubeSchedulerJobDefinition.CONTINUE_ON_ERROR, UxFieldTypes.BOOLEAN, true, false, false);
        this.addProperty(context, GROUP_TRIGGER, IcCubeSchedulerJobDefinition.TRIGGER, UxAbstractSchedulerTriggerModelType.create(context, IcCubeSchedulerKind.ALERTS), true, false, true);
        this.addProperty(context, GROUP_MDX, IcCubeSchedulerAlertJobDefinition.ROLE_NAME, UxFieldTypes.STRING, UxCompleteQueryMeta.createAction(context, UxCompletionType.role, new String[0]), true, true, false, true);
        this.addProperty(context, GROUP_MDX, IcCubeSchedulerAlertJobDefinition.LOCALE, UxFieldTypes.LOCALE(babylon), true, false, false);
        this.addProperty(context, GROUP_MDX, IcCubeSchedulerAlertJobDefinition.SCHEMA_NAME, UxFieldTypes.STRING, UxCompleteQueryMeta.createAction(context, UxCompletionType.deployedSchema, new String[0]), true, true, false, true);
        this.addProperty(context, GROUP_MDX, IcCubeSchedulerAlertJobDefinition.ALERT_CUBE_NAME, UxFieldTypes.STRING, true, false, false);
        this.addProperty(context, GROUP_MDX, IcCubeSchedulerAlertJobDefinition.ALERT_STATEMENT, UxFieldTypes.STRING, true, false, true);
        this.addProperty(context, GROUP_EMAIL, IcCubeSchedulerAlertJobDefinition.TO_ADDRESSES, UxFieldTypes.STRING, true, false, true);
        this.addProperty(context, GROUP_EMAIL, IcCubeSchedulerAlertJobDefinition.SUBJECT, UxFieldTypes.STRING, true, false, true);
        this.addProperty(context, GROUP_EMAIL, IcCubeSchedulerAlertJobDefinition.BODY, UxFieldTypes.TEXT, UxFieldEditorMeta.createForPreview(3), true, false, true);
        this.addProperty(context, GROUP_EMAIL, IcCubeSchedulerAlertJobDefinition.TO_ADDRESSES_ON_ERROR, UxFieldTypes.STRING, true, false, false);
        this.addProperty(context, GROUP_EMAIL, IcCubeSchedulerAlertJobDefinition.SUBJECT_ON_ERROR, UxFieldTypes.STRING, true, false, false);
        this.addProperty(context, GROUP_EMAIL, IcCubeSchedulerAlertJobDefinition.BODY_ON_ERROR, UxFieldTypes.TEXT, UxFieldEditorMeta.createForPreview(3), true, false, false);
        this.addProperty(context, GROUP_ATTACHEMENT, IcCubeSchedulerAlertJobDefinition.V8_REPORT_PDF, UxFieldTypes.FILE, UxFileChooserQueryMeta.createActionForDashboard(context, UxFileChooserNodeType.File), true, true, false, false);
        this.addProperty(context, GROUP_ATTACHEMENT, IcCubeSchedulerAlertJobDefinition.V8_REPORT_PDF_TIMEOUT, UxFieldTypes.INTEGER, true, false, false);
        this.addProperty(context, GROUP_ATTACHEMENT, IcCubeSchedulerAlertJobDefinition.ATTACHMENT_TYPE, UxFieldTypes.ENUM(babylon, AlertAttachmentType.class), true, false, false);
        this.addProperty(context, GROUP_ATTACHEMENT, IcCubeSchedulerAlertJobDefinition.V8_FILE_NAME, UxFieldTypes.STRING, IcCubeSchedulerAlertJobDefinition.ATTACHMENT_TYPE, AlertAttachmentType.PDF);
        IcCubePrintService printService = context.getApplicationContext().getPrintService();
        ArrayList<String> pageSizeValues = new ArrayList<String>();
        if (printService != null && (paperSizes = (configuration = printService.getConfiguration()).getPaperSizes()) != null) {
            pageSizeValues.addAll(paperSizes.getNames());
        }
        this.addProperty(context, GROUP_ATTACHEMENT, IcCubeSchedulerAlertJobDefinition.V8_PAGE_SIZE, UxFieldTypes.ENUMERABLE(babylon, String.class, pageSizeValues), IcCubeSchedulerAlertJobDefinition.ATTACHMENT_TYPE, AlertAttachmentType.PDF);
        ArrayList<String> pageOrientationValues = new ArrayList<String>();
        if (printService != null) {
            pageOrientationValues.add("Portrait");
            pageOrientationValues.add("Landscape");
        }
        this.addProperty(context, GROUP_ATTACHEMENT, IcCubeSchedulerAlertJobDefinition.V8_PAGE_ORIENTATION, UxFieldTypes.ENUMERABLE(babylon, String.class, pageOrientationValues), IcCubeSchedulerAlertJobDefinition.ATTACHMENT_TYPE, AlertAttachmentType.PDF);
        this.addProperty(context, GROUP_ATTACHEMENT, IcCubeSchedulerAlertJobDefinition.V8_REPORT_WIDGET_FILE_NAME, UxFieldTypes.STRING, IcCubeSchedulerAlertJobDefinition.ATTACHMENT_TYPE, AlertAttachmentType.WIDGET);
        this.addProperty(context, GROUP_ATTACHEMENT, IcCubeSchedulerAlertJobDefinition.V8_REPORT_WIDGET, UxFieldTypes.STRING, IcCubeSchedulerAlertJobDefinition.ATTACHMENT_TYPE, AlertAttachmentType.WIDGET);
        List<String> widgetExportTypeValues = Arrays.asList("XLSX", "CSV");
        this.addProperty(context, GROUP_ATTACHEMENT, IcCubeSchedulerAlertJobDefinition.V8_REPORT_WIDGET_EXPORT_TYPE, UxFieldTypes.ENUMERABLE(babylon, String.class, widgetExportTypeValues), IcCubeSchedulerAlertJobDefinition.ATTACHMENT_TYPE, AlertAttachmentType.WIDGET);
    }
}

