/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.server.scheduler.validation;

import crazydev.common.exception.CdErrorCode;
import crazydev.common.utils.CdStringUtils;
import crazydev.iccube.contextual.OlapContextualBigException;
import crazydev.iccube.olap.loggers.OlapLoggers;
import crazydev.iccube.server.scheduler.definition.IcCubeSchedulerDefinition;
import crazydev.iccube.server.scheduler.definition.IcCubeSchedulerJobDefinition;
import crazydev.iccube.server.scheduler.errors.IcCubeSchedulerDefinitionErrorCode;
import crazydev.iccube.server.scheduler.errors.IcCubeSchedulerDefinitionErrorException;
import crazydev.iccube.server.scheduler.errors.IcCubeSchedulerDefinitionErrorManager;
import crazydev.iccube.server.scheduler.validation.IcCubeSchedulerAbstractDefinitionValidator;
import crazydev.iccube.server.scheduler.validation.IcCubeSchedulerDefinitionValidationContext;
import crazydev.iccube.server.scheduler.validation.IcCubeSchedulerDefinitionValidationEnabled;
import crazydev.iccube.validation.IOlapValidationEnabled;
import crazydev.iccube.validation.OlapValidator;
import crazydev.iccube.validation.OlapValidatorContext;
import java.io.Serializable;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class IcCubeSchedulerDefinitionValidator
extends IcCubeSchedulerAbstractDefinitionValidator<IcCubeSchedulerDefinitionValidationEnabled, IcCubeSchedulerDefinition> {
    @Override
    protected void doValidate(IcCubeSchedulerDefinitionValidationContext context, @Nullable IcCubeSchedulerDefinitionValidationEnabled owner, IcCubeSchedulerDefinition me) {
        int threadCount = me.getThreadCount();
        if (threadCount < -1 || threadCount == 0) {
            context.addError((CdErrorCode)IcCubeSchedulerDefinitionErrorCode.THREAD_COUNT_INVALID, new Serializable[]{Integer.valueOf(threadCount)});
        }
        this.validateUniqueChildrenUuid(context, me, me.getJobs());
        if (context.isWithJobDefinitions()) {
            this.validateChildren(context, me, me.getJobs());
        }
    }

    protected void validateUniqueChildrenUuid(IcCubeSchedulerDefinitionValidationContext context, IcCubeSchedulerDefinition parent, @Nullable List<IcCubeSchedulerJobDefinition> children) {
        if (children != null) {
            HashSet<String> uuids = new HashSet<String>();
            for (IcCubeSchedulerJobDefinition child : children) {
                String uuid = child.getUuid();
                if (CdStringUtils.isNullOrBlank((String)uuid)) {
                    context.addError((CdErrorCode)IcCubeSchedulerDefinitionErrorCode.UUID_MISSING, new Serializable[0]);
                    continue;
                }
                if (uuids.contains(uuid)) {
                    context.addError((CdErrorCode)IcCubeSchedulerDefinitionErrorCode.UUID_DUPLICATED, new Serializable[]{uuid});
                    continue;
                }
                uuids.add(uuid);
            }
        }
    }

    public static void validateDefinition(@Nullable IcCubeSchedulerDefinitionValidationEnabled parent, IcCubeSchedulerDefinitionValidationEnabled definition, boolean withJobDefinitions) throws OlapContextualBigException {
        IcCubeSchedulerDefinitionErrorManager errorManager = new IcCubeSchedulerDefinitionErrorManager(false);
        IcCubeSchedulerDefinitionValidationContext validationContext = new IcCubeSchedulerDefinitionValidationContext(errorManager, withJobDefinitions);
        IcCubeSchedulerDefinitionValidator.doValidateDefinition(validationContext, parent, definition);
    }

    private static void doValidateDefinition(IcCubeSchedulerDefinitionValidationContext validationContext, @Nullable IcCubeSchedulerDefinitionValidationEnabled parent, IcCubeSchedulerDefinitionValidationEnabled definition) throws OlapContextualBigException {
        IcCubeSchedulerDefinitionErrorManager errorManager = (IcCubeSchedulerDefinitionErrorManager)validationContext.getErrorManager();
        try {
            OlapValidator validator = definition.getValidator();
            validator.validate((OlapValidatorContext)validationContext, (IOlapValidationEnabled)parent, (IOlapValidationEnabled)definition);
            if (errorManager.hasErrors()) {
                throw errorManager.asException();
            }
        }
        catch (IcCubeSchedulerDefinitionErrorException ex) {
            OlapLoggers.SCHEDULER.warn((Object)"Scheduler : validation error-exception", (Throwable)((Object)ex));
            errorManager.addError(ex.getError());
            throw errorManager.asException();
        }
        catch (RuntimeException ex) {
            errorManager.addException(ex);
            throw errorManager.asException();
        }
    }
}

