/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.server.scheduler.validation;

import crazydev.common.exception.CdErrorCode;
import crazydev.common.utils.CdStringUtils;
import crazydev.iccube.server.scheduler.definition.IcCubeSchedulerJobDefinition;
import crazydev.iccube.server.scheduler.definition.trigger.IcCubeSchedulerDailyTriggerDefinition;
import crazydev.iccube.server.scheduler.errors.IcCubeSchedulerDefinitionErrorCode;
import crazydev.iccube.server.scheduler.validation.IcCubeSchedulerDefinitionValidationContext;
import crazydev.iccube.server.scheduler.validation.IcCubeSchedulerTriggerDefinitionValidator;
import java.io.Serializable;
import org.jetbrains.annotations.Nullable;

public class IcCubeSchedulerDailyTriggerDefinitionValidator
extends IcCubeSchedulerTriggerDefinitionValidator<IcCubeSchedulerDailyTriggerDefinition> {
    @Override
    protected void doValidate(IcCubeSchedulerDefinitionValidationContext context, @Nullable IcCubeSchedulerJobDefinition owner, IcCubeSchedulerDailyTriggerDefinition me) {
        String days;
        String[] parts;
        super.doValidate(context, owner, me);
        if (CdStringUtils.isNotNullAndNotBlank((String)me.getDaysOfMonth()) && (parts = (days = me.getDaysOfMonth()).split(",")) != null && parts.length > 0) {
            try {
                for (String part : parts) {
                    int val = Integer.parseInt(part);
                    if (val != 0) continue;
                    context.addError(IcCubeSchedulerDailyTriggerDefinition.DAYS_OF_MONTH, (CdErrorCode)IcCubeSchedulerDefinitionErrorCode.DAYS_OF_MONTH_INVALID, new Serializable[]{days});
                    break;
                }
            }
            catch (NumberFormatException ex) {
                context.addError(IcCubeSchedulerDailyTriggerDefinition.DAYS_OF_MONTH, (CdErrorCode)IcCubeSchedulerDefinitionErrorCode.DAYS_OF_MONTH_INVALID, new Serializable[]{days});
            }
        }
        if (this.validateNotBlankField(context, IcCubeSchedulerDailyTriggerDefinition.TIME_HOUR_MINUTE, me.getTimeHourMinute())) {
            String time = me.getTimeHourMinute();
            parts = time.split(":");
            if (parts == null || parts.length != 2) {
                context.addError(IcCubeSchedulerDailyTriggerDefinition.TIME_HOUR_MINUTE, (CdErrorCode)IcCubeSchedulerDefinitionErrorCode.HOURS_MINUTES_INVALID, new Serializable[]{time});
            } else {
                try {
                    String hours = parts[0];
                    int h = Integer.valueOf(hours);
                    this.validateHours(context, IcCubeSchedulerDailyTriggerDefinition.TIME_HOUR_MINUTE, h);
                    String minutes = parts[1];
                    int m = Integer.valueOf(minutes);
                    this.validateMinutes(context, IcCubeSchedulerDailyTriggerDefinition.TIME_HOUR_MINUTE, m);
                }
                catch (NumberFormatException ex) {
                    context.addError(IcCubeSchedulerDailyTriggerDefinition.TIME_HOUR_MINUTE, (CdErrorCode)IcCubeSchedulerDefinitionErrorCode.HOURS_MINUTES_INVALID, new Serializable[]{time});
                }
            }
        }
    }
}

