/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.server.scheduler.validation;

import crazydev.common.exception.CdErrorCode;
import crazydev.common.utils.CdStringUtils;
import crazydev.iccube.server.scheduler.definition.AlertAttachmentType;
import crazydev.iccube.server.scheduler.definition.IcCubeSchedulerAlertJobDefinition;
import crazydev.iccube.server.scheduler.definition.IcCubeSchedulerDefinition;
import crazydev.iccube.server.scheduler.errors.IcCubeSchedulerDefinitionErrorCode;
import crazydev.iccube.server.scheduler.validation.IcCubeSchedulerDefinitionValidationContext;
import crazydev.iccube.server.scheduler.validation.IcCubeSchedulerJobDefinitionValidator;
import jakarta.mail.internet.AddressException;
import jakarta.mail.internet.InternetAddress;
import java.io.Serializable;
import org.jetbrains.annotations.Nullable;

public class IcCubeSchedulerAlertJobDefinitionValidator
extends IcCubeSchedulerJobDefinitionValidator<IcCubeSchedulerAlertJobDefinition> {
    @Override
    protected void doValidate(IcCubeSchedulerDefinitionValidationContext context, @Nullable IcCubeSchedulerDefinition owner, IcCubeSchedulerAlertJobDefinition me) {
        InternetAddress[] parsed;
        String addresses;
        super.doValidate(context, owner, me);
        this.validateNotBlankField(context, IcCubeSchedulerAlertJobDefinition.SCHEMA_NAME, me.getSchemaName());
        this.validateNotBlankField(context, IcCubeSchedulerAlertJobDefinition.ALERT_NAME, me.getAlertName());
        this.validateNotBlankField(context, IcCubeSchedulerAlertJobDefinition.ALERT_STATEMENT, me.getAlertStatement());
        this.validateNotBlankField(context, IcCubeSchedulerAlertJobDefinition.TO_ADDRESSES, me.getToAddresses());
        this.validateNotBlankField(context, IcCubeSchedulerAlertJobDefinition.SUBJECT, me.getSubject());
        this.validateNotBlankField(context, IcCubeSchedulerAlertJobDefinition.BODY, me.getBody());
        if (me.getAttachmentType() == AlertAttachmentType.WIDGET) {
            this.validateNotBlankField(context, IcCubeSchedulerAlertJobDefinition.V8_REPORT_PDF, me.getV8ReportPdf());
            this.validateNotBlankField(context, IcCubeSchedulerAlertJobDefinition.V8_REPORT_WIDGET, me.getV8ReportWidget());
        }
        if (me.getAttachmentType() == AlertAttachmentType.PDF) {
            this.validateNotBlankField(context, IcCubeSchedulerAlertJobDefinition.V8_REPORT_PDF, me.getV8ReportPdf());
        }
        if (CdStringUtils.isNotNullAndNotBlank((String)(addresses = me.getToAddresses()))) {
            try {
                parsed = InternetAddress.parse((String)addresses);
                me.setParsedToAddresses(parsed);
            }
            catch (AddressException ex) {
                context.addError(IcCubeSchedulerAlertJobDefinition.TO_ADDRESSES, (CdErrorCode)IcCubeSchedulerDefinitionErrorCode.ALERT_INVALID_TO_ADDRESSES, new Serializable[]{addresses});
            }
        }
        if (CdStringUtils.isNotNullAndNotBlank((String)(addresses = me.getToAddressesOnError()))) {
            try {
                parsed = InternetAddress.parse((String)addresses);
                me.setParsedToAddressesOnError(parsed);
            }
            catch (AddressException ex) {
                context.addError(IcCubeSchedulerAlertJobDefinition.TO_ADDRESSES_ON_ERROR, (CdErrorCode)IcCubeSchedulerDefinitionErrorCode.ALERT_INVALID_TO_ADDRESSES, new Serializable[]{addresses});
            }
        }
    }
}

