/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.server.scheduler.runtime.timegenerator;

import crazydev.iccube.olap.executor.OlapScheduledTimeGenerator;
import crazydev.iccube.server.scheduler.definition.trigger.IcCubeSchedulerContinuousTriggerDefinition;
import java.util.Calendar;
import java.util.GregorianCalendar;

public class OlapContinuousExcludingPeriodScheduledTimeGenerator
implements OlapScheduledTimeGenerator {
    private final long initialDelayMS;
    private final IcCubeSchedulerContinuousTriggerDefinition.Period excluding;

    public OlapContinuousExcludingPeriodScheduledTimeGenerator(IcCubeSchedulerContinuousTriggerDefinition trigger) {
        this.initialDelayMS = trigger.getTimeUnit().toMillis(trigger.getInitialDelay());
        this.excluding = trigger.getValidatedExcluding();
        if (this.excluding == null) {
            throw new RuntimeException("internal error: unexpected empty excluding period");
        }
    }

    public boolean isTerminated() {
        return false;
    }

    public long generateNextTimeMS(int runCount, boolean startup, long nowMS) {
        long timeMS = nowMS;
        if (runCount == 0 && this.initialDelayMS > 0L) {
            timeMS += this.initialDelayMS;
        }
        Calendar calendar = GregorianCalendar.getInstance();
        calendar.setTimeInMillis(nowMS);
        calendar.set(11, this.excluding.from.getHourOfDay());
        calendar.set(12, this.excluding.from.getMinuteOfHour());
        calendar.set(13, 0);
        calendar.set(14, 0);
        long toMS = calendar.getTimeInMillis();
        calendar.setTimeInMillis(nowMS);
        calendar.set(11, this.excluding.to.getHourOfDay());
        calendar.set(12, this.excluding.to.getMinuteOfHour());
        calendar.set(13, 0);
        calendar.set(14, 0);
        long fromMS = calendar.getTimeInMillis();
        if (timeMS >= fromMS && timeMS < toMS) {
            return toMS;
        }
        return timeMS;
    }
}

