/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.server.scheduler.runtime;

import crazydev.common.thread.CdThreadSupport;
import crazydev.common.thread.CdThreadSupportLevel;
import crazydev.iccube.contextual.OlapContextualError;
import crazydev.iccube.olap.component.OlapEngineComponent;
import crazydev.iccube.olap.component.schemas.IOlapEngineSchemaDataUpdatedListener;
import crazydev.iccube.olap.executor.OlapScheduledThreadPoolExecutorService;
import crazydev.iccube.olap.loggers.OlapLoggers;
import crazydev.iccube.server.scheduler.definition.IcCubeSchedulerJobDefinition;
import crazydev.iccube.server.scheduler.definition.trigger.IcCubeSchedulerOnDataChangedTriggerDefinition;
import crazydev.iccube.server.scheduler.runtime.IcCubeSchedulerJob;
import crazydev.iccube.server.scheduler.runtime.IcCubeSchedulerJobBusinessLogic;
import crazydev.iccube.server.scheduler.runtime.IcCubeSchedulerJobRunnable;
import crazydev.iccube.server.scheduler.runtime.IcCubeSchedulerKind;
import java.io.File;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.Nullable;

@CdThreadSupport(value=CdThreadSupportLevel.THREAD_SAFE)
public class IcCubeSchedulerOnDataChangedJob
extends IcCubeSchedulerJob {
    private final OlapEngineComponent olapEngine;
    private final OlapScheduledThreadPoolExecutorService executorService;
    private final IcCubeSchedulerOnDataChangedTriggerDefinition trigger;
    private final IcCubeSchedulerJobRunnable job;
    private final IOlapEngineSchemaDataUpdatedListener schemaListener;
    private final AtomicReference<ScheduledFuture<?>> future = new AtomicReference();
    private volatile boolean cancelled;

    public IcCubeSchedulerOnDataChangedJob(IcCubeSchedulerKind kind, OlapEngineComponent olapEngine, OlapScheduledThreadPoolExecutorService executorService, IcCubeSchedulerOnDataChangedTriggerDefinition trigger, IcCubeSchedulerJobRunnable job) {
        super(kind);
        this.olapEngine = olapEngine;
        this.executorService = executorService;
        this.trigger = trigger;
        this.job = job;
        IcCubeSchedulerJobDefinition definition = job.getJobDefinition();
        String schemaName = definition.getSchemaForOnDataChanged();
        if (schemaName == null) {
            throw new RuntimeException("internal error: missing schema for on-data-changed trigger [" + definition.getContextVisualId() + "]");
        }
        this.schemaListener = new SchemaDataUpdatedListener(this, schemaName);
        this.olapEngine.addSchemaDataUpdatedListener(job.getTenant(), this.schemaListener);
        this.cancelled = false;
    }

    private void onDataChanged() {
        ScheduledFuture<?> future_;
        if (this.cancelled) {
            return;
        }
        IcCubeSchedulerJobDefinition definition = this.job.getJobDefinition();
        String schemaName = definition.getSchemaForOnDataChanged();
        if (OlapLoggers.SCHEDULER.isDebugEnabled()) {
            OlapLoggers.SCHEDULER.debug((Object)(this.kind.logName() + " on-data-changed [" + schemaName + "] " + definition.getContextVisualId()));
        }
        if ((future_ = this.future.get()) != null && !future_.isDone() && OlapLoggers.SCHEDULER.isDebugEnabled()) {
            OlapLoggers.SCHEDULER.debug((Object)(this.kind.logName() + " on-data-changed ignored (prev. still running) [" + schemaName + "] " + definition.getContextVisualId()));
        }
        long delay = this.trigger.getDelay();
        TimeUnit unit = this.trigger.getTimeUnit();
        this.future.set(this.executorService.schedule((Runnable)this.job, delay, unit));
    }

    @Override
    public void cancel() {
        this.cancelled = true;
        this.olapEngine.removeSchemaDataUpdatedListener(this.job.getTenant(), this.schemaListener);
        ScheduledFuture<?> future_ = this.future.get();
        if (future_ != null) {
            future_.cancel(true);
        }
    }

    @Override
    public boolean isDone() {
        return this.cancelled;
    }

    @Override
    public IcCubeSchedulerJobDefinition getDefinition() {
        IcCubeSchedulerJobDefinition definition = this.job.getJobDefinition();
        return definition;
    }

    @Override
    public boolean isEnabled() {
        IcCubeSchedulerJobDefinition definition = this.job.getJobDefinition();
        return definition.isEnabled();
    }

    @Override
    public IcCubeSchedulerOnDataChangedTriggerDefinition getTrigger() {
        return this.trigger;
    }

    @Override
    public boolean isBoundTo(ScheduledFuture<?> future) {
        return super.isBoundTo(future) || this.future == future;
    }

    @Override
    public String getScheduledInfoForLogging() {
        IcCubeSchedulerJobDefinition definition = this.job.getJobDefinition();
        return "(" + definition.getInfoForLogging() + ") " + definition.getTrigger().getInfoForLogging();
    }

    @Override
    public boolean isForDefinition(String definitionUuid) {
        IcCubeSchedulerJobBusinessLogic businessLogic = this.job.getBusinessLogic();
        return ((IcCubeSchedulerJobDefinition)businessLogic.getJobDefinition()).getUuid().equals(definitionUuid);
    }

    @Override
    public boolean isForLoadSchema(File backups, File factory) {
        IcCubeSchedulerJobBusinessLogic businessLogic = this.job.getBusinessLogic();
        return businessLogic.isLoadingSchema(backups, factory);
    }

    @Override
    @Nullable
    public String getLatestRequestUuid() {
        return this.job.getLatestRequestUuid();
    }

    @Override
    public boolean isOnError() {
        return false;
    }

    @Override
    public List<OlapContextualError> getErrors() {
        return Collections.emptyList();
    }

    class SchemaDataUpdatedListener
    implements IOlapEngineSchemaDataUpdatedListener {
        final String schemaName;
        final /* synthetic */ IcCubeSchedulerOnDataChangedJob this$0;

        SchemaDataUpdatedListener(IcCubeSchedulerOnDataChangedJob this$0, String schemaName) {
            IcCubeSchedulerOnDataChangedJob icCubeSchedulerOnDataChangedJob = this$0;
            Objects.requireNonNull(icCubeSchedulerOnDataChangedJob);
            this.this$0 = icCubeSchedulerOnDataChangedJob;
            this.schemaName = schemaName;
        }

        public void onSchemaDataUpdated(String schema) {
            if (this.schemaName.equals(schema)) {
                this.this$0.onDataChanged();
            }
        }
    }
}

