/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.server.scheduler.runtime;

import crazydev.common.babylon.CdBabylonService;
import crazydev.common.babylon.CdLoggingBabylonService;
import crazydev.common.collection.CdPair;
import crazydev.common.fs.CdVFileSystem;
import crazydev.common.utils.CdStringUtils;
import crazydev.iccube.builder.factory.schema.IOlapBuilderSchemaDefFactory;
import crazydev.iccube.common.executor.OlapThreadFactory;
import crazydev.iccube.contextual.OlapContextualBigException;
import crazydev.iccube.contextual.OlapContextualError;
import crazydev.iccube.directories.OlapDirectoriesResolved;
import crazydev.iccube.embedded.IcCubeEngine;
import crazydev.iccube.olap.component.OlapEngineComponent;
import crazydev.iccube.olap.component.schemas.IOlapEngineSchemaLifeCycleListener;
import crazydev.iccube.olap.executor.OlapScheduledThreadPoolExecutorService;
import crazydev.iccube.olap.loggers.OlapLoggers;
import crazydev.iccube.olap.schema.OlapSchema;
import crazydev.iccube.pub.tenant.OlapTenant;
import crazydev.iccube.server.scheduler.definition.IcCubeSchedulerAlertJobDefinition;
import crazydev.iccube.server.scheduler.definition.IcCubeSchedulerDefinition;
import crazydev.iccube.server.scheduler.definition.IcCubeSchedulerJobDefinition;
import crazydev.iccube.server.scheduler.definition.IcCubeSchedulerLoadSchemaJobDefinition;
import crazydev.iccube.server.scheduler.definition.trigger.IcCubeSchedulerContinuousTriggerDefinition;
import crazydev.iccube.server.scheduler.definition.trigger.IcCubeSchedulerCronTriggerDefinition;
import crazydev.iccube.server.scheduler.definition.trigger.IcCubeSchedulerDailyHoursTriggerDefinition;
import crazydev.iccube.server.scheduler.definition.trigger.IcCubeSchedulerDailyTriggerDefinition;
import crazydev.iccube.server.scheduler.definition.trigger.IcCubeSchedulerDisabledTriggerDefinition;
import crazydev.iccube.server.scheduler.definition.trigger.IcCubeSchedulerFixedRateTriggerDefinition;
import crazydev.iccube.server.scheduler.definition.trigger.IcCubeSchedulerOnDataChangedTriggerDefinition;
import crazydev.iccube.server.scheduler.definition.trigger.IcCubeSchedulerOnceTriggerDefinition;
import crazydev.iccube.server.scheduler.definition.trigger.IcCubeSchedulerTriggerDefinition;
import crazydev.iccube.server.scheduler.errors.IcCubeSchedulerDefinitionError;
import crazydev.iccube.server.scheduler.errors.IcCubeSchedulerDefinitionErrorCode;
import crazydev.iccube.server.scheduler.errors.IcCubeSchedulerDefinitionErrorException;
import crazydev.iccube.server.scheduler.runtime.IcCubeScheduler;
import crazydev.iccube.server.scheduler.runtime.IcCubeSchedulerFileDefinitionHelper;
import crazydev.iccube.server.scheduler.runtime.IcCubeSchedulerInvalidJob;
import crazydev.iccube.server.scheduler.runtime.IcCubeSchedulerJob;
import crazydev.iccube.server.scheduler.runtime.IcCubeSchedulerJobBusinessLogic;
import crazydev.iccube.server.scheduler.runtime.IcCubeSchedulerJobBusinessLogics;
import crazydev.iccube.server.scheduler.runtime.IcCubeSchedulerJobRunnable;
import crazydev.iccube.server.scheduler.runtime.IcCubeSchedulerKind;
import crazydev.iccube.server.scheduler.runtime.IcCubeSchedulerSchemaLifeCycleListener;
import crazydev.iccube.server.scheduler.validation.IcCubeSchedulerDefinitionValidator;
import java.io.File;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.Nullable;

class IcCubeSchedulerGuts {
    private static final Map<Class<? extends IcCubeSchedulerTriggerDefinition>, IcCubeScheduler.TriggerScheduler> triggerSchedulers = new HashMap<Class<? extends IcCubeSchedulerTriggerDefinition>, IcCubeScheduler.TriggerScheduler>();
    private final IcCubeScheduler scheduler;
    private final IcCubeEngine engine;
    private final OlapScheduledThreadPoolExecutorService executorService;
    @Nullable
    private final OlapTenant tenant;
    private final OlapDirectoriesResolved directories;
    private final IcCubeSchedulerKind kind;
    private final Object globalLOCK = new Object();
    private final IcCubeSchedulerFileDefinitionHelper helper;
    private final List<IcCubeSchedulerJobDefinition> defs = new ArrayList<IcCubeSchedulerJobDefinition>();
    private final List<IcCubeSchedulerJob> scheduledJobs = new ArrayList<IcCubeSchedulerJob>();
    private int currentRevNumber = -1;
    @Nullable
    private List<OlapContextualError> applyDefinitionErrors;

    IcCubeSchedulerGuts(IcCubeScheduler scheduler, IcCubeEngine engine, OlapDirectoriesResolved directories, IcCubeSchedulerKind kind) {
        this.scheduler = scheduler;
        this.engine = engine;
        this.kind = kind;
        if (directories != null) {
            this.tenant = directories.getTenant();
            this.directories = directories;
            this.helper = new IcCubeSchedulerFileDefinitionHelper(kind, directories.getVfs(), directories.getTmpDirectory(), directories.getSchedulerDirectory());
        } else {
            this.tenant = null;
            this.directories = null;
            this.helper = new IcCubeSchedulerFileDefinitionHelper(kind, new CdVFileSystem(), null, null);
        }
        this.executorService = new OlapScheduledThreadPoolExecutorService(this, kind.logName(), 1, (ThreadFactory)new OlapThreadFactory(kind.threadName())){
            final /* synthetic */ IcCubeSchedulerGuts this$0;
            {
                IcCubeSchedulerGuts icCubeSchedulerGuts = this$0;
                Objects.requireNonNull(icCubeSchedulerGuts);
                this.this$0 = icCubeSchedulerGuts;
                super(arg0, arg1, arg2);
            }

            protected void onTaskDone(ScheduledFuture<?> task) {
                super.onTaskDone(task);
                this.this$0.onTaskDone(task);
            }
        };
        if (kind == IcCubeSchedulerKind.SCHEMAS && this.engine != null) {
            OlapEngineComponent olapEngine = this.engine.getOlapEngineComponent();
            olapEngine.addSchemaLifeCycleListener(this.tenant, (IOlapEngineSchemaLifeCycleListener)new IcCubeSchedulerSchemaLifeCycleListener(this));
        }
    }

    private String logPrefix() {
        if (this.tenant == null) {
            return this.kind.logName();
        }
        return this.kind.logName() + OlapTenant.info((OlapTenant)this.tenant);
    }

    public void shutdownNow() {
        OlapLoggers.SCHEDULER.info((Object)(this.logPrefix() + " shutdown requested"));
        this.executorService.shutdownNow();
        OlapLoggers.SCHEDULER.info((Object)(this.logPrefix() + " bye"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void applyDefinition(boolean onStartup) {
        Object object = this.globalLOCK;
        synchronized (object) {
            IcCubeSchedulerDefinition definition;
            ++this.currentRevNumber;
            try {
                definition = this.helper.unmarshallDefinitionFromDirectory();
                if (definition == null) {
                    OlapLoggers.SCHEDULER.warn((Object)(this.logPrefix() + " no definition file."));
                    return;
                }
            }
            catch (IcCubeSchedulerDefinitionErrorException ex) {
                OlapLoggers.SCHEDULER.error((Object)(this.logPrefix() + " definition file error (e.g., invalid XML, ...)."), (Throwable)((Object)ex));
                this.applyDefinitionErrors = new ArrayList<OlapContextualError>();
                this.applyDefinitionErrors.add(ex.getError());
                return;
            }
            try {
                IcCubeSchedulerDefinitionValidator.validateDefinition(null, definition, false);
            }
            catch (OlapContextualBigException ex) {
                OlapLoggers.SCHEDULER.error((Object)(this.logPrefix() + " definition file validation error(s)"));
                for (OlapContextualError error : ex.getErrors()) {
                    OlapLoggers.SCHEDULER.error((Object)(this.logPrefix() + "  error : " + error.asFullMessage((CdBabylonService)CdLoggingBabylonService.INSTANCE)));
                }
                this.applyDefinitionErrors = new ArrayList<OlapContextualError>();
                this.applyDefinitionErrors.addAll(ex.getErrors());
                return;
            }
            this.applyDefinition(definition);
        }
    }

    void applyDefinition(IcCubeSchedulerDefinition definition) {
        OlapLoggers.SCHEDULER.info((Object)(this.logPrefix() + " applying all definitions"));
        int threadCount = definition.getActualThreadCount();
        if (this.executorService.getCorePoolSize() != threadCount) {
            this.executorService.setCorePoolSize(threadCount);
        }
        OlapLoggers.SCHEDULER.info((Object)(this.logPrefix() + " setup thread count : " + this.executorService.getCorePoolSize()));
        List<IcCubeSchedulerJobDefinition> jobDefinitions = definition.getJobs();
        this.applyDefinitions(definition, jobDefinitions);
    }

    private void applyDefinitions(IcCubeSchedulerDefinition definition, List<IcCubeSchedulerJobDefinition> jobDefinitions) {
        for (IcCubeSchedulerJobDefinition jobDefinition : jobDefinitions) {
            this.defs.add(jobDefinition);
            try {
                IcCubeSchedulerDefinitionValidator.validateDefinition(definition, jobDefinition, true);
                this.scheduleValidatedDefinition(jobDefinition, false);
            }
            catch (OlapContextualBigException ex) {
                OlapLoggers.SCHEDULER.error((Object)(this.logPrefix() + " job definition validation error(s)"));
                for (OlapContextualError error : ex.getErrors()) {
                    OlapLoggers.SCHEDULER.error((Object)(this.logPrefix() + "  error : " + error.asFullMessage((CdBabylonService)CdLoggingBabylonService.INSTANCE)));
                }
                IcCubeSchedulerInvalidJob job = new IcCubeSchedulerInvalidJob(this.kind, jobDefinition, ex.getErrors());
                this.scheduledJobs.add(job);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void importAndScheduleDefinition(@Nullable Integer callerRevNumber, InputStream xmlFile) throws IcCubeSchedulerDefinitionErrorException {
        Object object = this.globalLOCK;
        synchronized (object) {
            if (callerRevNumber != null) {
                this.assertCallerRevNumber(callerRevNumber);
            }
            this.reset();
            this.helper.importDefinition(xmlFile);
            this.applyDefinition(false);
            if (this.applyDefinitionErrors != null && !this.applyDefinitionErrors.isEmpty()) {
                throw new IcCubeSchedulerDefinitionErrorException(IcCubeSchedulerDefinitionErrorCode.FILE_APPLY_ERROR, new Serializable[0]);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable(value="e.g., definition not enabled")
    @Nullable(value="e.g., definition not enabled") CdPair<Integer, IcCubeSchedulerJob> saveAndScheduleJobDefinition(String savedBy, int callerRevNumber, IcCubeSchedulerJobDefinition jobDefinition) throws IcCubeSchedulerDefinitionErrorException {
        Object object = this.globalLOCK;
        synchronized (object) {
            this.assertCallerRevNumber(callerRevNumber);
            jobDefinition.setPersisted(false);
            this.cancelJob(jobDefinition.getUuid());
            this.defs.removeIf(def -> def.getUuid().equals(jobDefinition.getUuid()));
            this.defs.add(jobDefinition);
            this.scheduledJobs.removeIf(job -> job.isForDefinition(jobDefinition.getUuid()));
            IcCubeSchedulerJob scheduledJob = this.scheduleValidatedDefinition(jobDefinition, false);
            this.helper.saveOrUpdateJobDefinition(savedBy, jobDefinition);
            return new CdPair((Object)this.currentRevNumber, (Object)scheduledJob);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    String duplicateAndScheduleJobDefinition(String savedBy, int callerRevNumber, String uuid, String newName) throws IcCubeSchedulerDefinitionErrorException {
        Object object = this.globalLOCK;
        synchronized (object) {
            IcCubeSchedulerJobDefinition existingByUUID = null;
            IcCubeSchedulerJobDefinition existingByNewName = null;
            for (IcCubeSchedulerJobDefinition def : this.defs) {
                IcCubeSchedulerAlertJobDefinition alert;
                if (def.getUuid().equals(uuid)) {
                    existingByUUID = def;
                }
                if (!(def instanceof IcCubeSchedulerAlertJobDefinition) || !(alert = (IcCubeSchedulerAlertJobDefinition)def).getAlertName().equals(newName)) continue;
                existingByNewName = def;
            }
            if (existingByNewName != null) {
                throw new IcCubeSchedulerDefinitionErrorException(IcCubeSchedulerDefinitionErrorCode.DUPLICATE_NEW_NAME_ERROR, new Serializable[]{newName});
            }
            if (existingByUUID != null) {
                IcCubeSchedulerJobDefinition definition = existingByUUID.duplicate(null, newName, false);
                this.saveAndScheduleJobDefinition(savedBy, callerRevNumber, definition);
                return definition.getUuid();
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    CdPair<Integer, IcCubeSchedulerJob> enableAndScheduleJobDefinition(String savedBy, int callerRevNumber, String uuid) throws IcCubeSchedulerDefinitionErrorException, OlapContextualBigException {
        Object object = this.globalLOCK;
        synchronized (object) {
            IcCubeSchedulerJobDefinition existingByUUID = null;
            for (IcCubeSchedulerJobDefinition def : this.defs) {
                if (!def.getUuid().equals(uuid)) continue;
                existingByUUID = def;
                break;
            }
            if (existingByUUID != null) {
                IcCubeSchedulerJobDefinition definition = existingByUUID.duplicate(uuid, null, true);
                IcCubeSchedulerDefinitionValidator.validateDefinition(null, definition, true);
                return this.saveAndScheduleJobDefinition(savedBy, callerRevNumber, definition);
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    CdPair<Integer, IcCubeSchedulerJob> disableAndScheduleJobDefinition(String savedBy, int callerRevNumber, String uuid) throws IcCubeSchedulerDefinitionErrorException, OlapContextualBigException {
        Object object = this.globalLOCK;
        synchronized (object) {
            IcCubeSchedulerJobDefinition existingByUUID = null;
            for (IcCubeSchedulerJobDefinition def : this.defs) {
                if (!def.getUuid().equals(uuid)) continue;
                existingByUUID = def;
                break;
            }
            if (existingByUUID != null) {
                IcCubeSchedulerJobDefinition definition = existingByUUID.duplicate(uuid, null, false);
                IcCubeSchedulerDefinitionValidator.validateDefinition(null, definition, true);
                return this.saveAndScheduleJobDefinition(savedBy, callerRevNumber, definition);
            }
            return null;
        }
    }

    @Nullable
    private IcCubeSchedulerJob scheduleValidatedDefinition(IcCubeSchedulerJobDefinition jobDefinition, boolean onReActivation) {
        if (!jobDefinition.isEnabled()) {
            OlapLoggers.SCHEDULER.info((Object)(this.logPrefix() + " not scheduled " + jobDefinition.getInfoForLogging()));
            if (jobDefinition instanceof IcCubeSchedulerLoadSchemaJobDefinition) {
                return null;
            }
        }
        try {
            OlapLoggers.SCHEDULER.info((Object)(this.logPrefix() + " scheduling " + jobDefinition.getInfoForLogging()));
            IcCubeSchedulerJobBusinessLogic businessLogic = this.createJobBusinessLogic(jobDefinition);
            IcCubeSchedulerJob scheduledJob = this.schedule(businessLogic, onReActivation);
            OlapLoggers.SCHEDULER.info((Object)(this.logPrefix() + " scheduling done " + jobDefinition.getInfoForLogging()));
            return scheduledJob;
        }
        catch (RuntimeException ex) {
            OlapLoggers.SCHEDULER.error((Object)(this.logPrefix() + " unexpected scheduling error for job : " + jobDefinition.getInfoForLogging()), (Throwable)ex);
            IcCubeSchedulerDefinitionError error = new IcCubeSchedulerDefinitionError(IcCubeSchedulerDefinitionErrorCode.UNEXPECTED_ERROR, new Serializable[]{ex.getMessage()});
            IcCubeSchedulerInvalidJob job = new IcCubeSchedulerInvalidJob(this.kind, jobDefinition, error);
            this.scheduledJobs.add(job);
            return job;
        }
    }

    @Nullable
    private IcCubeSchedulerJob scheduleValidatedDefinitionOutOfBand(IcCubeSchedulerJobDefinition jobDefinition) {
        try {
            OlapLoggers.SCHEDULER.info((Object)(this.logPrefix() + " out-of-band scheduling " + jobDefinition.getInfoForLogging()));
            IcCubeSchedulerJobBusinessLogic businessLogic = this.createJobBusinessLogic(jobDefinition);
            IcCubeSchedulerJob scheduledJob = this.scheduleOutOfBand(businessLogic);
            OlapLoggers.SCHEDULER.info((Object)(this.logPrefix() + " out-of-band scheduling done " + jobDefinition.getInfoForLogging()));
            return scheduledJob;
        }
        catch (RuntimeException ex) {
            OlapLoggers.SCHEDULER.error((Object)(this.logPrefix() + " unexpected out-of-band scheduling error for job : " + jobDefinition.getInfoForLogging()), (Throwable)ex);
            IcCubeSchedulerDefinitionError error = new IcCubeSchedulerDefinitionError(IcCubeSchedulerDefinitionErrorCode.UNEXPECTED_ERROR, new Serializable[]{ex.getMessage()});
            IcCubeSchedulerInvalidJob scheduledJob = new IcCubeSchedulerInvalidJob(this.kind, jobDefinition, error);
            this.attachOutOfBandJob(scheduledJob);
            return scheduledJob;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    IcCubeSchedulerJob runOutOfBand(String savedBy, @Nullable String uuid, @Nullable String name) throws IcCubeSchedulerDefinitionErrorException {
        Object object = this.globalLOCK;
        synchronized (object) {
            if (CdStringUtils.isNotNullAndNotBlank((String)uuid)) {
                IcCubeSchedulerJobDefinition existingByUUID = null;
                for (IcCubeSchedulerJobDefinition def : this.defs) {
                    if (!def.getUuid().equals(uuid)) continue;
                    existingByUUID = def;
                    break;
                }
                if (existingByUUID != null) {
                    return this.scheduleValidatedDefinitionOutOfBand(existingByUUID);
                }
            } else if (CdStringUtils.isNotNullAndNotBlank((String)name)) {
                IcCubeSchedulerJobDefinition existingByNAME = null;
                for (IcCubeSchedulerJobDefinition def : this.defs) {
                    IcCubeSchedulerAlertJobDefinition alert;
                    if (!(def instanceof IcCubeSchedulerAlertJobDefinition) || !(alert = (IcCubeSchedulerAlertJobDefinition)def).getAlertName().equals(name)) continue;
                    existingByNAME = def;
                    break;
                }
                if (existingByNAME != null) {
                    return this.scheduleValidatedDefinitionOutOfBand(existingByNAME);
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void deleteJobDefinition(String savedBy, @Nullable Integer callerRevNumber, String uuid) throws IcCubeSchedulerDefinitionErrorException {
        Object object = this.globalLOCK;
        synchronized (object) {
            if (callerRevNumber != null) {
                this.assertCallerRevNumber(callerRevNumber);
            }
            this.cancelJob(uuid);
            this.helper.deleteJobDefinition(savedBy, uuid);
            this.defs.removeIf(def -> def.getUuid().equals(uuid));
            this.scheduledJobs.removeIf(job -> job.isForDefinition(uuid));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void cancelAllJobs() {
        Object object = this.globalLOCK;
        synchronized (object) {
            for (IcCubeSchedulerJob scheduledJob : this.scheduledJobs) {
                this.cancelJob(scheduledJob);
            }
        }
    }

    void cancelJob(IcCubeSchedulerJob scheduledJob) {
        try {
            scheduledJob.cancel();
        }
        catch (RuntimeException ignored) {
            OlapLoggers.SCHEDULER.warn((Object)(this.logPrefix() + " cancel error [" + scheduledJob.getScheduledInfoForLogging() + "]"), (Throwable)ignored);
        }
    }

    private void cancelJob(String uuid) {
        IcCubeSchedulerJob job = this.getScheduledJob(uuid);
        if (job != null) {
            this.cancelJob(job);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void reset() {
        Object object = this.globalLOCK;
        synchronized (object) {
            this.cancelAllJobs();
            this.defs.clear();
            this.scheduledJobs.clear();
            this.applyDefinitionErrors = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void assertCallerRevNumber(int callerRevNumber) {
        Object object = this.globalLOCK;
        synchronized (object) {
            if (callerRevNumber != this.currentRevNumber) {
                OlapLoggers.SCHEDULER.error((Object)(this.logPrefix() + " optimistic lock error [" + callerRevNumber + "] vs. [" + this.currentRevNumber + "]"));
                throw new IcCubeSchedulerDefinitionErrorException(IcCubeSchedulerDefinitionErrorCode.OPTIMISTIC_LOCKING, Integer.valueOf(callerRevNumber), Integer.valueOf(this.currentRevNumber));
            }
            ++this.currentRevNumber;
        }
    }

    IcCubeSchedulerJobBusinessLogic createJobBusinessLogic(IcCubeSchedulerJobDefinition jobDefinition) {
        return IcCubeSchedulerJobBusinessLogics.createBusinessLogic(this.engine, this.tenant, jobDefinition);
    }

    IcCubeSchedulerJob scheduleOutOfBand(IcCubeSchedulerJobBusinessLogic businessLogic) {
        IcCubeSchedulerOnceTriggerDefinition trigger = new IcCubeSchedulerOnceTriggerDefinition(0, TimeUnit.MILLISECONDS);
        IcCubeScheduler.TriggerScheduler triggerScheduler = triggerSchedulers.get(trigger.getClass());
        if (triggerScheduler == null) {
            throw new RuntimeException("internal error : unexpected scheduler trigger class : " + trigger.getClass().getName());
        }
        IcCubeSchedulerJobRunnable job = new IcCubeSchedulerJobRunnable(this.engine, this.tenant, businessLogic, true);
        IcCubeSchedulerJob scheduledJob = triggerScheduler.schedule(this.scheduler, this.executorService, trigger, job, false);
        this.attachOutOfBandJob(scheduledJob);
        return scheduledJob;
    }

    IcCubeSchedulerJob schedule(IcCubeSchedulerJobBusinessLogic businessLogic, boolean onReActivation) {
        Object jobDefinition = businessLogic.getJobDefinition();
        IcCubeSchedulerTriggerDefinition trigger = !((IcCubeSchedulerJobDefinition)jobDefinition).isEnabled() ? new IcCubeSchedulerDisabledTriggerDefinition() : ((IcCubeSchedulerJobDefinition)jobDefinition).getTrigger();
        IcCubeScheduler.TriggerScheduler triggerScheduler = triggerSchedulers.get(trigger.getClass());
        if (triggerScheduler == null) {
            throw new RuntimeException("internal error : unexpected scheduler trigger class : " + trigger.getClass().getName());
        }
        IcCubeSchedulerJobRunnable job = new IcCubeSchedulerJobRunnable(this.engine, this.tenant, businessLogic, false);
        IcCubeSchedulerJob scheduledJob = triggerScheduler.schedule(this.scheduler, this.executorService, trigger, job, onReActivation);
        this.onJobScheduled(scheduledJob);
        return scheduledJob;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onJobScheduled(IcCubeSchedulerJob scheduledJob) {
        OlapLoggers.SCHEDULER.info((Object)(this.logPrefix() + " scheduled " + scheduledJob.getScheduledInfoForLogging()));
        Object object = this.globalLOCK;
        synchronized (object) {
            this.scheduledJobs.add(scheduledJob);
        }
    }

    void attachOutOfBandJob(IcCubeSchedulerJob outOfBand) {
        for (IcCubeSchedulerJob job : this.scheduledJobs) {
            if (!job.isAttachedTo(outOfBand)) continue;
            job.attachOutOfBandJob(outOfBand);
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onTaskDone(ScheduledFuture<?> task) {
        Object object = this.globalLOCK;
        synchronized (object) {
            for (IcCubeSchedulerJob job : this.scheduledJobs) {
                if (!job.isBoundTo(task)) continue;
                OlapLoggers.SCHEDULER.info((Object)(this.logPrefix() + " job completed [" + job.getScheduledInfoForLogging() + "]"));
                job.onTaskDone(task);
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getCurrentRevNumber() {
        Object object = this.globalLOCK;
        synchronized (object) {
            return this.currentRevNumber;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getActiveJobCount() {
        Object object = this.globalLOCK;
        synchronized (object) {
            int count = 0;
            for (IcCubeSchedulerJob scheduledJob : this.scheduledJobs) {
                if (scheduledJob.isDone()) continue;
                ++count;
            }
            return count;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    List<OlapContextualError> getApplyDefinitionErrors() {
        Object object = this.globalLOCK;
        synchronized (object) {
            return this.applyDefinitionErrors;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<IcCubeSchedulerJobDefinition> getScheduleJobDefinitions() {
        Object object = this.globalLOCK;
        synchronized (object) {
            return new ArrayList<IcCubeSchedulerJobDefinition>(this.defs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    IcCubeSchedulerJobDefinition getScheduleJobDefinition(String uuid) {
        Object object = this.globalLOCK;
        synchronized (object) {
            for (IcCubeSchedulerJobDefinition def : this.defs) {
                if (!def.getUuid().equals(uuid)) continue;
                return def;
            }
            return null;
        }
    }

    @Nullable
    IcCubeSchedulerJob getScheduledJob(IcCubeSchedulerJobDefinition definition) {
        return this.getScheduledJob(definition.getUuid());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    IcCubeSchedulerJob getScheduledJob(String definitionUuid) {
        Object object = this.globalLOCK;
        synchronized (object) {
            for (IcCubeSchedulerJob scheduledJob : this.scheduledJobs) {
                if (!scheduledJob.isForDefinition(definitionUuid)) continue;
                return scheduledJob;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    IcCubeSchedulerJob getActiveScheduledJobForLoadSchema(File factory) {
        File backups = this.directories.getBackupDirectory();
        Object object = this.globalLOCK;
        synchronized (object) {
            for (IcCubeSchedulerJob scheduledJob : this.scheduledJobs) {
                if (scheduledJob.isDone() || !scheduledJob.isForLoadSchema(backups, factory)) continue;
                return scheduledJob;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onSchemaLoaded(OlapSchema schema) {
        if (this.kind != IcCubeSchedulerKind.SCHEMAS) {
            return;
        }
        IcCubeSchedulerJob job = null;
        Object object = this.globalLOCK;
        synchronized (object) {
            for (IcCubeSchedulerJob scheduledJob : this.scheduledJobs) {
                IOlapBuilderSchemaDefFactory factory;
                File factoryFile;
                File backups;
                IcCubeSchedulerTriggerDefinition trigger;
                if (!scheduledJob.isDone() || !scheduledJob.isEnabled() || !(trigger = scheduledJob.getTrigger()).isUnbounded() || !scheduledJob.isForLoadSchema(backups = this.directories.getBackupDirectory(), factoryFile = (factory = schema.getDefinitionFactory()).getXmlFile())) continue;
                job = scheduledJob;
                break;
            }
            if (job != null) {
                OlapLoggers.SCHEDULER.info((Object)(this.logPrefix() + " will re-schedule for schema [" + schema.getName() + "] " + job.getScheduledInfoForLogging()));
                this.scheduledJobs.remove(job);
            }
        }
        if (job != null) {
            IcCubeSchedulerJobDefinition definition = job.getDefinition();
            definition.setScheduledInfo(null);
            new Thread(() -> {
                try {
                    this.scheduleValidatedDefinition(definition, true);
                }
                catch (RuntimeException ex) {
                    OlapLoggers.SCHEDULER.error((Object)"unexpected re-schedule error", (Throwable)ex);
                }
            }, "Schema Re-Scheduler for " + schema.getName()).start();
        }
    }

    static {
        triggerSchedulers.put(IcCubeSchedulerCronTriggerDefinition.class, new IcCubeScheduler.CronTriggerScheduler());
        triggerSchedulers.put(IcCubeSchedulerOnDataChangedTriggerDefinition.class, new IcCubeScheduler.OnDataChangedTriggerScheduler());
        triggerSchedulers.put(IcCubeSchedulerOnceTriggerDefinition.class, new IcCubeScheduler.OnceTriggerScheduler());
        triggerSchedulers.put(IcCubeSchedulerFixedRateTriggerDefinition.class, new IcCubeScheduler.FixedRateTriggerScheduler());
        triggerSchedulers.put(IcCubeSchedulerContinuousTriggerDefinition.class, new IcCubeScheduler.ContinuousTriggerScheduler());
        triggerSchedulers.put(IcCubeSchedulerDailyTriggerDefinition.class, new IcCubeScheduler.DailyTriggerScheduler());
        triggerSchedulers.put(IcCubeSchedulerDailyHoursTriggerDefinition.class, new IcCubeScheduler.DailyPeriodTriggerScheduler());
        triggerSchedulers.put(IcCubeSchedulerDisabledTriggerDefinition.class, new IcCubeScheduler.DisabledTriggerScheduler());
    }
}

