/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.server.scheduler.definition.trigger;

import crazydev.common.property.CdProperty;
import crazydev.common.property.CdReadWriteProperty;
import crazydev.common.utils.CdStringUtils;
import crazydev.iccube.server.scheduler.definition.IcCubeSchedulerJobDefinition;
import crazydev.iccube.server.scheduler.definition.trigger.IcCubeSchedulerTriggerDefinition;
import crazydev.iccube.server.scheduler.validation.IcCubeSchedulerDailyTriggerDefinitionValidator;
import crazydev.iccube.server.scheduler.validation.IcCubeSchedulerDefinitionValidationContext;
import crazydev.iccube.validation.OlapValidator;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.util.ArrayList;
import java.util.List;

@XmlRootElement(name="daily")
public class IcCubeSchedulerDailyTriggerDefinition
extends IcCubeSchedulerTriggerDefinition<IcCubeSchedulerDailyTriggerDefinition> {
    public static final String XML_TAG = "daily";
    public static final CdProperty RUN_ON_STARTUP = new CdReadWriteProperty(IcCubeSchedulerDailyTriggerDefinition.class, "runOnStartup", CdProperty.Access.FIELD);
    public static final CdProperty DAYS_OF_MONTH = new CdReadWriteProperty(IcCubeSchedulerDailyTriggerDefinition.class, "daysOfMonth", CdProperty.Access.FIELD);
    public static final CdProperty TIME_HOUR_MINUTE = new CdReadWriteProperty(IcCubeSchedulerDailyTriggerDefinition.class, "timeHourMinute", CdProperty.Access.FIELD);
    @XmlElement(name="runOnStartup", required=false)
    private boolean runOnStartup;
    @XmlElement(name="daysOfMonth", required=false)
    private String daysOfMonth;
    @XmlElement(name="timeHourMinute", required=true)
    private String timeHourMinute;

    public IcCubeSchedulerDailyTriggerDefinition() {
    }

    public IcCubeSchedulerDailyTriggerDefinition(boolean runOnStartup, String daysOfMonth, String timeHourMinute) {
        this.runOnStartup = runOnStartup;
        this.daysOfMonth = daysOfMonth;
        this.timeHourMinute = timeHourMinute;
    }

    @Override
    public IcCubeSchedulerTriggerDefinition duplicate() {
        return new IcCubeSchedulerDailyTriggerDefinition(this.runOnStartup, this.daysOfMonth, this.timeHourMinute);
    }

    @Override
    public boolean isUnbounded() {
        return true;
    }

    public IcCubeSchedulerDailyTriggerDefinition setupForEmptyModel() {
        return this;
    }

    public boolean isRunOnStartup() {
        return this.runOnStartup;
    }

    public String getDaysOfMonth() {
        return this.daysOfMonth;
    }

    public List<Integer> getValidatedDaysOfMonth() {
        String[] parts;
        ArrayList<Integer> days = new ArrayList<Integer>();
        if (CdStringUtils.isNotNullAndNotBlank((String)this.daysOfMonth) && (parts = this.daysOfMonth.split(",")) != null && parts.length > 0) {
            for (String part : parts) {
                try {
                    int day = Integer.parseInt(part.trim());
                    if (day == 0) continue;
                    days.add(day);
                }
                catch (NumberFormatException ex) {
                    throw new RuntimeException("internal error: invalid days of month (" + this.daysOfMonth + ")");
                }
            }
        }
        return days;
    }

    public String getTimeHourMinute() {
        return this.timeHourMinute;
    }

    public int getValidatedTimeHour() {
        String field = CdStringUtils.isNullOrBlank((String)this.timeHourMinute) ? "" : this.timeHourMinute;
        try {
            String[] fields = this.timeHourMinute.split(":");
            return Integer.valueOf(fields[0]);
        }
        catch (RuntimeException ex) {
            throw new RuntimeException("internal error: invalid trigger definition [" + field + "]");
        }
    }

    public int getValidatedTimeMinute() {
        String field = CdStringUtils.isNullOrBlank((String)this.timeHourMinute) ? "" : this.timeHourMinute;
        try {
            String[] fields = this.timeHourMinute.split(":");
            return Integer.valueOf(fields[1]);
        }
        catch (RuntimeException ex) {
            throw new RuntimeException("internal error: invalid trigger definition [" + field + "]");
        }
    }

    @Override
    public String getInfoForLogging() {
        return "daily [run-on-startup:" + this.runOnStartup + "][time:" + this.timeHourMinute + "]";
    }

    public OlapValidator<IcCubeSchedulerDefinitionValidationContext, IcCubeSchedulerJobDefinition, IcCubeSchedulerDailyTriggerDefinition> getValidator() {
        return new IcCubeSchedulerDailyTriggerDefinitionValidator();
    }

    public String getContextVisualId() {
        return XML_TAG;
    }
}

