/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.server.scheduler.definition;

import crazydev.common.bean.IEmptyable;
import crazydev.common.property.CdProperty;
import crazydev.common.property.CdReadWriteProperty;
import crazydev.common.utils.CdStringUtils;
import crazydev.iccube.server.scheduler.definition.IcCubeSchedulerDefinition;
import crazydev.iccube.server.scheduler.definition.IcCubeSchedulerJobDefinition;
import crazydev.iccube.server.scheduler.definition.trigger.IcCubeSchedulerCronTriggerDefinition;
import crazydev.iccube.server.scheduler.definition.trigger.IcCubeSchedulerTriggerDefinition;
import crazydev.iccube.server.scheduler.validation.IcCubeSchedulerDefinitionValidationContext;
import crazydev.iccube.server.scheduler.validation.IcCubeSchedulerLoadSchemaJobDefinitionValidator;
import crazydev.iccube.validation.OlapValidator;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlTransient;
import org.jetbrains.annotations.Nullable;

@XmlRootElement(name="loadSchema")
public class IcCubeSchedulerLoadSchemaJobDefinition
extends IcCubeSchedulerJobDefinition<IcCubeSchedulerLoadSchemaJobDefinition>
implements IEmptyable<IcCubeSchedulerLoadSchemaJobDefinition> {
    public static final CdProperty SCHEMA_FACTORY = new CdReadWriteProperty(IcCubeSchedulerLoadSchemaJobDefinition.class, "schemaFactoryFileName", CdProperty.Access.FIELD);
    public static final CdProperty FULL_LOAD = new CdReadWriteProperty(IcCubeSchedulerLoadSchemaJobDefinition.class, "fullLoad", CdProperty.Access.FIELD);
    public static final CdProperty KEEP_MDX_RESULT_CACHE = new CdReadWriteProperty(IcCubeSchedulerLoadSchemaJobDefinition.class, "keepMdxResultCache", CdProperty.Access.FIELD);
    public static final CdProperty OFFLINE = new CdReadWriteProperty(IcCubeSchedulerLoadSchemaJobDefinition.class, "offlineSnapshot", CdProperty.Access.FIELD);
    public static final CdProperty GENERATE_OFFLINE = new CdReadWriteProperty(IcCubeSchedulerLoadSchemaJobDefinition.class, "generateOfflineSnapshot", CdProperty.Access.FIELD);
    @XmlElement(name="schemaFactoryFileName", required=true)
    private String schemaFactoryFileName;
    @XmlElement(name="fullLoad", required=false)
    private boolean fullLoad;
    @XmlElement(name="keepMdxResultCache", required=false, defaultValue="false")
    private boolean keepMdxResultCache = false;
    @XmlElement(name="offlineSnapshot", required=false)
    @Nullable
    private String offlineSnapshot;
    @XmlElement(name="generateOfflineSnapshot", required=false)
    private boolean generateOfflineSnapshot;
    @XmlTransient
    @Nullable
    private String schemaName = null;

    public IcCubeSchedulerLoadSchemaJobDefinition() {
    }

    public IcCubeSchedulerLoadSchemaJobDefinition(String schemaFactoryFileName, IcCubeSchedulerTriggerDefinition trigger) {
        super(trigger);
        this.schemaFactoryFileName = schemaFactoryFileName;
    }

    public IcCubeSchedulerLoadSchemaJobDefinition setupForEmptyModel() {
        this.trigger = new IcCubeSchedulerCronTriggerDefinition();
        return this;
    }

    public OlapValidator<IcCubeSchedulerDefinitionValidationContext, IcCubeSchedulerDefinition, IcCubeSchedulerLoadSchemaJobDefinition> getValidator() {
        return new IcCubeSchedulerLoadSchemaJobDefinitionValidator();
    }

    @Nullable
    public String getSchemaName() {
        return this.schemaName;
    }

    public void setSchemaName(@Nullable String schemaName) {
        this.schemaName = schemaName;
    }

    public String getSchemaFactoryFileName() {
        return this.schemaFactoryFileName;
    }

    public boolean isFullLoad() {
        return this.fullLoad;
    }

    public boolean isKeepMdxResultCache() {
        return this.keepMdxResultCache;
    }

    @Nullable
    public String getOfflineSnapshot() {
        return CdStringUtils.isNullOrBlank((String)this.offlineSnapshot) ? null : this.offlineSnapshot;
    }

    public boolean isGenerateOfflineSnapshot() {
        return this.generateOfflineSnapshot;
    }

    @Override
    public String getInfoForLogging() {
        String enabled = !this.isEnabled() ? "(disabled) " : "";
        String mode = this.isFullLoad() ? " (full-load)" : "";
        String keepMdxCache = this.isKeepMdxResultCache() ? " (keep-MDX-cache)" : "";
        String offline = this.getOfflineSnapshot() != null ? " (offline-snapshot:" + this.getOfflineSnapshot() + ")" : "";
        String generateOffline = this.generateOfflineSnapshot ? " (generate-offline-snapshot)" : "";
        return enabled + "load schema : " + this.schemaFactoryFileName + mode + keepMdxCache + offline + generateOffline;
    }

    @Override
    public String toString() {
        return super.toString() + " : " + this.schemaFactoryFileName;
    }
}

