/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.server.scheduler.definition;

import crazydev.common.bean.IEmptyable;
import crazydev.common.property.CdProperty;
import crazydev.common.property.CdReadWriteProperty;
import crazydev.common.utils.CdStringUtils;
import crazydev.common.xml.CdLocaleXmlAdapter;
import crazydev.iccube.builder.factory.schema.IOlapBuilderJaxbListener;
import crazydev.iccube.server.scheduler.definition.AlertAttachmentType;
import crazydev.iccube.server.scheduler.definition.IcCubeSchedulerDefinition;
import crazydev.iccube.server.scheduler.definition.IcCubeSchedulerJobDefinition;
import crazydev.iccube.server.scheduler.definition.trigger.IcCubeSchedulerCronTriggerDefinition;
import crazydev.iccube.server.scheduler.definition.trigger.IcCubeSchedulerOnDataChangedTriggerDefinition;
import crazydev.iccube.server.scheduler.validation.IcCubeSchedulerAlertJobDefinitionValidator;
import crazydev.iccube.server.scheduler.validation.IcCubeSchedulerDefinitionValidationContext;
import crazydev.iccube.validation.OlapValidator;
import jakarta.mail.internet.InternetAddress;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlTransient;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.Nullable;

@XmlRootElement(name="alert")
public class IcCubeSchedulerAlertJobDefinition
extends IcCubeSchedulerJobDefinition<IcCubeSchedulerAlertJobDefinition>
implements IEmptyable<IcCubeSchedulerAlertJobDefinition>,
IOlapBuilderJaxbListener {
    public static final CdProperty ROLE_NAME = new CdReadWriteProperty(IcCubeSchedulerAlertJobDefinition.class, "roleName", CdProperty.Access.FIELD);
    public static final CdProperty LOCALE = new CdReadWriteProperty(IcCubeSchedulerAlertJobDefinition.class, "locale");
    public static final CdProperty SCHEMA_NAME = new CdReadWriteProperty(IcCubeSchedulerAlertJobDefinition.class, "schemaName", CdProperty.Access.FIELD);
    public static final CdProperty ALERT_NAME = new CdReadWriteProperty(IcCubeSchedulerAlertJobDefinition.class, "alertName", CdProperty.Access.FIELD);
    public static final CdProperty ALERT_STATEMENT = new CdReadWriteProperty(IcCubeSchedulerAlertJobDefinition.class, "alertStatement", CdProperty.Access.FIELD);
    public static final CdProperty ALERT_CUBE_NAME = new CdReadWriteProperty(IcCubeSchedulerAlertJobDefinition.class, "alertCubeName", CdProperty.Access.FIELD);
    public static final CdProperty TO_ADDRESSES = new CdReadWriteProperty(IcCubeSchedulerAlertJobDefinition.class, "toAddresses", CdProperty.Access.FIELD);
    public static final CdProperty SUBJECT = new CdReadWriteProperty(IcCubeSchedulerAlertJobDefinition.class, "subject", CdProperty.Access.FIELD);
    public static final CdProperty BODY = new CdReadWriteProperty(IcCubeSchedulerAlertJobDefinition.class, "body", CdProperty.Access.FIELD);
    public static final CdProperty TO_ADDRESSES_ON_ERROR = new CdReadWriteProperty(IcCubeSchedulerAlertJobDefinition.class, "toAddressesOnError", CdProperty.Access.FIELD);
    public static final CdProperty SUBJECT_ON_ERROR = new CdReadWriteProperty(IcCubeSchedulerAlertJobDefinition.class, "subjectOnError", CdProperty.Access.FIELD);
    public static final CdProperty BODY_ON_ERROR = new CdReadWriteProperty(IcCubeSchedulerAlertJobDefinition.class, "bodyOnError", CdProperty.Access.FIELD);
    public static final CdProperty V8_REPORT_PDF = new CdReadWriteProperty(IcCubeSchedulerAlertJobDefinition.class, "v8reportPdf", CdProperty.Access.FIELD);
    public static final CdProperty V8_PAGE_SIZE = new CdReadWriteProperty(IcCubeSchedulerAlertJobDefinition.class, "v8pageSize", CdProperty.Access.FIELD);
    public static final CdProperty V8_PAGE_ORIENTATION = new CdReadWriteProperty(IcCubeSchedulerAlertJobDefinition.class, "v8pageOrientation", CdProperty.Access.FIELD);
    public static final CdProperty V8_FILE_NAME = new CdReadWriteProperty(IcCubeSchedulerAlertJobDefinition.class, "v8fileName", CdProperty.Access.FIELD);
    public static final CdProperty V8_REPORT_PDF_TIMEOUT = new CdReadWriteProperty(IcCubeSchedulerAlertJobDefinition.class, "v8reportPdfTimeout", CdProperty.Access.FIELD);
    public static final CdProperty ATTACHMENT_TYPE = new CdReadWriteProperty(IcCubeSchedulerAlertJobDefinition.class, "attachmentType", CdProperty.Access.FIELD);
    public static final CdProperty V8_REPORT_WIDGET = new CdReadWriteProperty(IcCubeSchedulerAlertJobDefinition.class, "v8reportWidget", CdProperty.Access.FIELD);
    public static final CdProperty V8_REPORT_WIDGET_EXPORT_TYPE = new CdReadWriteProperty(IcCubeSchedulerAlertJobDefinition.class, "v8reportWidgetExportType", CdProperty.Access.FIELD);
    public static final CdProperty V8_REPORT_WIDGET_FILE_NAME = new CdReadWriteProperty(IcCubeSchedulerAlertJobDefinition.class, "v8reportWidgetFileName", CdProperty.Access.FIELD);
    private static List<Object> TRIGGER_DEFINITIONS = Arrays.asList(new IcCubeSchedulerOnDataChangedTriggerDefinition());
    @XmlElement(name="attachmentType", required=false)
    @Nullable
    private AlertAttachmentType attachmentType;
    @XmlElement(name="roleName", required=false)
    @Nullable
    private String roleName;
    @XmlJavaTypeAdapter(value=CdLocaleXmlAdapter.class)
    @XmlElement(name="locale", required=false)
    @Nullable
    private Locale locale;
    @XmlElement(name="schemaName", required=true)
    private String schemaName;
    @XmlElement(name="alertName", required=true)
    private String alertName;
    @XmlElement(name="alertStatement", required=true)
    private String alertStatement;
    @XmlElement(name="alertCubeName", required=false)
    @Nullable
    private String alertCubeName;
    @XmlElement(name="toAddresses", required=true)
    private String toAddresses;
    @XmlElement(name="subject", required=true)
    private String subject;
    @XmlElement(name="body", required=true)
    private String body;
    @XmlElement(name="v8reportPdf", required=false)
    private String v8reportPdf;
    @XmlElement(name="v8reportPdfTimeout", required=false)
    @Nullable
    private Integer v8reportPdfTimeout;
    @XmlElement(name="v8pageSize", required=false)
    @Nullable
    private String v8pageSize;
    @XmlElement(name="v8pageOrientation", required=false)
    @Nullable
    private String v8pageOrientation;
    @XmlElement(name="v8fileName", required=false)
    @Nullable
    private String v8fileName;
    @XmlElement(name="v8reportWidget", required=false)
    @Nullable
    private String v8reportWidget;
    @XmlElement(name="v8reportWidgetExportType", required=false)
    @Nullable
    private String v8reportWidgetExportType;
    @XmlElement(name="v8reportWidgetFileName", required=false)
    @Nullable
    private String v8reportWidgetFileName;
    @XmlElement(name="toAddressesOnError", required=false)
    @Nullable
    private String toAddressesOnError;
    @XmlElement(name="subjectOnError", required=false)
    @Nullable
    private String subjectOnError;
    @XmlElement(name="bodyOnError", required=false)
    @Nullable
    private String bodyOnError;
    @XmlTransient
    private InternetAddress[] parsedToAddresses;
    @XmlTransient
    private InternetAddress[] parsedToAddressesOnError;

    public IcCubeSchedulerAlertJobDefinition() {
    }

    protected IcCubeSchedulerAlertJobDefinition(IcCubeSchedulerAlertJobDefinition other, @Nullable String uuid, @Nullable String alertName, boolean enabled) {
        super(other, uuid, enabled);
        this.attachmentType = other.attachmentType;
        this.roleName = other.roleName;
        this.locale = other.locale;
        this.schemaName = other.schemaName;
        this.alertName = alertName != null ? alertName : other.alertName;
        this.alertStatement = other.alertStatement;
        this.alertCubeName = other.alertCubeName;
        this.toAddresses = other.toAddresses;
        this.subject = other.subject;
        this.body = other.body;
        this.v8reportPdf = other.v8reportPdf;
        this.v8reportPdfTimeout = other.v8reportPdfTimeout;
        this.v8pageSize = other.v8pageSize;
        this.v8pageOrientation = other.v8pageOrientation;
        this.v8fileName = other.v8fileName;
        this.v8reportWidget = other.v8reportWidget;
        this.v8reportWidgetExportType = other.v8reportWidgetExportType;
        this.v8reportWidgetFileName = other.v8reportWidgetFileName;
        this.toAddressesOnError = other.toAddressesOnError;
        this.subjectOnError = other.subjectOnError;
        this.bodyOnError = other.bodyOnError;
        this.parsedToAddresses = null;
        this.parsedToAddressesOnError = null;
    }

    public IcCubeSchedulerAlertJobDefinition setupForEmptyModel() {
        this.trigger = new IcCubeSchedulerCronTriggerDefinition();
        return this;
    }

    public IcCubeSchedulerAlertJobDefinition setupForDev() {
        this.alertName = "Limit Check";
        this.trigger = new IcCubeSchedulerOnDataChangedTriggerDefinition(1, TimeUnit.DAYS);
        return this;
    }

    @Override
    public IcCubeSchedulerAlertJobDefinition duplicate(@Nullable String uuid, @Nullable String alertName, boolean enabled) {
        return new IcCubeSchedulerAlertJobDefinition(this, uuid, alertName, enabled);
    }

    public OlapValidator<IcCubeSchedulerDefinitionValidationContext, IcCubeSchedulerDefinition, IcCubeSchedulerAlertJobDefinition> getValidator() {
        return new IcCubeSchedulerAlertJobDefinitionValidator();
    }

    @Override
    public List<Object> getTriggerDefinitions() {
        ArrayList<Object> triggers = new ArrayList<Object>(super.getTriggerDefinitions());
        triggers.addAll(TRIGGER_DEFINITIONS);
        return triggers;
    }

    @Override
    @Nullable
    public String getSchemaForOnDataChanged() {
        return this.schemaName;
    }

    @Nullable
    public String getRoleName() {
        return this.roleName;
    }

    @Nullable
    public Locale getLocale() {
        return this.locale;
    }

    @Nullable
    public String getLocaleName() {
        return this.locale != null ? this.locale.toString() : null;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public String getAlertName() {
        return this.alertName;
    }

    public String getAlertStatement() {
        return this.alertStatement;
    }

    @Nullable
    public String getAlertCubeName() {
        return this.alertCubeName;
    }

    public String getToAddresses() {
        return this.toAddresses;
    }

    @Nullable
    public InternetAddress[] getParsedToAddresses() {
        return this.parsedToAddresses;
    }

    public void setParsedToAddresses(InternetAddress[] parsedToAddresses) {
        this.parsedToAddresses = parsedToAddresses;
    }

    public String getSubject() {
        return this.subject;
    }

    public String getBody() {
        return this.body;
    }

    public boolean hasReportPdf() {
        return CdStringUtils.isNotNullAndNotBlank((String)this.v8reportPdf);
    }

    public String getV8ReportPdf() {
        return this.v8reportPdf;
    }

    @Nullable
    public String getV8ReportWidget() {
        return this.v8reportWidget;
    }

    @Nullable
    public String getV8ReportWidgetExportType() {
        return this.v8reportWidgetExportType;
    }

    @Nullable
    public String getV8ReportWidgetFileName() {
        return this.v8reportWidgetFileName;
    }

    public AlertAttachmentType getAttachmentType() {
        return this.attachmentType;
    }

    public int getV8ReportPdfTimeout() {
        if (this.v8reportPdfTimeout != null) {
            return this.v8reportPdfTimeout;
        }
        return 0;
    }

    public double getMarginTop(double defaultValue) {
        return defaultValue;
    }

    public double getMarginRight(double defaultValue) {
        return defaultValue;
    }

    public double getMarginBottom(double defaultValue) {
        return defaultValue;
    }

    public double getMarginLeft(double defaultValue) {
        return defaultValue;
    }

    public String getV8PageSize() {
        return CdStringUtils.isNotNullAndNotBlank((String)this.v8pageSize) ? this.v8pageSize : "A4";
    }

    public String getV8PageOrientation() {
        return (CdStringUtils.isNotNullAndNotBlank((String)this.v8pageOrientation) ? this.v8pageOrientation : "Portrait").toLowerCase();
    }

    @Nullable
    public String getV8FileName() {
        return this.v8fileName;
    }

    @Nullable
    public String getToAddressesOnError() {
        return this.toAddressesOnError;
    }

    @Nullable
    public InternetAddress[] getParsedToAddressesOnError() {
        if (this.parsedToAddressesOnError != null) {
            return this.parsedToAddressesOnError;
        }
        return this.parsedToAddresses;
    }

    public void setParsedToAddressesOnError(InternetAddress[] parsedToAddresses) {
        this.parsedToAddressesOnError = parsedToAddresses;
    }

    @Nullable
    public String getSubjectOnError() {
        return this.subjectOnError;
    }

    @Nullable
    public String getBodyOnError() {
        return this.bodyOnError;
    }

    public String getSubjectOnErrorX(@Nullable String error) {
        if (CdStringUtils.isNotNullAndNotBlank((String)this.subjectOnError)) {
            return this.subjectOnError;
        }
        String subject = String.format("icCube Alert Processing Error : %s (%s)", this.alertName, this.schemaName);
        return subject;
    }

    public String getBodyOnErrorX(@Nullable String error) {
        if (CdStringUtils.isNotNullAndNotBlank((String)this.bodyOnError)) {
            return this.bodyOnError;
        }
        String body = String.format("The processing of the alert has failed%s.\n\nPlease consult your icCube administrator for more details.\n\nSchema : %s\nAlert  : %s\nError  : %s", this.isContinueOnError() ? "" : " (the alert has been * disabled *)", this.alertName, this.schemaName, CdStringUtils.isNotNullAndNotBlank((String)error) ? error : "n/a");
        return body;
    }

    @Override
    public String getInfoForLogging() {
        String enabled = !this.isEnabled() ? "(disabled) " : "";
        return enabled + " schema:" + this.schemaName + " alert:" + this.alertName;
    }

    @Override
    public String toString() {
        return super.toString() + " " + this.alertName;
    }

    public void beforeMarshal() {
    }

    public void afterUnmarshal() {
        if (this.attachmentType == null && CdStringUtils.isNotNullAndNotBlank((String)this.v8reportPdf)) {
            this.attachmentType = CdStringUtils.isNullOrBlank((String)this.v8reportWidget) ? AlertAttachmentType.PDF : AlertAttachmentType.WIDGET;
        }
    }
}

