/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.server.request.request.gvi;

import crazydev.common.utils.CdStringUtils;
import crazydev.iccube.gwt.server.common.converters.UiModelConverterHelper;
import crazydev.iccube.olap.component.mdx.ICompilationInfo;
import crazydev.iccube.olap.loggers.OlapLoggers;
import crazydev.iccube.server.context.IcCubeServerSessionContext;
import crazydev.iccube.server.request.request.common.IcCubeServerRequestContext;
import crazydev.iccube.server.request.request.gvi.IcCubeGviServerRequest;
import crazydev.iccube.server.request.request.gvi.IcCubeGviServerRequestReply;
import jakarta.servlet.http.HttpServletResponse;
import java.util.Locale;
import org.jetbrains.annotations.Nullable;

public class IcCubeGviServerRequestContext
extends IcCubeServerRequestContext<IcCubeGviServerRequest, IcCubeGviServerRequestReply> {
    private final IcCubeGviServerRequestReply reply;
    @Nullable
    private ICompilationInfo mdxCompilationInfo;

    public IcCubeGviServerRequestContext(IcCubeServerSessionContext sessionContext, IcCubeGviServerRequest request) {
        super(sessionContext, request, IcCubeGviServerRequestContext.extractLocale(request));
        request.setupMdxRequestProperties(this.olapEngineRequestContext);
        this.reply = new IcCubeGviServerRequestReply(request);
    }

    @Nullable
    private static Locale extractLocale(IcCubeGviServerRequest request) {
        String localeName = request.getLocale();
        if (CdStringUtils.isNullOrBlank((String)localeName)) {
            return null;
        }
        try {
            Locale locale = UiModelConverterHelper.createJavaLocale(localeName);
            return locale;
        }
        catch (RuntimeException ex) {
            try {
                String localeNameEx = localeName.replace("-", "_");
                Locale localeEx = UiModelConverterHelper.createJavaLocale(localeNameEx);
                return localeEx;
            }
            catch (RuntimeException runtimeException) {
                OlapLoggers.GVI_REQUEST.warn((Object)("[GVI] invalid locale name [" + localeName + "]"));
                return null;
            }
        }
    }

    public HttpServletResponse getHttpResponse() {
        return ((IcCubeGviServerRequest)this.request).getHttpResponse();
    }

    @Override
    public IcCubeGviServerRequestReply getRequestReply() {
        return this.reply;
    }

    @Nullable
    public ICompilationInfo getMdxCompilationInfo() {
        return this.mdxCompilationInfo;
    }

    public void setMdxCompilationInfo(ICompilationInfo compilationInfo) {
        this.mdxCompilationInfo = compilationInfo;
    }
}

