/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.server.request.request.common;

import crazydev.iccube.authorization.permissions.role.OlapRolePermissions;
import crazydev.iccube.embedded.IcCubeEngine;
import crazydev.iccube.embedded.IcCubeEngineUserHelper;
import crazydev.iccube.gwt.shared.portlets.monitoring.command.schemas.GwtLoadSchemaMdxResultCachePostProcessingQuery;
import crazydev.iccube.gwt.shared.portlets.monitoring.command.schemas.GwtLoadSchemaMembersPostProcessingQuery;
import crazydev.iccube.gwt.shared.portlets.monitoring.command.schemas.GwtRefreshSchemaStatisticsQuery;
import crazydev.iccube.notification.OlapNotificationService;
import crazydev.iccube.olap.component.OlapEngineComponent;
import crazydev.iccube.olap.component.command.builtin.OlapSchemaLifeCycleStatus;
import crazydev.iccube.olap.component.command.builtin.OlapSchemaLifeCycleStatusPhase;
import crazydev.iccube.olap.component.command.builtin.OlapSchemaLoadStatus;
import crazydev.iccube.olap.component.context.OlapEngineRequestContext;
import crazydev.iccube.olap.component.context.OlapRuntimeContext;
import crazydev.iccube.olap.component.context.cache.OlapMdxResultCacheInfos;
import crazydev.iccube.olap.component.schemas.OlapSchemaLoadingLock;
import crazydev.iccube.olap.loggers.OlapLoggers;
import crazydev.iccube.olap.schema.OlapSchemaInformation;
import crazydev.iccube.pub.principal.OlapPrincipal;
import crazydev.iccube.request.log.OlapRequestId;
import crazydev.iccube.request.request.IcCubeRequest;
import crazydev.iccube.request.request.IcCubeRequestReply;
import crazydev.iccube.request.status.IcCubeRequestStatusManager;
import crazydev.iccube.server.context.IcCubeServerApplicationContext;
import crazydev.iccube.server.context.IcCubeServerSessionContext;
import crazydev.iccube.server.request.request.common.IcCubeServerRequestContext;
import crazydev.iccube.server.request.task.IcCubeServerTask;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public abstract class IcCubeServerRequest<REQUEST extends IcCubeServerRequest<REQUEST, REPLY, REQUEST_CONTEXT>, REPLY extends IcCubeRequestReply, REQUEST_CONTEXT extends IcCubeServerRequestContext<REQUEST, REPLY>>
extends IcCubeRequest {
    public IcCubeServerRequest(OlapRequestId requestId) {
        super(requestId);
    }

    @Nullable
    public String getPrintJobUUID() {
        return null;
    }

    public boolean isCreateOfflineOnly() {
        return false;
    }

    protected boolean isLoadPartitions() {
        return false;
    }

    protected boolean isLoadMeasureGroups() {
        return false;
    }

    public abstract boolean isSchemaLifeCycle();

    @Nullable
    protected abstract String getSchemaLifeCycleName();

    @Nullable
    protected abstract OlapSchemaLifeCycleStatus getSchemaLifeCycleStatus(REQUEST_CONTEXT var1);

    @Nullable
    protected abstract OlapSchemaLifeCycleStatusPhase getSchemaLifeCycleStatusPhase(REQUEST_CONTEXT var1);

    public final boolean setupTaskSchedulingInfo(REQUEST_CONTEXT requestContext) {
        try {
            return this.unsafeSetupTaskSchedulingInfo(requestContext);
        }
        catch (Exception exception) {
            IcCubeRequestStatusManager statusManager = ((IcCubeServerRequestContext)requestContext).getRequestStatusManager();
            Object reply = ((IcCubeServerRequestContext)requestContext).getRequestReply();
            reply.reportRequestSetupSchedulingException(statusManager, exception);
            return false;
        }
    }

    protected abstract boolean unsafeSetupTaskSchedulingInfo(REQUEST_CONTEXT var1) throws Exception;

    public List<IcCubeServerTask> setupTasks(REQUEST_CONTEXT requestContext) {
        ArrayList<IcCubeServerTask> tasks = new ArrayList<IcCubeServerTask>();
        this.setupTasks(tasks, requestContext);
        return tasks;
    }

    protected abstract void setupTasks(List<IcCubeServerTask> var1, REQUEST_CONTEXT var2);

    public boolean onBeforeTaskSubmitted(REQUEST_CONTEXT requestContext) {
        return true;
    }

    public void onFinallyForSchemaLifeCycleRequest(REQUEST_CONTEXT requestContext) {
        if (this.isSchemaLifeCycle()) {
            IcCubeRequestStatusManager manager = ((IcCubeServerRequestContext)requestContext).getRequestStatusManager();
            Object reply = ((IcCubeServerRequestContext)requestContext).getRequestReply();
            if (reply.hasErrors()) {
                manager.onRequestDetailAdded(((IcCubeServerRequestContext)requestContext).getRequestClientUUID(), "Loading Unexpected Error", "unexpected error (please consult the log files)");
            }
            if (((IcCubeServerRequestContext)requestContext).isCancelling()) {
                manager.onRequestDetailAdded(((IcCubeServerRequestContext)requestContext).getRequestClientUUID(), "Loading Cancelled", "yes");
                OlapSchemaLifeCycleStatusPhase phase = this.getSchemaLifeCycleStatusPhase(requestContext);
                String phaseInfo = phase == null ? "?" : phase.name();
                manager.onRequestDetailAdded(((IcCubeServerRequestContext)requestContext).getRequestClientUUID(), "Loading Phase", phaseInfo);
            } else {
                OlapSchemaLifeCycleStatus lifeCycleStatus = this.getSchemaLifeCycleStatus(requestContext);
                if (lifeCycleStatus != null) {
                    manager.onRequestDetailAdded(((IcCubeServerRequestContext)requestContext).getRequestClientUUID(), "Loading Status", lifeCycleStatus.getLoadStatus().name());
                    OlapEngineComponent engine = ((IcCubeServerRequestContext)requestContext).getOlapEngineComponent();
                    OlapRuntimeContext rContext = ((IcCubeServerRequestContext)requestContext).asRuntimeContext();
                    OlapSchemaInformation info = engine.getLoadedSchemaInformation(rContext, lifeCycleStatus.getSchema());
                    if (info != null && info.isIncremental()) {
                        String value = info.isIncrLoadDeActivatedOnError() ? "Disabled due to loading error (the schema is in an uncertain state)." : "OK";
                        manager.onRequestDetailAdded(((IcCubeServerRequestContext)requestContext).getRequestClientUUID(), "Incremental Load Status", value);
                    }
                }
            }
        }
        if (this.isSchemaLifeCycle()) {
            Object reply = ((IcCubeServerRequestContext)requestContext).getRequestReply();
            OlapSchemaLifeCycleStatus lifeCycleStatus = this.getSchemaLifeCycleStatus(requestContext);
            OlapNotificationService notificationService = ((IcCubeServerRequestContext)requestContext).getNotificationService();
            String requestUuid = ((IcCubeServerRequestContext)requestContext).getRequestClientUUID();
            String userName = ((IcCubeServerRequestContext)requestContext).getUserName();
            if (reply.hasErrors()) {
                schema = this.getSchemaLifeCycleName();
                notificationService.onSchemaLoadError(requestUuid, userName, schema != null ? schema : "n/a");
            } else if (((IcCubeServerRequestContext)requestContext).isCancelling()) {
                schema = this.getSchemaLifeCycleName();
                notificationService.onSchemaLoadCancelled(requestUuid, userName, schema != null ? schema : "n/a");
            } else if (lifeCycleStatus != null) {
                schema = lifeCycleStatus.getSchema();
                OlapSchemaLoadStatus loadStatus = lifeCycleStatus.getLoadStatus();
                if (loadStatus == OlapSchemaLoadStatus.UNLOADED) {
                    notificationService.onSchemaUnload(requestUuid, userName, schema);
                } else if (loadStatus == OlapSchemaLoadStatus.LOADED) {
                    notificationService.onSchemaFullLoad(requestUuid, userName, schema);
                } else if (loadStatus == OlapSchemaLoadStatus.DUPLICATED_LOADING_CANCELLED) {
                    notificationService.onSchemaLoadCancelled(requestUuid, userName, schema);
                } else if (loadStatus == OlapSchemaLoadStatus.WAITING_LOADING_CANCELLED) {
                    notificationService.onSchemaLoadCancelled(requestUuid, userName, schema);
                } else if (loadStatus == OlapSchemaLoadStatus.LOAD_ERROR) {
                    notificationService.onSchemaFullLoadError(requestUuid, userName, schema);
                } else if (loadStatus == OlapSchemaLoadStatus.INCREMENTAL_LOADED) {
                    notificationService.onSchemaIncrementalLoad(requestUuid, userName, schema);
                } else if (loadStatus == OlapSchemaLoadStatus.INCREMENTAL_LOAD_DEACTIVATED) {
                    notificationService.onSchemaIncrementalLoadDeActivated(requestUuid, userName, schema);
                } else if (loadStatus == OlapSchemaLoadStatus.INCREMENTAL_LOAD_ERROR) {
                    notificationService.onSchemaIncrementalLoadError(requestUuid, userName, schema);
                } else if (loadStatus == OlapSchemaLoadStatus.PARTITIONS_UNLOADED) {
                    notificationService.onSchemaUnloadPartitions(requestUuid, userName, schema);
                } else if (loadStatus == OlapSchemaLoadStatus.PARTITIONS_LOADED) {
                    notificationService.onSchemaLoadPartitions(requestUuid, userName, schema);
                } else if (loadStatus == OlapSchemaLoadStatus.PARTITIONS_LOAD_FAILED) {
                    notificationService.onSchemaLoadPartitionsFailed(requestUuid, userName, schema);
                } else if (loadStatus == OlapSchemaLoadStatus.PARTITIONS_LOAD_ERROR) {
                    notificationService.onSchemaLoadPartitionsError(requestUuid, userName, schema);
                } else if (loadStatus != OlapSchemaLoadStatus.NOP) {
                    String message = "unexpected schema [" + lifeCycleStatus.getSchema() + "] load status [" + String.valueOf(loadStatus) + "]";
                    OlapLoggers.NOTIFICATION.error((Object)message);
                    notificationService.onInternalError(message);
                }
            } else {
                String message = "unexpected life-cycle request status for schema [" + this.getSchemaLifeCycleName() + "]";
                OlapLoggers.NOTIFICATION.error((Object)message);
                notificationService.onInternalError(message);
            }
        }
    }

    protected void onFinallyForSchemaLoaded(REQUEST_CONTEXT requestContext, OlapSchemaLoadingLock lock) {
        OlapEngineRequestContext olapEngineRequestContext = ((IcCubeServerRequestContext)requestContext).getOlapEngineRequestContext();
        OlapEngineComponent olapEngine = ((IcCubeServerRequestContext)requestContext).getOlapEngineComponent();
        String schemaName = lock.getSchemaInformation().getName();
        Logger logger = olapEngineRequestContext.getLoggers().builder();
        if (olapEngine.onSchemaLoadingDone(olapEngineRequestContext, lock)) {
            Object reply = ((IcCubeServerRequestContext)requestContext).getRequestReply();
            boolean isCancelling = ((IcCubeServerRequestContext)requestContext).isCancelling();
            boolean hasErrors = reply.hasErrors();
            if (!isCancelling && !hasErrors) {
                OlapSchemaLifeCycleStatus lifeCycleStatus = this.getSchemaLifeCycleStatus(requestContext);
                if (lifeCycleStatus != null) {
                    OlapSchemaLoadStatus status = lifeCycleStatus.getLoadStatus();
                    boolean createOfflineOnly = this.isCreateOfflineOnly();
                    logger.info((Object)("[schema] schema [" + schemaName + "] " + (createOfflineOnly ? "create-offline-only " : "") + "done [" + String.valueOf(status) + "]"));
                    if (!createOfflineOnly) {
                        this.fireAndForgetSchemaStatsProcessing(requestContext, logger, schemaName, status);
                        this.fireAndForgetMembersPostProcessing(requestContext, logger, schemaName, status);
                        this.fireAndForgetMdxResultCacheProcessing(requestContext, logger, schemaName, status);
                    }
                } else {
                    logger.info((Object)("[schema] schema [" + schemaName + "] done [no-status]"));
                }
            } else {
                logger.info((Object)("[schema] schema [" + schemaName + "] done [cancel:" + isCancelling + "] [" + hasErrors + "]"));
            }
        } else {
            logger.info((Object)("[schema] schema [" + schemaName + "] done [false]"));
        }
    }

    private void fireAndForgetSchemaStatsProcessing(REQUEST_CONTEXT requestContext, Logger logger, String schemaName, OlapSchemaLoadStatus status) {
        if (this.isLoadPartitions() || this.isLoadMeasureGroups()) {
            return;
        }
        if (!status.canStartSchemaStatsProcessing()) {
            return;
        }
        GwtRefreshSchemaStatisticsQuery query = new GwtRefreshSchemaStatisticsQuery(schemaName);
        IcCubeServerSessionContext sessionContext = ((IcCubeServerRequestContext)requestContext).getSessionContext();
        OlapPrincipal principal = sessionContext.getUser();
        OlapRolePermissions permissions = ((IcCubeServerRequestContext)requestContext).getCurrentPermissions();
        IcCubeEngineUserHelper sessionHelper = new IcCubeEngineUserHelper(principal, permissions, sessionContext);
        IcCubeServerApplicationContext applicationContext = ((IcCubeServerRequestContext)requestContext).getApplicationContext();
        IcCubeEngine engine = applicationContext.getEngine();
        logger.info((Object)("[schema] schema [" + schemaName + "] stats post-processing scheduled"));
        engine.fireGwtRequest(query, sessionHelper);
    }

    private void fireAndForgetMembersPostProcessing(REQUEST_CONTEXT requestContext, Logger logger, String schemaName, OlapSchemaLoadStatus status) {
        if (this.isLoadPartitions() || this.isLoadMeasureGroups()) {
            return;
        }
        if (!status.canStartMembersPostProcessing()) {
            return;
        }
        boolean isIncrLoadMonitoring = ((IcCubeServerRequestContext)requestContext).getRequest().isLoadMonitoring();
        GwtLoadSchemaMembersPostProcessingQuery query = new GwtLoadSchemaMembersPostProcessingQuery(schemaName, isIncrLoadMonitoring);
        IcCubeServerSessionContext sessionContext = ((IcCubeServerRequestContext)requestContext).getSessionContext();
        OlapPrincipal principal = sessionContext.getUser();
        OlapRolePermissions permissions = ((IcCubeServerRequestContext)requestContext).getCurrentPermissions();
        IcCubeEngineUserHelper sessionHelper = new IcCubeEngineUserHelper(principal, permissions, sessionContext);
        IcCubeServerApplicationContext applicationContext = ((IcCubeServerRequestContext)requestContext).getApplicationContext();
        IcCubeEngine engine = applicationContext.getEngine();
        logger.info((Object)("[schema] schema [" + schemaName + "] members post-processing scheduled"));
        engine.fireGwtRequest(query, sessionHelper);
    }

    private void fireAndForgetMdxResultCacheProcessing(REQUEST_CONTEXT requestContext, Logger logger, String schemaName, OlapSchemaLoadStatus status) {
        OlapMdxResultCacheInfos infos = ((IcCubeServerRequestContext)requestContext).getRebuildMdxResultCacheInfos();
        if (infos == null || infos.isEmpty()) {
            logger.info((Object)("[schema] schema [" + schemaName + "] MDX result cache post-processing not started [1]"));
            return;
        }
        if (!status.canStartMdxResultCacheProcessing()) {
            logger.info((Object)("[schema] schema [" + schemaName + "] MDX result cache post-processing not started [2]"));
            return;
        }
        GwtLoadSchemaMdxResultCachePostProcessingQuery query = new GwtLoadSchemaMdxResultCachePostProcessingQuery(schemaName, (Serializable)infos);
        IcCubeServerSessionContext sessionContext = ((IcCubeServerRequestContext)requestContext).getSessionContext();
        OlapPrincipal principal = sessionContext.getUser();
        OlapRolePermissions permissions = ((IcCubeServerRequestContext)requestContext).getCurrentPermissions();
        IcCubeEngineUserHelper sessionHelper = new IcCubeEngineUserHelper(principal, permissions, sessionContext);
        IcCubeServerApplicationContext applicationContext = ((IcCubeServerRequestContext)requestContext).getApplicationContext();
        IcCubeEngine engine = applicationContext.getEngine();
        logger.info((Object)("[schema] schema [" + schemaName + "] MDX result cache post-processing scheduled"));
        engine.fireGwtRequest(query, sessionHelper);
    }

    public void onFinallyForSchemaLifeCycleRequestEx(REQUEST_CONTEXT requestContext) {
        if (this.isSchemaLifeCycle()) {
            OlapEngineRequestContext olapEngineRequestContext = ((IcCubeServerRequestContext)requestContext).getOlapEngineRequestContext();
            olapEngineRequestContext.unfreezeTaskExecutorForSchema();
        }
    }
}

