/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.server.request.processor.print.paper;

import crazydev.iccube.configuration.OlapConfigurationErrorCode;
import crazydev.iccube.configuration.OlapConfigurationException;
import crazydev.iccube.server.request.processor.print.paper.IcCubePaperRatio;
import crazydev.iccube.server.request.processor.print.paper.IcCubePaperSize;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.Nullable;

@XmlRootElement(name="paperSizes")
public class IcCubePaperSizes {
    @XmlElement(name="paperSize", required=false)
    private List<IcCubePaperSize> paperSizes;

    public void validate() throws OlapConfigurationException {
        if (this.paperSizes == null || this.paperSizes.isEmpty()) {
            throw new OlapConfigurationException(OlapConfigurationErrorCode.COMPONENT_IS_MISSING, new Serializable[]{"paperSizes"});
        }
        for (IcCubePaperSize paperSize : this.paperSizes) {
            paperSize.validate();
        }
    }

    public boolean isEmpty() {
        return this.paperSizes.isEmpty();
    }

    public List<IcCubePaperSize> getPaperSizes() {
        return this.paperSizes;
    }

    public List<String> getNames() {
        ArrayList<String> names = new ArrayList<String>();
        for (IcCubePaperSize paperSize : this.paperSizes) {
            names.add(paperSize.getName());
        }
        return names;
    }

    @Nullable
    public IcCubePaperSize getPaperSize(String name) {
        for (IcCubePaperSize paperSize : this.paperSizes) {
            if (!paperSize.getName().equals(name)) continue;
            return paperSize;
        }
        return null;
    }

    public List<IcCubePaperRatio> getRatios() {
        ArrayList<IcCubePaperRatio> ratios = new ArrayList<IcCubePaperRatio>();
        for (IcCubePaperSize paperSize : this.paperSizes) {
            paperSize.getRatios(ratios);
        }
        return ratios;
    }
}

