/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.server.request.processor.print.paper;

import crazydev.common.utils.CdStringUtils;
import crazydev.iccube.configuration.OlapConfigurationErrorCode;
import crazydev.iccube.configuration.OlapConfigurationException;
import crazydev.iccube.server.request.processor.print.paper.IcCubePaperRatio;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.io.Serializable;
import java.util.List;

@XmlRootElement(name="paperSize")
public class IcCubePaperSize {
    @XmlAttribute(name="name", required=true)
    private String name;
    @XmlAttribute(name="unit", required=true)
    private String unit;
    @XmlAttribute(name="width", required=true)
    private double width;
    @XmlAttribute(name="height", required=true)
    private double height;
    @XmlAttribute(name="marginTop", required=true)
    private double marginTop;
    @XmlAttribute(name="marginBottom", required=true)
    private double marginBottom;
    @XmlAttribute(name="marginLeft", required=true)
    private double marginLeft;
    @XmlAttribute(name="marginRight", required=true)
    private double marginRight;

    public void validate() throws OlapConfigurationException {
        if (CdStringUtils.isNullOrBlank((String)this.name)) {
            throw new OlapConfigurationException(OlapConfigurationErrorCode.COMPONENT_IS_MISSING, new Serializable[]{"name"});
        }
        if (CdStringUtils.isNullOrBlank((String)this.unit)) {
            throw new OlapConfigurationException(OlapConfigurationErrorCode.COMPONENT_IS_MISSING, new Serializable[]{"unit"});
        }
    }

    public String getName() {
        return this.name;
    }

    public String getWidth() {
        return this.width + this.unit;
    }

    public double getWidthEx() {
        return this.width;
    }

    public String getWidth(String orientation) {
        if ("portrait".equalsIgnoreCase(orientation)) {
            return this.width + this.unit;
        }
        if ("landscape".equalsIgnoreCase(orientation)) {
            return this.height + this.unit;
        }
        throw new RuntimeException("internal error : unexpected paper orientation (" + orientation + ")");
    }

    public String getHeight() {
        return this.height + this.unit;
    }

    public double getHeightEx() {
        return this.height;
    }

    public double getMarginTopEx() {
        return this.marginTop;
    }

    public double getMarginBottomEx() {
        return this.marginBottom;
    }

    public double getMarginLeftEx() {
        return this.marginLeft;
    }

    public double getMarginRightEx() {
        return this.marginRight;
    }

    public String getHeight(String orientation) {
        if ("portrait".equals(orientation.toLowerCase())) {
            return this.height + this.unit;
        }
        if ("landscape".equals(orientation.toLowerCase())) {
            return this.width + this.unit;
        }
        throw new RuntimeException("internal error : unexpected paper orientation (" + orientation + ")");
    }

    public String getUnit() {
        return this.unit;
    }

    public List<IcCubePaperRatio> getRatios(List<IcCubePaperRatio> ratios) {
        ratios.add(new IcCubePaperRatio(this.name + " (Portrait)", this.width / this.height));
        ratios.add(new IcCubePaperRatio(this.name + " (Landscape)", this.height / this.width));
        return ratios;
    }
}

