/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.server.request.processor.print.chrome;

import com.google.gson.GsonBuilder;
import crazydev.common.exception.CdException;
import crazydev.common.utils.CdStringUtils;
import crazydev.iccube.babylon.OlapBabylonService;
import crazydev.iccube.directories.OlapDirectories;
import crazydev.iccube.olap.loggers.OlapLoggers;
import crazydev.iccube.server.http.IcCubeHttpComponent;
import crazydev.iccube.server.print.IcCubePrintComponent;
import crazydev.iccube.server.print.IcCubePrintComponentConfiguration;
import crazydev.iccube.server.request.processor.print.IcCubeErrorPrintJobResult;
import crazydev.iccube.server.request.processor.print.IcCubePrintJob;
import crazydev.iccube.server.request.processor.print.IcCubePrintJobCommandLine;
import crazydev.iccube.server.request.processor.print.IcCubePrintJobResult;
import crazydev.iccube.server.request.processor.print.IcCubePrintService;
import crazydev.iccube.server.request.processor.print.chrome.IcCubeChromePrintJobResult;
import crazydev.iccube.server.scheduler.definition.AlertAttachmentType;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.http.HttpClient;
import java.net.http.HttpHeaders;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import org.apache.commons.io.IOUtils;

public class IcCubeDockerPrintService
extends IcCubePrintService {
    private final String address;

    public IcCubeDockerPrintService(IcCubeHttpComponent httpComponent, IcCubePrintComponent printComponent, OlapDirectories directories, IcCubePrintComponentConfiguration configuration) {
        super(httpComponent, printComponent, true);
        String options = configuration.getExecOptions();
        if (CdStringUtils.isNullOrBlank((String)options)) {
            String error = "Invalid execOptions [" + options + "] expecting the icCube print server address (e.g., myPrintServer.com:8888).";
            throw new RuntimeException(error);
        }
        String prefix = !options.startsWith("http") ? "http://" : "";
        String postfix = !options.endsWith("/") ? "/" : "";
        this.address = prefix + options + postfix;
    }

    @Override
    public void setUp() throws CdException {
        OlapLoggers.PRINT.info((Object)"[printing] ");
        OlapLoggers.PRINT.info((Object)"[printing] Chrome|Chromium headless Docker (setup)");
        OlapLoggers.PRINT.info((Object)"[printing] ");
        OlapLoggers.PRINT.info((Object)("[printing]     address : " + this.address));
        OlapLoggers.PRINT.info((Object)"[printing] ");
    }

    @Override
    public void shutdownNow() {
    }

    @Override
    protected IcCubePrintJobResult doExecutePrintJob(OlapBabylonService babylon, IcCubePrintJob job) {
        OlapLoggers.PRINT.info((Object)("[printing] job (" + job.getUuid() + ") started [request:" + job.getRequestUUID() + "]"));
        try {
            return this.doPrint(babylon, job);
        }
        catch (RuntimeException ex) {
            int timeout = job.getTimeout();
            OlapLoggers.PRINT.error((Object)("[printing] job (" + job.getUuid() + ") printing [timeout:" + timeout + "sec.] : print error"), (Throwable)ex);
            return new IcCubeErrorPrintJobResult(job, "Error printing report : " + ex.getMessage());
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private IcCubePrintJobResult doPrint(OlapBabylonService babylon, IcCubePrintJob job) {
        try {
            boolean exportWidgetData;
            String reportURL = job.getChromeNavigateURL(this.listeningUrl);
            int timeout = job.getTimeout();
            OlapLoggers.PRINT.info((Object)("[printing] job (" + job.getUuid() + ") printing [timeout:" + timeout + "sec.] : navigating to : " + reportURL));
            OlapLoggers.PRINT_CONSOLE.warn((Object)("[printing] job (" + job.getUuid() + ") printing [timeout:" + timeout + "sec.] : navigating to : " + reportURL));
            IcCubePrintJobCommandLine commandLine = job.getCommandLine();
            double paperWidth = commandLine.paperWidthInches();
            double paperHeight = commandLine.paperHeightInches();
            String widgetId = job.getWidgetId();
            String format = job.getWidgetFormat();
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("job", job.getUuid());
            params.put("timeoutS", job.getTimeout());
            params.put("waitPeriodMS", job.getWaitPeriodMS());
            params.put("debugWaitTimeS", commandLine.getDebugWaitTime());
            params.put("reportURL", reportURL);
            params.put("paperWidth", paperWidth);
            params.put("paperHeight", paperHeight);
            boolean bl = exportWidgetData = job.getAttachmentType() == AlertAttachmentType.WIDGET;
            if (exportWidgetData) {
                params.put("widget", widgetId);
                params.put("format", format);
            }
            URI uri = new URI(this.address + (!exportWidgetData ? "pdf" : "widget"));
            String json = new GsonBuilder().create().toJson(params);
            HttpRequest request = HttpRequest.newBuilder(uri).timeout(Duration.ofSeconds(timeout)).header("Cache-Control", "no-cache").header("Accept-Encoding", "gzip").header("Content-Type", "application/json;charset=UTF-8").POST(HttpRequest.BodyPublishers.ofString(json)).build();
            try (HttpClient client = IcCubeDockerPrintService.createClient();){
                IcCubeChromePrintJobResult icCubeChromePrintJobResult;
                block21: {
                    HttpResponse<InputStream> response = client.send(request, HttpResponse.BodyHandlers.ofInputStream());
                    int statusCode = response.statusCode();
                    if (statusCode == 429) {
                        String error = babylon.translate("psRetryLater", new Serializable[0]);
                        IcCubeErrorPrintJobResult icCubeErrorPrintJobResult = new IcCubeErrorPrintJobResult(job, 429, error);
                        return icCubeErrorPrintJobResult;
                    }
                    if (statusCode >= 300) {
                        String error = IcCubeDockerPrintService.responseErrorMessage(response, statusCode);
                        IcCubeErrorPrintJobResult icCubeErrorPrintJobResult = new IcCubeErrorPrintJobResult(job, "Print server error (" + statusCode + ") : " + error);
                        return icCubeErrorPrintJobResult;
                    }
                    InputStream is = IcCubeDockerPrintService.responseInputStream(response);
                    try {
                        String fileName = IcCubeDockerPrintService.getFileName(job);
                        String contentType = IcCubeDockerPrintService.getContentType(job);
                        OlapLoggers.PRINT.info((Object)("[printing] job (" + job.getUuid() + ") print job finished in server [" + fileName + "] [" + contentType + "]"));
                        ByteArrayOutputStream os = new ByteArrayOutputStream();
                        IOUtils.copy((InputStream)is, (OutputStream)os);
                        icCubeChromePrintJobResult = new IcCubeChromePrintJobResult(job, contentType, os.toByteArray(), fileName);
                        if (is == null) break block21;
                    }
                    catch (Throwable throwable) {
                        if (is != null) {
                            try {
                                is.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    is.close();
                }
                return icCubeChromePrintJobResult;
            }
        }
        catch (URISyntaxException ex) {
            OlapLoggers.PRINT.error((Object)"[printing] URI error", (Throwable)ex);
            return new IcCubeErrorPrintJobResult(job, "Error printing report (unexpected URI) : " + ex.getMessage());
        }
        catch (InterruptedException ex) {
            OlapLoggers.PRINT.error((Object)"[printing] interrupted", (Throwable)ex);
            return new IcCubeErrorPrintJobResult(job, "Error printing report (interrupted) : " + ex.getMessage());
        }
        catch (IOException ex) {
            OlapLoggers.PRINT.error((Object)"[printing] IO error", (Throwable)ex);
            return new IcCubeErrorPrintJobResult(job, "Error printing report (IO error) : " + ex.getMessage());
        }
    }

    private static String getFileName(IcCubePrintJob job) {
        if (job.getAttachmentType() == AlertAttachmentType.WIDGET) {
            return job.getWidgetFileName();
        }
        return job.getPdfName();
    }

    private static String getContentType(IcCubePrintJob job) {
        if (job.getAttachmentType() == AlertAttachmentType.WIDGET) {
            return !"csv".equals(job.getWidgetFormat()) ? "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet" : "text/csv";
        }
        return "application/pdf";
    }

    protected static HttpClient createClient() {
        return HttpClient.newBuilder().version(HttpClient.Version.HTTP_1_1).build();
    }

    protected static InputStream responseInputStream(HttpResponse<InputStream> httpResponse) throws IOException {
        HttpHeaders headers = httpResponse.headers();
        String encoding = headers.firstValue("Content-Encoding").orElse(null);
        InputStream is = "gzip".equalsIgnoreCase(encoding) ? new GZIPInputStream(httpResponse.body()) : httpResponse.body();
        return is;
    }

    private static String responseErrorMessage(HttpResponse<InputStream> response, int statusCode) {
        block8: {
            String string;
            block9: {
                if (statusCode != 500 && statusCode != 429) break block8;
                InputStream is = IcCubeDockerPrintService.responseInputStream(response);
                try {
                    ByteArrayOutputStream os = new ByteArrayOutputStream();
                    IOUtils.copy((InputStream)is, (OutputStream)os);
                    string = os.toString(StandardCharsets.UTF_8);
                    if (is == null) break block9;
                }
                catch (Throwable throwable) {
                    try {
                        if (is != null) {
                            try {
                                is.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Exception ex) {
                        OlapLoggers.PRINT.warn((Object)"[printing] could not extract the print server error", (Throwable)ex);
                    }
                }
                is.close();
            }
            return string;
        }
        return "not available";
    }

    public LinkedHashMap<String, Object> getStatus() {
        LinkedHashMap<String, Object> status;
        block15: {
            status = new LinkedHashMap<String, Object>();
            status.put("psAddress", this.address);
            try {
                URI uri = new URI(this.address + "admin/status");
                HttpRequest request = HttpRequest.newBuilder(uri).timeout(Duration.ofSeconds(10L)).header("Cache-Control", "no-cache").header("Accept-Encoding", "gzip").POST(HttpRequest.BodyPublishers.ofString("")).build();
                try (HttpClient client = IcCubeDockerPrintService.createClient();){
                    HttpResponse<InputStream> response = client.send(request, HttpResponse.BodyHandlers.ofInputStream());
                    int statusCode = response.statusCode();
                    if (statusCode >= 300) {
                        OlapLoggers.PRINT.error((Object)("[printing-docker] could not retrieve its status : " + statusCode));
                        break block15;
                    }
                    try (InputStream is = IcCubeDockerPrintService.responseInputStream(response);){
                        ByteArrayOutputStream os = new ByteArrayOutputStream();
                        IOUtils.copy((InputStream)is, (OutputStream)os);
                        StringReader reader = new StringReader(os.toString(StandardCharsets.UTF_8));
                        Map json = (Map)new GsonBuilder().create().fromJson((Reader)reader, Map.class);
                        status.putAll(json);
                    }
                }
            }
            catch (IOException | InterruptedException | URISyntaxException ex) {
                OlapLoggers.PRINT.error((Object)"[printing-docker] could not retrieve its status", (Throwable)ex);
            }
        }
        return status;
    }

    @Override
    protected void onExecutePrintJobFinally(IcCubePrintJob job) {
        this.removeExecutingJob(job);
    }
}

