/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.server.request.processor.print.chrome;

import crazydev.common.exception.CdException;
import crazydev.common.fs.CdVFileSystem;
import crazydev.common.fs.CdVFileSystemTmpReason;
import crazydev.common.fs.CdVFileSystemUtils;
import crazydev.common.utils.CdStringUtils;
import crazydev.iccube.directories.OlapDirectories;
import crazydev.iccube.olap.loggers.OlapLoggers;
import crazydev.iccube.server.print.IcCubePrintComponentConfiguration;
import crazydev.iccube.server.request.processor.print.chrome.IcCubeChromeLauncher;
import io.webfolder.cdp.Constant;
import io.webfolder.cdp.Options;
import io.webfolder.cdp.channel.ChannelFactory;
import io.webfolder.cdp.command.Browser;
import io.webfolder.cdp.exception.CdpException;
import io.webfolder.cdp.logger.CdpLoggerType;
import io.webfolder.cdp.process.AdaptiveProcessManager;
import io.webfolder.cdp.process.ProcessManager;
import io.webfolder.cdp.session.Command;
import io.webfolder.cdp.session.Session;
import io.webfolder.cdp.session.SessionFactory;
import io.webfolder.cdp.type.browser.GetVersionResult;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantLock;
import org.jetbrains.annotations.Nullable;

public class IcCubeChromeProxy {
    private final ReentrantLock restartLOCK = new ReentrantLock();
    private final OlapDirectories directories;
    private final IcCubePrintComponentConfiguration configuration;
    private final AtomicInteger jobCountTotal = new AtomicInteger();
    private final AtomicInteger jobCountUptime = new AtomicInteger();
    private volatile Semaphore permits;
    @Nullable
    private volatile Options options;
    @Nullable
    private volatile ChannelFactory webSocketFactory;
    @Nullable
    private volatile IcCubeChromeLauncher launcher;
    @Nullable
    private volatile SessionFactory sessionFactory;
    @Nullable
    private volatile Date startTime;
    @Nullable
    private volatile GetVersionResult version;

    public IcCubeChromeProxy(OlapDirectories directories, IcCubePrintComponentConfiguration configuration) {
        this.directories = directories;
        this.configuration = configuration;
    }

    public int getMaxActiveCount() {
        return this.configuration.getMaxActiveCount();
    }

    public int getReadingTimeoutMS() {
        return this.configuration.getReadingTimeoutMS();
    }

    @Nullable
    public String getExec() {
        return this.configuration.getExec();
    }

    @Nullable
    public String getExecOptions() {
        return this.configuration.getExecOptions();
    }

    public boolean isRunning() {
        SessionFactory sf = this.sessionFactory;
        return sf != null && !sf.closed();
    }

    @Nullable
    public String getPID() {
        return this.pid();
    }

    @Nullable
    public String getDebug() {
        IcCubeChromeLauncher l = this.launcher;
        return l != null ? l.getListening() : null;
    }

    @Nullable
    public Date getStartTime() {
        return this.startTime;
    }

    public int getJobCountTotal() {
        return this.jobCountTotal.get();
    }

    public int getJobCountUptime() {
        return this.jobCountUptime.get();
    }

    public String getPermitCount() {
        return this.permits.availablePermits() + " [Q:" + this.permits.getQueueLength() + "]";
    }

    public void setup() throws CdException {
        try {
            this.permits = new Semaphore(this.getMaxActiveCount());
            OlapLoggers.PRINT.info((Object)"[printing] ");
            OlapLoggers.PRINT.info((Object)"[printing] Chrome|Chromium headless setup (and launch)");
            OlapLoggers.PRINT.info((Object)"[printing] ");
            OlapLoggers.PRINT.info((Object)("[printing]                       OS : " + Constant.OS_NAME));
            OlapLoggers.PRINT.info((Object)("[printing]                    Linux : " + Constant.LINUX));
            OlapLoggers.PRINT.info((Object)("[printing]                  Windows : " + Constant.WINDOWS));
            OlapLoggers.PRINT.info((Object)("[printing]                      OSX : " + Constant.OSX));
            OlapLoggers.PRINT.info((Object)"[printing] ");
            OlapLoggers.PRINT.info((Object)("[printing]   ICCUBE_NO_SAFE_PROCESS : " + System.getenv("ICCUBE_NO_SAFE_PROCESS")));
            OlapLoggers.PRINT.info((Object)("[printing] ICCUBE_CHROME_NO_SANDBOX : " + System.getenv("ICCUBE_CHROME_NO_SANDBOX")));
            OlapLoggers.PRINT.info((Object)"[printing] ");
            OlapLoggers.PRINT.info((Object)("[printing]          reading timeout : " + this.getReadingTimeoutMS() + "ms"));
            OlapLoggers.PRINT.info((Object)("[printing]                   active : " + this.permits.availablePermits()));
            OlapLoggers.PRINT.info((Object)"[printing] ");
            this.options = this.setupOptions();
            OlapLoggers.PRINT.info((Object)"[printing] Chrome|Chromium options");
            OlapLoggers.PRINT.info((Object)"[printing] ");
            OlapLoggers.PRINT.info((Object)("[printing] --user-data-dir=" + String.valueOf(this.options.userDataDir())));
            for (String argument : this.options.arguments()) {
                OlapLoggers.PRINT.info((Object)("[printing] " + argument));
            }
            OlapLoggers.PRINT.info((Object)"[printing] ");
            this.webSocketFactory = IcCubeChromeLauncher.createChannelFactory();
            this.launcher = new IcCubeChromeLauncher(this.options, this.webSocketFactory);
            if (!this.launcher.isChromeInstalled()) {
                OlapLoggers.PRINT.error((Object)"[printing] Chrome is not installed");
                throw new CdException("Chrome is not installed");
            }
            OlapLoggers.PRINT.info((Object)("[printing]          chrome : " + this.launcher.getChromePath()));
            this.launchChrome();
        }
        catch (IOException ex) {
            throw new CdException((Throwable)ex, "could not setup the Chrome proxy");
        }
    }

    private void launchChrome() {
        OlapLoggers.PRINT.info((Object)"[printing] ");
        OlapLoggers.PRINT.info((Object)"[printing] Starting Chrome|Chromium");
        OlapLoggers.PRINT.info((Object)"[printing] ");
        this.startTime = new Date();
        this.jobCountUptime.set(0);
        try {
            this.sessionFactory = this.launcher.launch();
        }
        catch (CdpException ex) {
            OlapLoggers.PRINT.error((Object)"[printing] could not start Chrome", (Throwable)ex);
        }
        if (this.sessionFactory != null) {
            ProcessManager manager = this.options.processManager();
            String pid = this.pid();
            OlapLoggers.PRINT.info((Object)("[printing] process manager : " + String.valueOf(manager)));
            OlapLoggers.PRINT.info((Object)("[printing] process ID      : " + pid));
            OlapLoggers.PRINT.info((Object)"[printing] ");
            OlapLoggers.PRINT.info((Object)"[printing] Chrome|Chromium has been started");
            OlapLoggers.PRINT.info((Object)"[printing] ");
            GetVersionResult v = this.version = this.extractChromeVersion();
            if (v != null) {
                OlapLoggers.PRINT.info((Object)"[printing] ");
                OlapLoggers.PRINT.info((Object)"[printing] Chrome|Chromium information");
                OlapLoggers.PRINT.info((Object)("[printing]               product : " + v.getProduct()));
                OlapLoggers.PRINT.info((Object)("[printing]              revision : " + v.getRevision()));
                OlapLoggers.PRINT.info((Object)("[printing]            user agent : " + v.getUserAgent()));
                OlapLoggers.PRINT.info((Object)("[printing]      protocol version : " + v.getProtocolVersion()));
                OlapLoggers.PRINT.info((Object)("[printing]            JS version : " + v.getJsVersion()));
                OlapLoggers.PRINT.info((Object)"[printing] ");
            }
        }
    }

    @Nullable
    private GetVersionResult extractChromeVersion() {
        try {
            return this.doExtractChromeVersion();
        }
        catch (Exception exception) {
            OlapLoggers.PRINT.warn((Object)"[printing] could not get Chrome|Chromium version", (Throwable)exception);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private GetVersionResult doExtractChromeVersion() throws Exception {
        block11: {
            String uuid = "chrome-version";
            String browserContext = this.createBrowserContext("chrome-version");
            try {
                if (browserContext == null) break block11;
                try (Session session = this.createSession(browserContext);){
                    if (session != null) {
                        GetVersionResult version;
                        Command command = session.getCommand();
                        Browser browser = command.getBrowser();
                        GetVersionResult getVersionResult = version = browser.getVersion();
                        return getVersionResult;
                    }
                }
            }
            finally {
                this.disposeBrowserContext("chrome-version", browserContext);
            }
        }
        return null;
    }

    @Nullable
    public GetVersionResult getVersion() {
        return this.version;
    }

    public void restart(boolean forced) throws CdException {
        try {
            this.restartLOCK.lockInterruptibly();
            try {
                SessionFactory sf = this.sessionFactory;
                if (forced || sf == null || sf.closed()) {
                    OlapLoggers.PRINT.info((Object)("[printing] Chrome getOrCreateSessionFactory: restarting Chrome: still required [forced:" + forced + "]"));
                    this.shutdownNow();
                    this.setup();
                } else {
                    OlapLoggers.PRINT.info((Object)"[printing] Chrome getOrCreateSessionFactory: restarting Chrome: not required");
                }
            }
            finally {
                this.restartLOCK.unlock();
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void onPrintingJobStarted() {
        this.jobCountUptime.incrementAndGet();
        this.jobCountTotal.incrementAndGet();
    }

    @Nullable
    public String createBrowserContext(String uuid) throws InterruptedException {
        OlapLoggers.PRINT.info((Object)("[printing] job (" + uuid + ") acquire Chrome browser context"));
        this.permits.acquire();
        OlapLoggers.PRINT.info((Object)("[printing] job (" + uuid + ") acquired Chrome browser context"));
        SessionFactory sf = this.getOrCreateSessionFactory();
        if (sf == null) {
            OlapLoggers.PRINT.error((Object)"[printing] Chrome createBrowserContext: the session-factory is null");
            throw new CdpException("could not create browser-context (session-factory null)");
        }
        if (sf.closed()) {
            OlapLoggers.PRINT.error((Object)"[printing] Chrome createBrowserContext: the session-factory is closed");
            throw new CdpException("could not create browser-context (session-factory closed)");
        }
        return sf.createBrowserContext();
    }

    @Nullable
    private SessionFactory getOrCreateSessionFactory() {
        SessionFactory sf = this.sessionFactory;
        if (sf == null) {
            OlapLoggers.PRINT.error((Object)"[printing] Chrome getOrCreateSessionFactory: the session-factory is null");
        } else if (sf.closed()) {
            OlapLoggers.PRINT.error((Object)"[printing] Chrome getOrCreateSessionFactory: the sessionFactory is closed");
            sf = null;
        }
        if (sf == null) {
            OlapLoggers.PRINT.error((Object)"[printing] Chrome getOrCreateSessionFactory: restarting Chrome");
            try {
                this.restart(false);
                sf = this.sessionFactory;
                OlapLoggers.PRINT.error((Object)("[printing] Chrome getOrCreateSessionFactory: Chrome restarted [SF:" + (sf != null) + "]"));
            }
            catch (CdException ex) {
                OlapLoggers.PRINT.error((Object)"[printing] Chrome getOrCreateSessionFactory: failed to restart Chrome", (Throwable)ex);
                sf = null;
            }
        }
        return sf;
    }

    @Nullable
    public Session createSession(String context) {
        SessionFactory sf = this.sessionFactory;
        if (sf == null) {
            return null;
        }
        if (sf.closed()) {
            OlapLoggers.PRINT.error((Object)("[printing] Chrome has been shutdown: could not create a browser-session [" + context + "]"));
            throw new CdpException("could not create browser-session (session-factory closed)");
        }
        return sf.create(context);
    }

    public void disposeBrowserContext(String uuid, @Nullable String context) {
        OlapLoggers.PRINT.info((Object)("[printing] job (" + uuid + ") release Chrome browser context [" + context + "]"));
        this.permits.release();
        OlapLoggers.PRINT.info((Object)("[printing] job (" + uuid + ") released Chrome browser context [" + context + "]"));
        if (context == null) {
            return;
        }
        SessionFactory sf = this.sessionFactory;
        if (sf == null) {
            return;
        }
        if (sf.closed()) {
            return;
        }
        sf.disposeBrowserContext(context);
    }

    public void shutdownNow() {
        OlapLoggers.PRINT.info((Object)"[printing] Chrome shutdown: closing the session-factory");
        try {
            if (this.sessionFactory != null) {
                this.sessionFactory.close();
                this.sessionFactory = null;
            }
        }
        catch (RuntimeException ex) {
            OlapLoggers.PRINT.warn((Object)"[printing] Chrome shutdown error: closing the session-factory", (Throwable)ex);
        }
        OlapLoggers.PRINT.info((Object)("[printing] Chrome shutdown: killing the Chrome process [" + this.pid() + "]"));
        try {
            if (this.launcher != null) {
                this.launcher.kill();
                this.launcher = null;
            }
        }
        catch (RuntimeException ex) {
            OlapLoggers.PRINT.warn((Object)"[printing] Chrome shutdown error: killing the Chrome process", (Throwable)ex);
        }
        OlapLoggers.PRINT.info((Object)"[printing] Chrome shutdown: delete the user-data-dir");
        try {
            Options opts = this.options;
            if (opts != null) {
                Path userDataDir = opts.userDataDir();
                OlapLoggers.PRINT.info((Object)("[printing] Chrome shutdown: delete the user-data-dir: " + String.valueOf(userDataDir)));
                CdVFileSystemUtils.deleteQuietly((File)userDataDir.toFile());
            }
        }
        catch (RuntimeException ex) {
            OlapLoggers.PRINT.warn((Object)"[printing] Chrome shutdown error: deleting the user-data-dir", (Throwable)ex);
        }
        OlapLoggers.PRINT.info((Object)"[printing] Chrome shutdown: done");
    }

    private Options setupOptions() throws IOException {
        String execOptions;
        String exec;
        File remoteProfileData = this.getRemoteProfileData();
        Options.Builder builder = Options.builder().headless(true).loggerType(CdpLoggerType.Log4j).readTimeout(this.getReadingTimeoutMS()).userDataDir(remoteProfileData.toPath());
        String noSafeProcess = System.getenv("ICCUBE_NO_SAFE_PROCESS");
        if ("1".equals(noSafeProcess)) {
            builder.safeProcessPath("");
        }
        if (CdStringUtils.isNotNullAndNotBlank((String)(exec = this.getExec()))) {
            builder = builder.browserExecutablePath(exec);
        }
        ArrayList<String> arguments = new ArrayList<String>();
        arguments.add("--disable-gpu");
        String noSandbox = System.getenv("ICCUBE_CHROME_NO_SANDBOX");
        if ("1".equals(noSandbox)) {
            arguments.add("--no-sandbox");
        }
        if (CdStringUtils.isNotNullAndNotBlank((String)(execOptions = this.getExecOptions()))) {
            arguments.addAll(Arrays.asList(execOptions.split(" ")));
        }
        builder = builder.arguments(arguments);
        return builder.build();
    }

    protected File getRemoteProfileData() throws IOException {
        CdVFileSystem vfs = this.directories.getVfs();
        return vfs.createTmpDirectory(CdVFileSystemTmpReason.CHROME_REMOTE_PROFILE, this.directories.getTmpDirectory__());
    }

    @Nullable
    private String pid() {
        Options opts = this.options;
        if (opts == null) {
            OlapLoggers.PRINT.warn((Object)"[printing] Chrome could not retrieve the PID (no options)");
            return null;
        }
        ProcessManager manager = opts.processManager();
        if (manager == null) {
            OlapLoggers.PRINT.warn((Object)"[printing] Chrome could not retrieve the PID (no process manager)");
            return null;
        }
        if (manager instanceof AdaptiveProcessManager) {
            try {
                Field processManagerF = manager.getClass().getDeclaredField("processManager");
                processManagerF.setAccessible(true);
                manager = (ProcessManager)processManagerF.get(manager);
            }
            catch (Exception ex) {
                OlapLoggers.PRINT.warn((Object)"[printing] Chrome could not retrieve the PID", (Throwable)ex);
                return null;
            }
        }
        try {
            Field pidF = manager.getClass().getDeclaredField("pid");
            pidF.setAccessible(true);
            Object pid = pidF.get(manager);
            return pid.toString();
        }
        catch (Exception ex) {
            OlapLoggers.PRINT.warn((Object)"[printing] Chrome could not retrieve the PID", (Throwable)ex);
            return null;
        }
    }
}

