/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.server.request.processor.print.chrome;

import crazydev.iccube.olap.loggers.OlapLoggers;
import io.webfolder.cdp.Constant;
import io.webfolder.cdp.Launcher;
import io.webfolder.cdp.Options;
import io.webfolder.cdp.channel.ChannelFactory;
import io.webfolder.cdp.channel.Connection;
import io.webfolder.cdp.channel.JreWebSocketFactory;
import io.webfolder.cdp.channel.NvWebSocketFactory;
import io.webfolder.cdp.channel.WebSocketConnection;
import io.webfolder.cdp.exception.CdpException;
import io.webfolder.cdp.logger.CdpLogger;
import io.webfolder.cdp.logger.CdpLoggerFactory;
import io.webfolder.cdp.process.CdpProcess;
import io.webfolder.cdp.session.SessionFactory;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.List;
import java.util.Locale;
import java.util.Scanner;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ThreadLocalRandom;
import org.jetbrains.annotations.Nullable;

public class IcCubeChromeLauncher
extends Launcher {
    private static final ExecutorService executor = ForkJoinPool.commonPool();
    private final Options options;
    private final ChannelFactory channelFactory;
    private final CdpLogger log;
    private String chromePath = "";
    @Nullable
    private String listening;

    public IcCubeChromeLauncher(Options options, ChannelFactory webSocketFactory) {
        super(options, webSocketFactory);
        this.options = options;
        this.channelFactory = webSocketFactory;
        this.log = new CdpLoggerFactory(options).getLogger("cdp4j.launcher");
    }

    public static ChannelFactory createChannelFactory() {
        if (Constant.JAVA_8) {
            return new NvWebSocketFactory();
        }
        return new JreWebSocketFactory((Executor)executor);
    }

    public static void initialize() {
        OlapLoggers.PRINT.info((Object)"[printing] Chrome launcher initialized");
    }

    public String findChrome() {
        String executablePath = this.options.browserExecutablePath();
        if (executablePath != null && !executablePath.trim().isEmpty()) {
            this.chromePath = super.findChrome();
            return this.chromePath;
        }
        if (Constant.WINDOWS) {
            this.chromePath = super.findChrome();
            return this.chromePath;
        }
        if (Constant.OSX) {
            this.chromePath = super.findChrome();
            return this.chromePath;
        }
        String chrome = "google-chrome";
        String chromium = "chromium-browser";
        executablePath = "google-chrome";
        try {
            this.log.info("Browser executablePath [GNU/Linux]: checking {}", new Object[]{"chromium-browser"});
            ProcessBuilder pb = new ProcessBuilder("which", "chromium-browser");
            Process process = pb.start();
            int exitCode = process.waitFor();
            if (exitCode == 0) {
                executablePath = "chromium-browser";
            }
        }
        catch (Throwable ex) {
            OlapLoggers.PRINT.error((Object)"[printing] could not use which to find Chrome|Chromium", ex);
        }
        this.log.info("Browser executablePath [GNU/Linux]: {}", new Object[]{executablePath});
        this.chromePath = executablePath;
        return this.chromePath;
    }

    public String getChromePath() {
        return this.chromePath;
    }

    public SessionFactory launch() {
        return super.launch();
    }

    protected SessionFactory launchWithProcessBuilder(List<String> arguments) {
        for (int ii = 0; ii < arguments.size(); ++ii) {
            String arg = arguments.get(ii);
            if (!arg.equals("--headless")) continue;
            arguments.set(ii, "--headless=new");
        }
        String cdp4jId = Long.toHexString(ThreadLocalRandom.current().nextLong());
        arguments.add(String.format("--cdp4jId=%s", cdp4jId));
        WebSocketConnection connection = null;
        ProcessBuilder builder = new ProcessBuilder(arguments);
        builder.environment().put("CDP4J_ID", cdp4jId);
        this.log.info("launcher: {}", new Object[]{"ProcessBuilder:arguments:" + String.valueOf(arguments)});
        try {
            Process process = builder.start();
            try (Scanner scanner = new Scanner(process.getErrorStream());){
                while (scanner.hasNext()) {
                    String line = scanner.nextLine().trim();
                    this.log.info("launcher: {}", new Object[]{"ProcessBuilder:stderr:" + line});
                    if (line.isEmpty() || !line.toLowerCase(Locale.ENGLISH).startsWith("devtools listening on")) continue;
                    int start = line.indexOf("ws://");
                    String url = line.substring(start);
                    connection = new WebSocketConnection(url);
                    this.listening = url;
                    break;
                }
                if (connection == null) {
                    throw new CdpException("Could not retrieve the WebSocket connection URL (missing Chrome/Chromium process?).");
                }
            }
            if (!process.isAlive()) {
                throw new CdpException("The Chrome/Chromium process is not alive.");
            }
            this.options.processManager().setProcess(new CdpProcess((Object)process, cdp4jId));
            URL url = new URI(connection.getUrl().replace("ws://", "http://")).toURL();
            this.log.info("DevTools remote debugging URL: http://{}:{}", new Object[]{url.getHost(), url.getPort()});
            return new SessionFactory(this.options, this.channelFactory, (Connection)connection);
        }
        catch (IOException | IllegalArgumentException | URISyntaxException e) {
            throw new CdpException((Throwable)e);
        }
    }

    @Nullable
    public String getListening() {
        return this.listening;
    }
}

