/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.server.request.processor.print;

import crazydev.common.exception.CdException;
import crazydev.iccube.babylon.OlapBabylonService;
import crazydev.iccube.directories.OlapDirectories;
import crazydev.iccube.olap.loggers.OlapLoggers;
import crazydev.iccube.request.status.IcCubeRequestStatusManager;
import crazydev.iccube.server.context.IcCubeServerSessionContext;
import crazydev.iccube.server.http.IcCubeHttpComponent;
import crazydev.iccube.server.print.IcCubePrintComponent;
import crazydev.iccube.server.print.IcCubePrintComponentConfiguration;
import crazydev.iccube.server.request.processor.print.IcCubeErrorPrintJobResult;
import crazydev.iccube.server.request.processor.print.IcCubePrintJob;
import crazydev.iccube.server.request.processor.print.IcCubePrintJobResult;
import crazydev.iccube.server.request.processor.print.IcCubePrintJobStatus;
import crazydev.iccube.server.request.processor.print.browser.IcCubeInBrowserPrintService;
import crazydev.iccube.server.request.processor.print.chrome.IcCubeChromePrintService;
import crazydev.iccube.server.request.processor.print.chrome.IcCubeDockerPrintService;
import jakarta.servlet.http.HttpSession;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public abstract class IcCubePrintService {
    public static final String IC3_PRINT_SERVER = "ic3-print-server";
    private final boolean sessionLess;
    protected final IcCubePrintComponentConfiguration configuration;
    protected final String listeningUrl;
    protected final List<IcCubePrintJob> executingJobs = new ArrayList<IcCubePrintJob>();
    private final boolean printOnServerAvailable;

    protected IcCubePrintService(IcCubeHttpComponent httpComponent, IcCubePrintComponent printComponent, boolean printOnServerAvailable) {
        this.sessionLess = httpComponent.isSessionLess();
        this.printOnServerAvailable = printOnServerAvailable;
        this.configuration = printComponent.getConfiguration();
        this.listeningUrl = httpComponent.getPrintListeningUrl(this.configuration);
        OlapLoggers.PRINT.info((Object)("[printing] active           :" + printOnServerAvailable));
        OlapLoggers.PRINT.info((Object)("[printing] URL              : [cnf:" + this.configuration.getPrintUrl() + "] [resolved:" + this.listeningUrl + "]"));
    }

    public static IcCubePrintService create(IcCubeHttpComponent httpComponent, IcCubePrintComponent printComponent, boolean printOnServerLicensed, OlapDirectories directories, IcCubePrintComponentConfiguration configuration) {
        if (!printOnServerLicensed || !configuration.isPrintOnServerActive()) {
            return new IcCubeInBrowserPrintService(httpComponent, printComponent);
        }
        String exec = configuration.getExec();
        if (IC3_PRINT_SERVER.equals(exec)) {
            return new IcCubeDockerPrintService(httpComponent, printComponent, directories, configuration);
        }
        return new IcCubeChromePrintService(httpComponent, printComponent, directories, configuration);
    }

    public boolean canRestart() {
        return false;
    }

    public boolean isPrintOnServerAvailable() {
        return this.printOnServerAvailable;
    }

    public abstract void setUp() throws CdException;

    public abstract void shutdownNow();

    public IcCubePrintComponentConfiguration getConfiguration() {
        return this.configuration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IcCubePrintJobResult execute(OlapBabylonService babylon, IcCubeRequestStatusManager requests, IcCubePrintJob job) throws InterruptedException {
        List<IcCubePrintJob> list = this.executingJobs;
        synchronized (list) {
            this.executingJobs.add(job);
        }
        requests.onRequestPrintingJobAdded(job.getRequestUUID(), job.getUuid());
        return this.executePrintJob(babylon, job);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IcCubePrintJobResult executePrintJob(OlapBabylonService babylon, IcCubePrintJob job) throws InterruptedException {
        String kind = job.getAttachmentType().name();
        try {
            IcCubePrintJobResult icCubePrintJobResult = this.doExecutePrintJob(babylon, job);
            return icCubePrintJobResult;
        }
        catch (RuntimeException ex) {
            OlapLoggers.GENERAL.error((Object)("[printing] job (" + job.getUuid() + ") printing error"), (Throwable)ex);
            IcCubeErrorPrintJobResult icCubeErrorPrintJobResult = new IcCubeErrorPrintJobResult(job, "No " + kind + " generated [error : " + ex.getMessage() + "]");
            return icCubeErrorPrintJobResult;
        }
        catch (InterruptedException ex) {
            OlapLoggers.GENERAL.error((Object)("[printing] job (" + job.getUuid() + ") printing interrupted"));
            throw ex;
        }
        catch (IOException ex) {
            OlapLoggers.GENERAL.error((Object)("[printing] job (" + job.getUuid() + ") printing IO error"), (Throwable)ex);
            IcCubeErrorPrintJobResult icCubeErrorPrintJobResult = new IcCubeErrorPrintJobResult(job, "No " + kind + " generated [IO error : " + ex.getMessage() + " ]");
            return icCubeErrorPrintJobResult;
        }
        finally {
            this.onExecutePrintJobFinally(job);
        }
    }

    protected void onExecutePrintJobFinally(IcCubePrintJob job) {
    }

    protected abstract IcCubePrintJobResult doExecutePrintJob(OlapBabylonService var1, IcCubePrintJob var2) throws IOException, InterruptedException;

    public int setupTimeout(int timeout) {
        if (timeout <= 0) {
            return this.configuration.getTimeout();
        }
        return timeout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<IcCubePrintJobStatus> getAllSortedActiveJobs() {
        ArrayList<IcCubePrintJobStatus> allStatus = new ArrayList<IcCubePrintJobStatus>();
        List<IcCubePrintJob> list = this.executingJobs;
        synchronized (list) {
            for (IcCubePrintJob executingJob : this.executingJobs) {
                allStatus.add(new IcCubePrintJobStatus(executingJob.getUuid(), executingJob.getRequestingPrincipal(), executingJob.getStartTimeMS(), executingJob.getRequestUUID()));
            }
        }
        return allStatus;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public IcCubePrintJob getExecutingJob(@Nullable String uuid) {
        List<IcCubePrintJob> list = this.executingJobs;
        synchronized (list) {
            for (IcCubePrintJob job : this.executingJobs) {
                if (!job.getUuid().equals(uuid)) continue;
                return job;
            }
        }
        return null;
    }

    public void removeExecutingJob(String jobUUID) {
        IcCubePrintJob job = this.getExecutingJob(jobUUID);
        if (job != null) {
            this.removeExecutingJob(job);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeExecutingJob(IcCubePrintJob job) {
        if (!this.sessionLess) {
            try {
                HttpSession session = job.getHttpSession();
                if (session != null) {
                    session.invalidate();
                }
            }
            catch (RuntimeException ignored) {
                OlapLoggers.PRINT.warn((Object)("[printing] job (" + job.getUuid() + ") printing : could not properly destroy the HTTP session"), (Throwable)ignored);
            }
        }
        try {
            IcCubeServerSessionContext.onSessionDestroyed(job.getRequestingPrincipalHttpSession());
        }
        catch (RuntimeException ignored) {
            OlapLoggers.PRINT.warn((Object)("[printing] job (" + job.getUuid() + ") printing : could not properly destroy the requesting principal session"), (Throwable)ignored);
        }
        List<IcCubePrintJob> list = this.executingJobs;
        synchronized (list) {
            this.executingJobs.remove(job);
        }
    }
}

