/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.server.request.processor.print;

import crazydev.iccube.olap.loggers.OlapLoggers;
import crazydev.iccube.pub.principal.OlapPrincipal;
import crazydev.iccube.request.status.IcCubeRequestStatusManager;
import crazydev.iccube.server.context.IcCubeServerApplicationContext;
import crazydev.iccube.server.context.IcCubeServerSessionContext;
import crazydev.iccube.server.gvi.request.common.GviResponse;
import crazydev.iccube.server.request.executor.IcCubeServerTaskExecutor;
import crazydev.iccube.server.request.processor.common.IcCubeRequestProcessor;
import crazydev.iccube.server.request.processor.gvi.IcCubeGviRequestProcessor;
import crazydev.iccube.server.request.processor.print.IcCubePrintJob;
import crazydev.iccube.server.request.processor.print.IcCubePrintService;
import crazydev.iccube.server.request.processor.print.IcCubePrintServletHttpRequest;
import crazydev.iccube.server.request.request.print.IcCubePrintServerRequest;
import crazydev.iccube.server.request.request.print.IcCubePrintServerRequestContext;
import crazydev.iccube.server.request.request.print.IcCubePrintServerRequestReply;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.File;
import java.io.IOException;
import org.jetbrains.annotations.Nullable;

public class IcCubePrintRequestProcessor
extends IcCubeRequestProcessor<GviResponse, IcCubePrintServerRequest, IcCubePrintServerRequestReply, IcCubePrintServerRequestContext> {
    public IcCubePrintRequestProcessor(IcCubeServerTaskExecutor taskExecutor, IcCubeRequestStatusManager statusManager) {
        super(taskExecutor, statusManager);
    }

    public void processPrintRequest(HttpServletRequest httpRequest, HttpServletResponse httpResponse) throws IOException, ServletException {
        String pathInfo;
        if (OlapLoggers.PRINT.isDebugEnabled()) {
            OlapLoggers.PRINT.debug((Object)("[printing] print request received : " + httpRequest.getRequestURI()));
        }
        if ((pathInfo = httpRequest.getPathInfo()) != null) {
            String jobUUID;
            String[] parts;
            String firstNonEmptyPart = null;
            for (String part : parts = pathInfo.split("/")) {
                if (part == null || part.isEmpty()) continue;
                firstNonEmptyPart = part;
                break;
            }
            if ((jobUUID = firstNonEmptyPart) != null) {
                IcCubeServerSessionContext sessionContext = IcCubeServerSessionContext.getOrCreateSessionContext(httpRequest);
                IcCubePrintService printService = sessionContext.getPrintService();
                if (printService == null) {
                    throw new RuntimeException("The print server is not enabled.");
                }
                IcCubePrintJob job = printService.getExecutingJob(jobUUID);
                if (job == null) {
                    throw new RuntimeException("The requested print job is not available.");
                }
                OlapPrincipal printingPrincipal = job.getRequestingPrincipal();
                OlapPrincipal principal = sessionContext.getUser();
                if (principal != printingPrincipal) {
                    throw new RuntimeException("The user is not authorized for the print job " + (printingPrincipal != null ? printingPrincipal.logInfo() : "null") + " " + principal.logInfo());
                }
                if (pathInfo.startsWith("/" + jobUUID + "/command")) {
                    String string = httpRequest.getParameter("action");
                } else {
                    if (pathInfo.startsWith("/" + jobUUID + "/doc") || pathInfo.startsWith("/" + jobUUID + "/report")) {
                        this.processDocsRequest(httpRequest, httpResponse, job);
                        return;
                    }
                    if (pathInfo.startsWith("/" + jobUUID + "/gvi")) {
                        this.processGviRequest(httpRequest, httpResponse, job);
                        return;
                    }
                    if (pathInfo.startsWith("/" + jobUUID + "/")) {
                        this.processDocsRequest(httpRequest, httpResponse, job);
                        return;
                    }
                }
            }
        }
        throw new RuntimeException("Print error : unexpected printing URL (" + httpRequest.getRequestURI() + ")");
    }

    @Override
    protected GviResponse createSuccessResponse(IcCubePrintServerRequestContext requestContext, IcCubePrintServerRequest request, IcCubePrintServerRequestReply reply) {
        throw new RuntimeException("internal error : inconsistent createSuccessResponse usage");
    }

    @Override
    protected GviResponse createCancelledResponse(IcCubePrintServerRequestContext requestContext, IcCubePrintServerRequest request, boolean onTimeout, @Nullable String extraInfo) {
        throw new RuntimeException("internal error : inconsistent createCancelledResponse usage");
    }

    @Override
    protected GviResponse createExceptionResponseEx(IcCubePrintServerRequestContext requestContext, IcCubePrintServerRequest request, Throwable exception) {
        throw new RuntimeException("internal error : inconsistent createExceptionResponseEx usage");
    }

    @Override
    protected GviResponse createMissingReplyResponse(IcCubePrintServerRequestContext requestContext, IcCubePrintServerRequest request) {
        throw new RuntimeException("internal error : inconsistent createMissingReplyResponse usage");
    }

    private void processDocsRequest(HttpServletRequest request, HttpServletResponse response, IcCubePrintJob job) throws IOException, ServletException {
        String requestURI = request.getRequestURI();
        String redirectURL = response.encodeRedirectURL(requestURI.replace("/icCube/print/" + job.getUuid(), "/icCube"));
        if (!job.isMF()) {
            if (!redirectURL.startsWith("/icCube/doc")) {
                redirectURL = redirectURL.replace("/icCube", "/icCube/doc");
            }
        } else {
            int pos = redirectURL.indexOf(";");
            if (pos != -1) {
                redirectURL = redirectURL.substring(0, pos);
            }
        }
        OlapPrincipal principal = job.getRequestingPrincipal();
        if (OlapLoggers.PRINT.isDebugEnabled()) {
            OlapLoggers.PRINT.debug((Object)("[printing] docs request received [user:" + principal.getName() + "] : " + requestURI + " redirect to : " + redirectURL));
        }
        IcCubePrintServletHttpRequest request_ = new IcCubePrintServletHttpRequest(request, job);
        String servletCanPath = new File("/icCube/").getCanonicalPath();
        String redirectUrlCanPath = new File(redirectURL).getCanonicalPath();
        if (!redirectUrlCanPath.startsWith(servletCanPath)) {
            throw new RuntimeException("Print error : unexpected printing URL (" + request.getRequestURI() + ")");
        }
        request_.getRequestDispatcher(redirectURL).forward((ServletRequest)request_, (ServletResponse)response);
    }

    private void processGviRequest(HttpServletRequest request, HttpServletResponse response, IcCubePrintJob job) throws IOException {
        String action = request.getParameter("action");
        if ("login".equals(action)) {
            String userName;
            if (OlapLoggers.PRINT.isDebugEnabled()) {
                OlapLoggers.PRINT.debug((Object)("[printing] GVI request (login) received : " + request.getRequestURI()));
            }
            if (!"ic3-fake-user".equals(userName = request.getParameter("userName"))) {
                throw new RuntimeException("internal error : inconsistent GVI login usage");
            }
        }
        if (OlapLoggers.PRINT.isDebugEnabled()) {
            OlapLoggers.PRINT.debug((Object)("[printing] GVI request received : " + request.getRequestURI()));
        }
        this.processGviRequestEx(request, response, job);
    }

    private void processGviRequestEx(HttpServletRequest request, HttpServletResponse response, IcCubePrintJob job) throws IOException {
        ServletContext servletContext = request.getServletContext();
        IcCubePrintServletHttpRequest request_ = new IcCubePrintServletHttpRequest(request, job);
        IcCubeServerApplicationContext applicationContext = IcCubeServerApplicationContext.getApplicationContext(servletContext);
        IcCubeGviRequestProcessor gviRequestProcessor = applicationContext.getGviRequestProcessor();
        if (OlapLoggers.PRINT.isDebugEnabled()) {
            OlapLoggers.PRINT.debug((Object)("[printing] GVI request dispatching [" + request.getRequestURI() + "] [session:" + request_.getSessionId() + "]"));
        }
        gviRequestProcessor.processGviRequest(request_, response);
    }
}

