/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.server.request.processor.print;

import crazydev.common.utils.CdStringUtils;
import crazydev.iccube.olap.loggers.OlapLoggers;
import crazydev.iccube.pub.principal.OlapPrincipal;
import crazydev.iccube.server.gvi.request.report.GviPrintParams;
import crazydev.iccube.server.request.processor.print.IcCubeAbstractPrintReportJob;
import crazydev.iccube.server.request.processor.print.IcCubePrintJobCommandLineMF;
import crazydev.iccube.server.request.processor.print.IcCubePrintService;
import crazydev.iccube.server.request.processor.print.IcCubePrintState;
import crazydev.iccube.server.scheduler.definition.AlertAttachmentType;
import org.jetbrains.annotations.Nullable;

public class IcCubePrintReportBatchJob
extends IcCubeAbstractPrintReportJob {
    private final String reportPath;
    @Nullable
    private final String reportParams;
    @Nullable
    private final IcCubePrintState reportState;
    private final String pdfName;
    @Nullable
    private final String widgetId;
    @Nullable
    private final String widgetFormat;
    @Nullable
    private final String widgetFileName;
    private final AlertAttachmentType attachementType;

    public IcCubePrintReportBatchJob(IcCubePrintService printService, String requestUUID, OlapPrincipal principal, GviPrintParams printParams, @Nullable IcCubePrintState reportState) {
        this(printService, requestUUID, principal, printParams, reportState, AlertAttachmentType.PDF, null, null, null);
    }

    public IcCubePrintReportBatchJob(IcCubePrintService printService, String requestUUID, OlapPrincipal principal, GviPrintParams printParams, @Nullable IcCubePrintState reportState, AlertAttachmentType attachementType, @Nullable String widgetId, @Nullable String widgetFormat, @Nullable String widgetFileName) {
        super(printService, requestUUID, principal, null, printParams.getTimeout(), new IcCubePrintJobCommandLineMF(printParams.getReportPath(), printParams.getReportParams(), printParams));
        this.reportPath = printParams.getReportPath();
        this.reportParams = printParams.getReportParams();
        this.reportState = reportState;
        this.attachementType = attachementType;
        this.pdfName = IcCubePrintReportBatchJob.setupPdfName(this.reportPath, printParams.getFileName());
        this.requestingPrincipalHttpSession.setReportState(reportState);
        this.requestingPrincipalHttpSession.setReportPatches(printParams.getPatches());
        if (reportState == null) {
            if (OlapLoggers.DOC_REPOSITORY.isDebugEnabled()) {
                OlapLoggers.DOC_REPOSITORY.debug((Object)"[docs] set report state: none");
            }
        } else if (OlapLoggers.DOC_REPOSITORY.isDebugEnabled()) {
            OlapLoggers.DOC_REPOSITORY.debug((Object)"[docs] set report state: ok");
        }
        this.widgetId = widgetId;
        this.widgetFormat = widgetFormat;
        this.widgetFileName = widgetFileName;
    }

    private static String setupPdfName(String reportPath, @Nullable String fileName) {
        if (fileName != null) {
            if (fileName.toLowerCase().endsWith(".pdf")) {
                return fileName;
            }
            return fileName + ".pdf";
        }
        Object name = "icCube-report.pdf";
        try {
            String[] parts = reportPath.split("/");
            if (parts != null && parts.length > 0) {
                name = parts[parts.length - 1] + ".pdf";
            }
        }
        catch (RuntimeException ex) {
            OlapLoggers.PRINT.warn((Object)("[printing] could not setup the report PDF name for : " + reportPath), (Throwable)ex);
        }
        return name;
    }

    @Override
    public String getReportPath() {
        return this.reportPath;
    }

    @Override
    @Nullable
    public String getReportParams() {
        return this.reportParams;
    }

    @Override
    @Nullable
    public IcCubePrintState getReportState() {
        return this.reportState;
    }

    @Override
    public String getPdfName() {
        return this.pdfName;
    }

    @Override
    public AlertAttachmentType getAttachmentType() {
        return this.attachementType;
    }

    @Override
    @Nullable
    public String getWidgetId() {
        return this.widgetId;
    }

    @Override
    public String getWidgetFormat() {
        return CdStringUtils.isNotNullAndNotBlank((String)this.widgetFormat) ? this.widgetFormat.toLowerCase() : "xlsx";
    }

    @Override
    public String getWidgetFileName() {
        String ext = "." + this.getWidgetFormat();
        if (CdStringUtils.isNotNullAndNotBlank((String)this.widgetFileName)) {
            if (this.widgetFileName.toLowerCase().endsWith(ext)) {
                return this.widgetFileName;
            }
            return this.widgetFileName + ext;
        }
        return this.getPdfName().replace(".pdf", "." + this.widgetId + ext);
    }
}

