/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.server.request.processor.print;

import com.google.gson.GsonBuilder;
import crazydev.iccube.server.gvi.request.report.GviPrintParams;
import crazydev.iccube.server.request.processor.print.IcCubePrintJobCommandLine;
import java.io.UnsupportedEncodingException;
import java.lang.invoke.CallSite;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.Nullable;

public class IcCubePrintJobCommandLineMF
extends IcCubePrintJobCommandLine {
    private final String reportPath;
    @Nullable
    private final String reportParams;
    private final GviPrintParams printParams;

    public IcCubePrintJobCommandLineMF(String reportPath, @Nullable String reportParams, GviPrintParams printParams) {
        super(null, null);
        this.reportPath = reportPath;
        this.reportParams = reportParams;
        this.printParams = printParams;
    }

    @Override
    public boolean isMF() {
        return true;
    }

    @Override
    public void print() {
        this.printParams.print();
    }

    @Override
    public String getChromeNavigateURL(String listeningUrl, String uuid) {
        String printUrl = listeningUrl + uuid;
        HashMap<String, CallSite> ic3dataSource = new HashMap<String, CallSite>();
        ic3dataSource.put("url", (CallSite)((Object)(printUrl + "/gvi")));
        String ic3dataSourceJS = new GsonBuilder().create().toJson(ic3dataSource);
        HashMap<String, Object> ic3printParams = new HashMap<String, Object>();
        String patches = this.printParams.getPatches();
        if (patches != null) {
            ic3printParams.put("patches", "true");
        }
        ic3printParams.put("scale", this.printParams.getScale());
        ic3printParams.put("pageSizeUnits", this.printParams.getPageSizeUnits());
        ic3printParams.put("pageWidth", this.printParams.getPageWidth());
        ic3printParams.put("pageHeight", this.printParams.getPageHeight());
        ic3printParams.put("marginTop", this.printParams.getMarginTop());
        ic3printParams.put("marginRight", this.printParams.getMarginRight());
        ic3printParams.put("marginBottom", this.printParams.getMarginBottom());
        ic3printParams.put("marginLeft", this.printParams.getMarginLeft());
        Map<String, String> options = this.printParams.getReportingOptions();
        for (Map.Entry<String, String> option : options.entrySet()) {
            ic3printParams.put(option.getKey(), option.getValue());
        }
        String ic3printParamsJS = new GsonBuilder().create().toJson(ic3printParams);
        String url = printUrl + "/report/viewer";
        String appLocalUrl = printUrl + "/report/ic3-reporting/app-local";
        String appDocUrl = printUrl + "/report/ic3-reporting/doc";
        String appDocUrlEx = "";
        return url + "?ic3mode=report&ic3appLocalUrl=" + IcCubePrintJobCommandLineMF.encodeParam(appLocalUrl) + "&ic3appDocUrl=" + IcCubePrintJobCommandLineMF.encodeParam(appDocUrl) + "&ic3appDocUrlEx=" + IcCubePrintJobCommandLineMF.encodeParam("") + "&ic3dataSource=" + IcCubePrintJobCommandLineMF.encodeParam(ic3dataSourceJS) + "&ic3report=" + IcCubePrintJobCommandLineMF.encodeParam(this.reportPath) + "&ic3printParams=" + IcCubePrintJobCommandLineMF.encodeParam(ic3printParamsJS);
    }

    private static String encodeParam(String value) {
        try {
            return URLEncoder.encode(value, "UTF-8");
        }
        catch (UnsupportedEncodingException ignored) {
            throw new RuntimeException(ignored);
        }
    }

    @Override
    public String processBodySize(String html) {
        return html;
    }

    @Override
    public int getDebugWaitTime() {
        return this.printParams.getDebugWaitingTime();
    }

    @Override
    public Double paperWidthInches() {
        return this.valueToInches(this.printParams.getPageWidth());
    }

    @Override
    public Double paperHeightInches() {
        return this.valueToInches(this.printParams.getPageHeight());
    }

    private double valueToInches(double value) {
        String units = this.printParams.getPageSizeUnits();
        if (units.equals("mm")) {
            return value / 25.4;
        }
        if (units.equals("cm")) {
            return value / 2.54;
        }
        if (units.equals("in")) {
            return value;
        }
        return value;
    }
}

