/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.server.request.processor.gvi;

import crazydev.common.babylon.CdBabylonService;
import crazydev.common.exception.programming.CdProgrammingException;
import crazydev.common.tests.CdTestUtils;
import crazydev.common.utils.CdStringUtils;
import crazydev.iccube.authorization.permissions.common.OlapRoleAuthorizationException;
import crazydev.iccube.authorization.permissions.common.OlapRoleAuthorizationRuntimeException;
import crazydev.iccube.babylon.OlapBabylonService;
import crazydev.iccube.olap.loggers.OlapLoggers;
import crazydev.iccube.pub.utils.ic3CSRFUtils;
import crazydev.iccube.request.log.OlapRequestId;
import crazydev.iccube.request.status.IcCubeRequestStatusManager;
import crazydev.iccube.server.context.IcCubeServerSessionContext;
import crazydev.iccube.server.gvi.GviComponentConfiguration;
import crazydev.iccube.server.gvi.request.common.GviGenericErrorResponse;
import crazydev.iccube.server.gvi.request.common.GviQuery;
import crazydev.iccube.server.gvi.request.common.GviResponse;
import crazydev.iccube.server.gvi.request.common.errors.GviError;
import crazydev.iccube.server.gvi.request.common.errors.GviErrorCode;
import crazydev.iccube.server.gvi.request.parser.GviQueryParserException;
import crazydev.iccube.server.request.executor.IcCubeServerTaskExecutor;
import crazydev.iccube.server.request.processor.common.IcCubeRequestProcessor;
import crazydev.iccube.server.request.request.gvi.IcCubeGviServerRequest;
import crazydev.iccube.server.request.request.gvi.IcCubeGviServerRequestContext;
import crazydev.iccube.server.request.request.gvi.IcCubeGviServerRequestReply;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.Serializable;
import org.jetbrains.annotations.Nullable;

public class IcCubeGviRequestProcessor
extends IcCubeRequestProcessor<GviResponse, IcCubeGviServerRequest, IcCubeGviServerRequestReply, IcCubeGviServerRequestContext> {
    private final boolean withCSRF;

    public IcCubeGviRequestProcessor(@Nullable GviComponentConfiguration configuration, IcCubeServerTaskExecutor taskExecutor, IcCubeRequestStatusManager statusManager) {
        super(taskExecutor, statusManager);
        this.withCSRF = configuration != null && configuration.isWithCSRF();
    }

    private IcCubeGviServerRequestContext setupRequestContext(HttpServletRequest httpRequest, IcCubeGviServerRequest request) {
        IcCubeServerSessionContext sessionContext = IcCubeServerSessionContext.getOrCreateSessionContext(httpRequest);
        return new IcCubeGviServerRequestContext(sessionContext, request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processGviRequest(HttpServletRequest httpRequest, HttpServletResponse httpResponse) throws IOException {
        GviResponse reply;
        IcCubeGviServerRequestContext requestContext;
        IcCubeGviServerRequest request;
        try {
            OlapRequestId requestId = OlapRequestId.getThreadRequestId(null);
            request = new IcCubeGviServerRequest(requestId, httpRequest, httpResponse);
            requestContext = this.setupRequestContext(httpRequest, request);
        }
        catch (GviQueryParserException ex) {
            OlapLoggers.GVI_REQUEST.error((Object)"GVI request : syntax error", (Throwable)((Object)ex));
            GviGenericErrorResponse reply2 = new GviGenericErrorResponse(new GviError(GviErrorCode.UNEXPECTED_ERROR, new Serializable[]{"syntax error : " + ex.getMessage()}));
            ((GviResponse)reply2).writeResponse(httpRequest, httpResponse, this.createEnglishBabylonService());
            return;
        }
        catch (RuntimeException unexpected) {
            OlapLoggers.GVI_REQUEST.error((Object)"GVI request : unexpected setup error", (Throwable)unexpected);
            GviGenericErrorResponse reply3 = new GviGenericErrorResponse(new GviError(GviErrorCode.UNEXPECTED_ERROR, new Serializable[]{unexpected.getMessage()}));
            ((GviResponse)reply3).writeResponse(httpRequest, httpResponse, this.createEnglishBabylonService());
            return;
        }
        if (!this.validateCSRFToken(request)) {
            reply = new GviGenericErrorResponse(new GviError(GviErrorCode.UNEXPECTED_ERROR, new Serializable[]{"CSRF error (please refresh your browser)"}));
            reply.writeResponse(httpRequest, httpResponse, this.createEnglishBabylonService());
            return;
        }
        reply = this.processGviRequest(requestContext, request);
        try {
            reply.writeResponse(httpRequest, httpResponse, requestContext.getBabylonService());
        }
        finally {
            reply.release();
        }
    }

    protected boolean validateCSRFToken(IcCubeGviServerRequest request) {
        if (CdTestUtils.CSRF_TOKEN_VALIDATION_OFF || !this.withCSRF) {
            return true;
        }
        if (request.isWithoutCSRFTokenValidation()) {
            return true;
        }
        String sessionToken = request.getCSRFSessionToken();
        if (CdStringUtils.isNullOrBlank((String)sessionToken)) {
            OlapLoggers.REQUEST.error((Object)("[GVI] CSRF: unexpected missing session token for: " + request.toStringForCSRFError()));
            return false;
        }
        String requestToken = request.getCSRFHeaderToken();
        if (CdStringUtils.isNullOrBlank((String)requestToken)) {
            OlapLoggers.REQUEST.error((Object)("[GVI] CSRF: unexpected missing request token for: " + request.toStringForCSRFError()));
            return false;
        }
        if (!ic3CSRFUtils.equals((String)sessionToken, (String)requestToken)) {
            OlapLoggers.REQUEST.error((Object)("[GVI] CSRF: unexpected request token value [request:" + requestToken + "] [session:" + sessionToken + "] for: " + request.toStringForCSRFError()));
            return false;
        }
        return true;
    }

    public GviResponse processGviRequest(IcCubeGviServerRequestContext requestContext, IcCubeGviServerRequest request) {
        this.onBeforeProcessXyzRequest(requestContext, request);
        try {
            GviResponse reply = (GviResponse)this.processXyzRequest(requestContext, request);
            return reply;
        }
        catch (RuntimeException unexpected) {
            GviResponse reply = this.createUnexpectedUnexpectedResponse(request, unexpected);
            return reply;
        }
    }

    private void onBeforeProcessXyzRequest(IcCubeGviServerRequestContext requestContext, IcCubeGviServerRequest request) {
        try {
            GviQuery query = request.getExistingGviQuery();
            Long timestamp = query.getTimestamp();
            if (timestamp == null) {
                return;
            }
            String windowUid = query.getWindowUid();
            if (windowUid == null) {
                return;
            }
            String widgetUid = query.getWidgetUid();
            if (widgetUid == null) {
                return;
            }
            IcCubeServerSessionContext sessionContext = requestContext.getSessionContext();
            String sessionUUID = sessionContext.getSessionId();
            IcCubeRequestStatusManager requestStatusManager = requestContext.getRequestStatusManager();
            requestStatusManager.autoCancelGviRequests(query.getClientUUID(), sessionUUID, timestamp.longValue(), windowUid, widgetUid);
        }
        catch (RuntimeException unexpected) {
            OlapLoggers.GVI_REQUEST.warn((Object)"unexpected error while cancelling a previous request", (Throwable)unexpected);
        }
    }

    @Override
    protected GviResponse createSuccessResponse(IcCubeGviServerRequestContext requestContext, IcCubeGviServerRequest request, IcCubeGviServerRequestReply reply) {
        GviResponse response = reply.getResponse();
        if (response == null) {
            throw new CdProgrammingException("internal error: reply inconsistency");
        }
        return response;
    }

    @Override
    protected GviResponse createCancelledResponse(IcCubeGviServerRequestContext requestContext, IcCubeGviServerRequest request, boolean onTimeout, @Nullable String extraInfo) {
        GviErrorCode errorCode = !onTimeout ? GviErrorCode.CANCELLED : GviErrorCode.TIMEOUT;
        return new GviGenericErrorResponse(new GviError(errorCode, new Serializable[0]), extraInfo);
    }

    @Override
    protected GviResponse createExceptionResponseEx(IcCubeGviServerRequestContext requestContext, IcCubeGviServerRequest request, Throwable exception) {
        if (exception instanceof OlapRoleAuthorizationRuntimeException) {
            return this.createNotAuthorizedResponse(requestContext, request, (OlapRoleAuthorizationRuntimeException)exception);
        }
        if (exception instanceof OlapRoleAuthorizationException) {
            return this.createNotAuthorizedResponse(requestContext, request, (OlapRoleAuthorizationException)exception);
        }
        if (exception instanceof GviQueryParserException) {
            return this.createParserErrorResponse(requestContext, request, (GviQueryParserException)((Object)exception));
        }
        return this.createUnexpectedUnexpectedResponse(request, exception);
    }

    private GviResponse createNotAuthorizedResponse(IcCubeGviServerRequestContext requestContext, IcCubeGviServerRequest request, OlapRoleAuthorizationRuntimeException exception) {
        OlapLoggers.GVI_REQUEST.error((Object)(request.getLoggerInfo() + " : not authorized"), (Throwable)exception);
        OlapBabylonService babylon = requestContext.getBabylonService();
        return new GviGenericErrorResponse(new GviError(GviErrorCode.ACCESS_NOT_AUTHORIZED, new Serializable[]{exception.getError().asMessage((CdBabylonService)babylon)}));
    }

    private GviResponse createNotAuthorizedResponse(IcCubeGviServerRequestContext requestContext, IcCubeGviServerRequest request, OlapRoleAuthorizationException exception) {
        OlapLoggers.GVI_REQUEST.error((Object)(request.getLoggerInfo() + " : not authorized"), (Throwable)exception);
        OlapBabylonService babylon = requestContext.getBabylonService();
        return new GviGenericErrorResponse(new GviError(GviErrorCode.ACCESS_NOT_AUTHORIZED, new Serializable[]{exception.getError().asMessage((CdBabylonService)babylon)}));
    }

    private GviResponse createParserErrorResponse(IcCubeGviServerRequestContext requestContext, IcCubeGviServerRequest request, GviQueryParserException exception) {
        OlapLoggers.GVI_REQUEST.error((Object)(request.getLoggerInfo() + " : malformed request"), (Throwable)((Object)exception));
        OlapBabylonService babylon = requestContext.getBabylonService();
        return new GviGenericErrorResponse(new GviError(GviErrorCode.PARSE_REQUEST_ERROR, new Serializable[]{exception.getError().asMessage((CdBabylonService)babylon)}));
    }

    private GviResponse createUnexpectedUnexpectedResponse(IcCubeGviServerRequest request, Throwable unexpected) {
        OlapLoggers.GVI_REQUEST.error((Object)(request.getLoggerInfo() + " : unexpected processing error"), unexpected);
        return new GviGenericErrorResponse(new GviError(GviErrorCode.UNEXPECTED_ERROR, new Serializable[]{unexpected.getMessage()}));
    }

    @Override
    protected GviResponse createMissingReplyResponse(IcCubeGviServerRequestContext requestContext, IcCubeGviServerRequest request) {
        return new GviGenericErrorResponse(new GviError(GviErrorCode.UNEXPECTED_ERROR, new Serializable[]{"unexpected missing request reply"}));
    }
}

