/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.server.request.processor.common;

import crazydev.iccube.babylon.OlapBabylonService;
import crazydev.iccube.olap.component.context.OlapEngineRequestContext;
import crazydev.iccube.olap.executor.IOlapExecutor;
import crazydev.iccube.request.log.OlapChattyRequest;
import crazydev.iccube.request.log.OlapRequestId;
import crazydev.iccube.request.log.OlapRequestInfo;
import crazydev.iccube.request.log.OlapRequestTracker;
import crazydev.iccube.request.log.OlapRequestVerbosity;
import crazydev.iccube.request.request.IcCubeRequestCompletionFuture;
import crazydev.iccube.request.request.IcCubeRequestReply;
import crazydev.iccube.request.status.IcCubeRequestStateEx;
import crazydev.iccube.request.status.IcCubeRequestStatusManager;
import crazydev.iccube.server.context.IcCubeServerSessionContext;
import crazydev.iccube.server.request.executor.IcCubeServerTaskExecutor;
import crazydev.iccube.server.request.request.common.IcCubeServerRequest;
import crazydev.iccube.server.request.request.common.IcCubeServerRequestContext;
import crazydev.iccube.server.request.task.IcCubeServerTask;
import crazydev.iccube.ux.common.reply.UxApi;
import crazydev.iccube.ux.processor.UxBabylonService;
import java.util.List;
import java.util.concurrent.ExecutionException;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public abstract class IcCubeRequestProcessor<RESPONSE, REQUEST extends IcCubeServerRequest, REPLY extends IcCubeRequestReply, REQUEST_CONTEXT extends IcCubeServerRequestContext<REQUEST, REPLY>> {
    private final IcCubeServerTaskExecutor taskExecutor;
    private final IcCubeRequestStatusManager statusManager;

    protected IcCubeRequestProcessor(IcCubeServerTaskExecutor taskExecutor, IcCubeRequestStatusManager statusManager) {
        this.statusManager = statusManager;
        this.taskExecutor = taskExecutor;
    }

    public String getPrintJob() {
        return null;
    }

    public OlapBabylonService createEnglishBabylonService() {
        return OlapBabylonService.ENGLISH;
    }

    public UxBabylonService createEnglishBabylonServiceUx(UxApi api) {
        return UxBabylonService.ENGLISH(api);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RESPONSE processXyzRequest(REQUEST_CONTEXT requestContext, REQUEST request) {
        OlapRequestId requestId = request.getRequestId();
        OlapChattyRequest chattyRequest = request.isChattyRequest();
        OlapRequestVerbosity verbosity = request.getVerbosity();
        OlapRequestInfo requestInfo = new OlapRequestInfo(requestId, chattyRequest, verbosity);
        IcCubeServerSessionContext sessionContext = ((IcCubeServerRequestContext)requestContext).getSessionContext();
        String sessionId = sessionContext.getSessionId();
        OlapRequestTracker.onRequestProcessStarted((String)sessionId, (OlapRequestInfo)requestInfo, (String)request.getTrackingInfo());
        try {
            RESPONSE RESPONSE = this.processXyzRequestEx(requestContext, request);
            return RESPONSE;
        }
        finally {
            OlapRequestTracker.onRequestProcessDone((OlapRequestInfo)requestInfo);
        }
    }

    private RESPONSE processXyzRequestEx(REQUEST_CONTEXT requestContext, REQUEST request) {
        IcCubeRequestStateEx completionState = this.processRequest(requestContext, request);
        Object reply = ((IcCubeServerRequestContext)requestContext).getRequestReply();
        Logger logger = ((IcCubeServerRequestContext)requestContext).getLogger();
        if (completionState.state.isCancelled()) {
            reply.release();
            logger.info((Object)"%s : CANCELLED (%s) %s".formatted(request.getLoggerInfo(), request.getClientUUID(), completionState.stateOnTimeout ? "on-timeout" : ""));
            return this.createCancelledResponse(requestContext, request, completionState.stateOnTimeout, completionState.stateExtraInfo);
        }
        Exception exception = reply.getException();
        if (exception != null) {
            reply.release();
            return this.createExceptionResponse(requestContext, request, exception);
        }
        if (reply.hasResponse()) {
            return this.createSuccessResponse(requestContext, request, reply);
        }
        logger.error((Object)(request.getLoggerInfo() + " : unexpected missing request reply"));
        return this.createMissingReplyResponse(requestContext, request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IcCubeRequestStateEx processRequest(REQUEST_CONTEXT requestContext, REQUEST request) {
        IcCubeRequestStateEx completionState;
        block10: {
            IcCubeServerSessionContext sessionContext = ((IcCubeServerRequestContext)requestContext).getSessionContext();
            String sessionUUID = sessionContext.getSessionId();
            OlapEngineRequestContext olapEngineRequestContext = ((IcCubeServerRequestContext)requestContext).getOlapEngineRequestContext();
            String printJob = ((IcCubeServerRequest)((Object)request)).getPrintJobUUID();
            this.statusManager.onRequestReceived(sessionUUID, ((IcCubeServerRequestContext)requestContext).getUserName(), ((IcCubeServerRequestContext)requestContext).getUserTenant(), request, printJob);
            try {
                this.statusManager.onRequestProcessingStarted(request);
                if (!((IcCubeServerRequest)((Object)request)).setupTaskSchedulingInfo(requestContext)) break block10;
                List<IcCubeServerTask> tasks = ((IcCubeServerRequest)((Object)request)).setupTasks(requestContext);
                OlapRequestId requestId = olapEngineRequestContext.getRequestId();
                OlapChattyRequest chattyRequest = request.isChattyRequest();
                OlapRequestVerbosity verbosity = request.getVerbosity();
                OlapRequestInfo requestInfo = new OlapRequestInfo(requestId, chattyRequest, verbosity);
                OlapRequestTracker.onSubmitTasksStarted((OlapRequestInfo)requestInfo, (IOlapExecutor)this.taskExecutor, (int)tasks.size());
                try {
                    IcCubeRequestCompletionFuture completion = this.statusManager.onRequestTasksGenerated(request, tasks);
                    if (this.onRequestBeforeTaskSubmitted(requestContext, request)) {
                        for (int ii = 0; ii < tasks.size(); ++ii) {
                            IcCubeServerTask task = tasks.get(ii);
                            task.submitAndWait(this.taskExecutor);
                        }
                        completion.waitForAllTasksCompletion();
                    }
                }
                finally {
                    OlapRequestTracker.onSubmitTasksDone((OlapRequestInfo)requestInfo, (IOlapExecutor)this.taskExecutor);
                }
            }
            catch (RuntimeException unexpected) {
                Object reply = ((IcCubeServerRequestContext)requestContext).getRequestReply();
                reply.onRequestUnexpectedException(this.statusManager, (Exception)unexpected);
                throw unexpected;
            }
            finally {
                this.onFinallyForSchemaLifeCycleRequestEx(requestContext, request);
                this.onFinallyForSchemaLifeCycleRequest(requestContext, request);
                this.onFinallyForCacheCleanup(requestContext, request);
                IcCubeRequestStateEx completionState2 = this.statusManager.onRequestProcessingCompleted(sessionUUID, request, ((IcCubeServerRequestContext)requestContext).getRequestReplyForCompletionStatus());
            }
        }
        return completionState;
    }

    protected boolean onRequestBeforeTaskSubmitted(REQUEST_CONTEXT requestContext, REQUEST request) {
        return ((IcCubeServerRequest)((Object)request)).onBeforeTaskSubmitted(requestContext);
    }

    protected void onFinallyForSchemaLifeCycleRequest(REQUEST_CONTEXT requestContext, REQUEST request) {
        try {
            ((IcCubeServerRequest)((Object)request)).onFinallyForSchemaLifeCycleRequest(requestContext);
        }
        catch (RuntimeException ex) {
            Logger logger = request.getLogger();
            logger.warn((Object)(request.getLoggerInfo() + " : on-finally error"), (Throwable)ex);
        }
    }

    protected void onFinallyForSchemaLifeCycleRequestEx(REQUEST_CONTEXT requestContext, REQUEST request) {
        try {
            ((IcCubeServerRequest)((Object)request)).onFinallyForSchemaLifeCycleRequestEx(requestContext);
        }
        catch (RuntimeException ex) {
            Logger logger = request.getLogger();
            logger.warn((Object)(request.getLoggerInfo() + " : on-finally-ex error"), (Throwable)ex);
        }
    }

    protected void onFinallyForCacheCleanup(REQUEST_CONTEXT requestContext, REQUEST request) {
        OlapEngineRequestContext engineRequestContext = ((IcCubeServerRequestContext)requestContext).getOlapEngineRequestContext();
        engineRequestContext.onRequestDone();
    }

    protected abstract RESPONSE createSuccessResponse(REQUEST_CONTEXT var1, REQUEST var2, REPLY var3);

    protected abstract RESPONSE createCancelledResponse(REQUEST_CONTEXT var1, REQUEST var2, boolean var3, @Nullable String var4);

    protected RESPONSE createExceptionResponse(REQUEST_CONTEXT requestContext, REQUEST request, Exception exception) {
        if (exception instanceof ExecutionException) {
            Throwable cause = exception.getCause();
            while (cause instanceof ExecutionException) {
                cause = cause.getCause();
            }
            return this.createExceptionResponseEx(requestContext, request, cause);
        }
        return this.createExceptionResponseEx(requestContext, request, exception);
    }

    protected abstract RESPONSE createExceptionResponseEx(REQUEST_CONTEXT var1, REQUEST var2, Throwable var3);

    protected abstract RESPONSE createMissingReplyResponse(REQUEST_CONTEXT var1, REQUEST var2);
}

