/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.server.request.processor.cache;

import crazydev.common.gvi.GviConstants;
import crazydev.iccube.olap.component.context.cache.OlapMdxResultCacheInfoGvi;
import crazydev.iccube.olap.eval.cache.result.cache.OlapResultCacheKey;
import crazydev.iccube.request.log.OlapRequestId;
import crazydev.iccube.request.log.OlapRequestType;
import crazydev.iccube.server.context.IcCubeServerApplicationContext;
import crazydev.iccube.server.context.IcCubeServerSessionContext;
import crazydev.iccube.server.gvi.request.common.GviQuery;
import crazydev.iccube.server.gvi.request.common.GviResponse;
import crazydev.iccube.server.gvi.request.parser.GviQueryParser;
import crazydev.iccube.server.gvi.request.parser.GviQueryParserException;
import crazydev.iccube.server.request.processor.cache.IcCubeMdxResultCacheException;
import crazydev.iccube.server.request.processor.cache.IcCubeMdxResultCacheInfo;
import crazydev.iccube.server.request.processor.gvi.IcCubeGviRequestProcessor;
import crazydev.iccube.server.request.request.gvi.IcCubeGviServerRequest;
import crazydev.iccube.server.request.request.gvi.IcCubeGviServerRequestContext;
import crazydev.iccube.server.request.request.gvi.IcCubeGviServerRequestParams;
import java.util.HashMap;
import java.util.UUID;
import org.jetbrains.annotations.Nullable;

public class IcCubeMdxResultCacheInfoGvi
extends IcCubeMdxResultCacheInfo {
    private final String mdx;
    @Nullable
    private final String initialSelection;
    @Nullable
    private final String cellCountMax;
    @Nullable
    private final String tidyMaxRowCount;
    @Nullable
    private final String timeout;

    public IcCubeMdxResultCacheInfoGvi(OlapMdxResultCacheInfoGvi request) {
        this(request.getCacheKey(), request.getMdx(), request.getInitialSelection(), request.getCellCountMax(), request.getTidyMaxRowCount(), request.getTimeout());
    }

    public IcCubeMdxResultCacheInfoGvi(OlapResultCacheKey cacheKey, String mdx, @Nullable String initialSelection, @Nullable String cellCountMax, @Nullable String tidyMaxRowCount, @Nullable String timeout) {
        super(cacheKey);
        this.mdx = mdx;
        this.initialSelection = initialSelection;
        this.cellCountMax = cellCountMax;
        this.tidyMaxRowCount = tidyMaxRowCount;
        this.timeout = timeout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void unsafeExecute(IcCubeServerApplicationContext applicationContext) {
        IcCubeServerSessionContext sessionContext = this.setupServerSessionContext(applicationContext);
        try {
            IcCubeGviServerRequest request = this.setupServerRequest();
            IcCubeGviServerRequestContext requestContext = new IcCubeGviServerRequestContext(sessionContext, request);
            IcCubeGviRequestProcessor processor = applicationContext.getGviRequestProcessor();
            GviResponse response = processor.processGviRequest(requestContext, request);
            response.release();
        }
        finally {
            sessionContext.onDestroyed();
        }
    }

    private IcCubeGviServerRequestParams setupHttpParams() {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put(GviConstants.Param.action.name(), GviConstants.Action.executeMdx.name());
        params.put(GviConstants.Param.uuid.name(), UUID.randomUUID().toString());
        params.put(GviConstants.Param.schema.name(), this.getSchemaName());
        params.put(GviConstants.Param.mdx.name(), this.mdx);
        if (this.initialSelection != null) {
            params.put(GviConstants.Param.initialSelection.name(), this.initialSelection);
        }
        if (this.cellCountMax != null) {
            params.put(GviConstants.Param.cellCountMax.name(), this.cellCountMax);
        }
        if (this.tidyMaxRowCount != null) {
            params.put(GviConstants.Param.tidyMaxRowCount.name(), this.tidyMaxRowCount);
        }
        if (this.timeout != null) {
            params.put(GviConstants.Param.timeout.name(), this.timeout);
        }
        return new IcCubeGviServerRequestParams(params);
    }

    private IcCubeGviServerRequest setupServerRequest() {
        try {
            OlapRequestId requestId = OlapRequestId.next((OlapRequestType)OlapRequestType.GVI);
            IcCubeGviServerRequestParams httpParams = this.setupHttpParams();
            GviQuery gviQuery = GviQueryParser.parseQuery(httpParams);
            return new IcCubeGviServerRequest(requestId, httpParams, gviQuery);
        }
        catch (GviQueryParserException ex) {
            throw new IcCubeMdxResultCacheException("MDX result cache rebuild : failed to setup the request", (Exception)((Object)ex));
        }
    }
}

