/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.server.request.executor;

import crazydev.iccube.common.executor.IOlapThreadPoolExecutorFutureTaskQueue;
import crazydev.iccube.server.request.executor.IcCubeServerTaskRunnableFuture;
import crazydev.iccube.server.request.task.IcCubeServerTask;
import java.lang.reflect.Array;
import java.util.AbstractQueue;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public class IcCubeServerTaskPriorityQueue
extends AbstractQueue<IcCubeServerTaskRunnableFuture>
implements IOlapThreadPoolExecutorFutureTaskQueue<IcCubeServerTaskRunnableFuture> {
    private final Map<String, SingleSchemaTaskInfo> singleSchemaTaskInfo = new HashMap<String, SingleSchemaTaskInfo>();
    private final Map<String, SingleSchemaTaskInfo> singleSchemaTaskInfoFrozen = new HashMap<String, SingleSchemaTaskInfo>();
    private final AllSchemaTaskInfo allSchemaTaskInfo = new AllSchemaTaskInfo(null);
    private final AllSchemaTaskInfo allSchemaTaskInfoFrozen = new AllSchemaTaskInfo("fake-all-schemas-request-uuid");
    private final NoLockSchemaTaskInfo noLockSchemaTaskInfo = new NoLockSchemaTaskInfo();

    public void onTaskProcessingStarted(IcCubeServerTaskRunnableFuture future) {
        IcCubeServerTask task = future.getTask();
        if (task.isSchemaWriteAccess()) {
            if (!task.isAllSchema()) {
                this.assertNoRunningForSingleSchemaTask(task.getSchema());
                this.assertNoRunningForAllSchemaTask();
            } else {
                this.assertNoRunning();
            }
        } else if (task.isSchemaReadAccess()) {
            if (!task.isAllSchema()) {
                this.assertNoRunningWriteForSingleSchemaTask(task.getSchema());
                this.assertNoRunningWriteForAllSchemaTask();
            } else {
                this.assertNoRunningWrite();
            }
        } else if (!task.isSchemaNoneAccess()) {
            throw new RuntimeException("internal error: schema task queue inconsistency (unexpected started task access mode)");
        }
        task.markAsBusy();
        TaskInfo taskInfo = this.getOrCreateTaskInfo(false, future);
        taskInfo.onSchemaTaskProcessingStarted(future);
    }

    public void onTaskProcessingCompleted(IcCubeServerTaskRunnableFuture future) {
        IcCubeServerTask task = future.getTask();
        if (task.isSchemaWriteAccess()) {
            if (!task.isAllSchema()) {
                this.assertOneRunningWriteForSingleSchemaTask(task.getSchema());
                this.assertNoRunningReadForSingleSchemaTask(task.getSchema());
                this.assertNoRunningForAllSchemaTask();
            } else {
                this.assertOneRunningWriteForAllSchemaTask();
                this.assertNoRunningWriteForSingleTasks();
                this.assertNoRunningRead();
            }
        } else if (task.isSchemaReadAccess()) {
            if (!task.isAllSchema()) {
                this.assertOneAtLeastRunningReadForSingleSchemaTask(task.getSchema());
                this.assertNoRunningWriteForSingleSchemaTask(task.getSchema());
                this.assertNoRunningWriteForAllSchemaTask();
            } else {
                this.assertOneAtLeastRunningReadForAllSchemaTask();
                this.assertNoRunningWrite();
            }
        } else if (!task.isSchemaNoneAccess()) {
            throw new RuntimeException("internal error: schema task queue inconsistency (unexpected completed task access mode)");
        }
        TaskInfo taskInfo = this.getOrCreateTaskInfo(false, future);
        taskInfo.onSchemaTaskProcessingCompleted(future);
        if (taskInfo instanceof SingleSchemaTaskInfo) {
            this.cleanup((SingleSchemaTaskInfo)taskInfo);
        }
    }

    private void assertSchema(String schema) {
        if (schema == null) {
            throw new RuntimeException("internal error: schema task queue inconsistency (missing schema)");
        }
    }

    private void assertNoRunning() {
        this.assertNoRunningRead();
        this.assertNoRunningWrite();
    }

    private void assertNoRunningRead() {
        this.assertNoRunningReadForAllSchemaTask();
        this.assertNoRunningReadForSingleTasks();
    }

    private void assertNoRunningReadForSingleTasks() {
        for (String schema : this.singleSchemaTaskInfo.keySet()) {
            this.assertNoRunningReadForSingleSchemaTask(schema);
        }
    }

    private void assertNoRunningWrite() {
        this.assertNoRunningWriteForAllSchemaTask();
        this.assertNoRunningWriteForSingleTasks();
    }

    private void assertNoRunningWriteForSingleTasks() {
        for (String schema : this.singleSchemaTaskInfo.keySet()) {
            this.assertNoRunningWriteForSingleSchemaTask(schema);
        }
    }

    private void assertNoRunningForSingleSchemaTask(String schema) {
        this.assertNoRunningReadForSingleSchemaTask(schema);
        this.assertNoRunningWriteForSingleSchemaTask(schema);
    }

    private void assertNoRunningReadForSingleSchemaTask(String schema) {
        this.assertSchema(schema);
        SingleSchemaTaskInfo info = this.singleSchemaTaskInfo.get(schema);
        if (info != null && info.runningReadCount != 0) {
            throw new RuntimeException("internal error: schema task queue inconsistency (running read task for schema [" + schema + "])");
        }
    }

    private void assertOneAtLeastRunningReadForSingleSchemaTask(String schema) {
        this.assertSchema(schema);
        SingleSchemaTaskInfo info = this.singleSchemaTaskInfo.get(schema);
        if (info == null || info.runningReadCount < 1) {
            throw new RuntimeException("internal error: schema task queue inconsistency (no running read task for schema [" + schema + "])");
        }
    }

    private void assertNoRunningWriteForSingleSchemaTask(String schema) {
        this.assertSchema(schema);
        SingleSchemaTaskInfo info = this.singleSchemaTaskInfo.get(schema);
        if (info != null && info.runningWriteCount != 0) {
            throw new RuntimeException("internal error: schema task queue inconsistency (running write task for schema [" + schema + "])");
        }
    }

    private void assertOneRunningWriteForSingleSchemaTask(String schema) {
        this.assertSchema(schema);
        SingleSchemaTaskInfo info = this.singleSchemaTaskInfo.get(schema);
        if (info == null) {
            throw new RuntimeException("internal error: schema task queue inconsistency ( [0] running write task for schema [" + schema + "])");
        }
        if (info.runningWriteCount != 1) {
            throw new RuntimeException("internal error: schema task queue inconsistency ( [" + info.runningWriteCount + "] running write task for schema [" + schema + "])");
        }
    }

    private void assertNoRunningForAllSchemaTask() {
        this.assertNoRunningReadForAllSchemaTask();
        this.assertNoRunningWriteForAllSchemaTask();
    }

    private void assertNoRunningReadForAllSchemaTask() {
        if (this.allSchemaTaskInfo.runningReadCount != 0) {
            throw new RuntimeException("internal error: schema task queue inconsistency (running read task for all-schema)");
        }
    }

    private void assertOneAtLeastRunningReadForAllSchemaTask() {
        if (this.allSchemaTaskInfo.runningReadCount <= 0) {
            throw new RuntimeException("internal error: schema task queue inconsistency (no running read task for all-schema)");
        }
    }

    private void assertNoRunningWriteForAllSchemaTask() {
        if (this.allSchemaTaskInfo.runningWriteCount != 0) {
            throw new RuntimeException("internal error: schema task queue inconsistency (running write task for all-schema)");
        }
    }

    private void assertOneRunningWriteForAllSchemaTask() {
        if (this.allSchemaTaskInfo.runningWriteCount != 1) {
            throw new RuntimeException("internal error: schema task queue inconsistency ( [" + this.allSchemaTaskInfo.runningWriteCount + "] write task for all-schema)");
        }
    }

    @Override
    public void clear() {
        this.singleSchemaTaskInfo.clear();
        this.singleSchemaTaskInfoFrozen.clear();
        this.allSchemaTaskInfo.clear();
        this.allSchemaTaskInfoFrozen.clear();
        this.noLockSchemaTaskInfo.clear();
    }

    @Override
    public int size() {
        int size = 0;
        for (TaskInfo taskInfo : this.singleSchemaTaskInfo.values()) {
            size += taskInfo.size();
        }
        size += this.allSchemaTaskInfo.size();
        return size += this.noLockSchemaTaskInfo.size();
    }

    public int __getSynchronizedSchemaCount() {
        return this.singleSchemaTaskInfo.size();
    }

    public void freezeForSchema(Logger logger, String reqUUID, String schema) {
        SingleSchemaTaskInfo schemaTasksFrozen;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("[tasks] freeze queue for [" + schema + "]"));
        }
        if ((schemaTasksFrozen = this.singleSchemaTaskInfoFrozen.get(schema)) != null) {
            throw new RuntimeException("internal error: duplicated freeze for schema [" + schema + "]");
        }
        schemaTasksFrozen = new SingleSchemaTaskInfo(reqUUID, schema);
        this.singleSchemaTaskInfoFrozen.put(schema, schemaTasksFrozen);
        SingleSchemaTaskInfo schemaTasks = this.singleSchemaTaskInfo.get(schema);
        if (schemaTasks != null) {
            schemaTasks.drainToForFreeze(logger, schemaTasksFrozen);
        }
        this.allSchemaTaskInfo.drainToForFreeze(logger, this.allSchemaTaskInfoFrozen);
    }

    public void unfreezeForSchema(Logger logger, String reqUUID, String schema) {
        SingleSchemaTaskInfo schemaTasksFrozen;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("[tasks] unfreeze queue for schema [" + schema + "]"));
        }
        if ((schemaTasksFrozen = this.singleSchemaTaskInfoFrozen.remove(schema)) == null) {
            logger.debug((Object)("[tasks] unfreeze queue for schema [" + schema + "] : nop (unfrozen)"));
            return;
        }
        if (!reqUUID.equals(schemaTasksFrozen.freezingReqUUID)) {
            logger.debug((Object)("[tasks] unfreeze queue for schema [" + schema + "] : nop (request-uuid-mismatch)"));
            return;
        }
        SingleSchemaTaskInfo schemaTasks = this.singleSchemaTaskInfo.get(schema);
        if (schemaTasks == null) {
            schemaTasks = new SingleSchemaTaskInfo(null, schema);
            this.singleSchemaTaskInfo.put(schema, schemaTasks);
        }
        schemaTasksFrozen.drainToForFreeze(logger, schemaTasks);
        this.allSchemaTaskInfoFrozen.drainToForFreeze(logger, this.allSchemaTaskInfo);
    }

    @Override
    public boolean offer(IcCubeServerTaskRunnableFuture e) {
        TaskInfo taskInfo = this.getOrCreateTaskInfo(true, e);
        taskInfo.addLast(e);
        IcCubeServerTask icCubeTask = e.getTask();
        Logger logger = icCubeTask.getLoggers().schemaLock();
        if (taskInfo.isFrozen() && logger.isDebugEnabled()) {
            logger.debug((Object)("[tasks] offered task frozen for schema [" + taskInfo.getSchemaForFreeze() + "]"));
        }
        return true;
    }

    @Override
    public boolean remove(Object o) {
        if (this.allSchemaTaskInfo.remove(o)) {
            return true;
        }
        if (this.noLockSchemaTaskInfo.remove(o)) {
            return true;
        }
        SingleSchemaTaskInfo removed = null;
        for (SingleSchemaTaskInfo taskInfo : this.singleSchemaTaskInfo.values()) {
            if (!taskInfo.remove(o)) continue;
            removed = taskInfo;
            break;
        }
        if (removed != null) {
            this.cleanup(removed);
        }
        return removed != null;
    }

    @Override
    @Nullable
    public IcCubeServerTaskRunnableFuture peek() {
        IcCubeServerTaskRunnableFuture noLockSchemaCandidate;
        IcCubeServerTaskRunnableFuture[] schemaCandidates = new IcCubeServerTaskRunnableFuture[this.singleSchemaTaskInfo.size()];
        int idx = 0;
        for (String schema : this.singleSchemaTaskInfo.keySet()) {
            schemaCandidates[idx++] = this.pollSchemaCandidate(schema);
        }
        IcCubeServerTaskRunnableFuture allSchemaCandidate = this.pollAllSchemaCandidate();
        List<IcCubeServerTaskRunnableFuture> mergedCandidates = this.mergeCandidates(schemaCandidates, allSchemaCandidate, noLockSchemaCandidate = this.pollNoLockSchemaCandidate());
        if (mergedCandidates == null || mergedCandidates.size() == 0) {
            return null;
        }
        IcCubeServerTaskRunnableFuture candidate = this.getEarliest(mergedCandidates);
        return candidate;
    }

    @Override
    @Nullable
    public IcCubeServerTaskRunnableFuture poll() {
        IcCubeServerTaskRunnableFuture task = this.peek();
        if (task == null) {
            return null;
        }
        TaskInfo tasks = this.getExistingTaskInfo(task);
        IcCubeServerTaskRunnableFuture pTask = tasks.poll();
        if (pTask != task) {
            throw new RuntimeException("internal error: schema task queue inconsistent usage (poll vs. peek)");
        }
        if (tasks instanceof SingleSchemaTaskInfo) {
            this.cleanup((SingleSchemaTaskInfo)tasks);
        }
        return task;
    }

    @Nullable
    private IcCubeServerTaskRunnableFuture pollSchemaCandidate(String schema) {
        TaskInfo tasks = this.singleSchemaTaskInfo.get(schema);
        if (tasks == null || tasks.isEmpty()) {
            return null;
        }
        IcCubeServerTaskRunnableFuture candidate = tasks.peek();
        if (candidate == null) {
            return null;
        }
        if (tasks.runningWriteCount > 0 || this.allSchemaTaskInfo.runningWriteCount > 0) {
            return null;
        }
        if (tasks.runningReadCount > 0 || this.allSchemaTaskInfo.runningReadCount > 0) {
            IcCubeServerTask task = candidate.getTask();
            if (!task.isSchemaWriteAccess()) {
                return candidate;
            }
            return null;
        }
        return candidate;
    }

    @Nullable
    private IcCubeServerTaskRunnableFuture pollAllSchemaCandidate() {
        IcCubeServerTaskRunnableFuture candidate = this.allSchemaTaskInfo.peek();
        if (candidate == null) {
            return null;
        }
        if (this.allSchemaTaskInfo.runningWriteCount > 0 || this.isAnySingleSchemaTaskWrite()) {
            return null;
        }
        if (this.allSchemaTaskInfo.runningReadCount > 0 || this.isAnySingleSchemaTaskRead()) {
            IcCubeServerTask task = candidate.getTask();
            if (!task.isSchemaWriteAccess()) {
                return candidate;
            }
            return null;
        }
        return candidate;
    }

    private boolean isAnySingleSchemaTaskWrite() {
        for (SingleSchemaTaskInfo taskInfo : this.singleSchemaTaskInfo.values()) {
            if (taskInfo.runningWriteCount <= 0) continue;
            return true;
        }
        return false;
    }

    private boolean isAnySingleSchemaTaskRead() {
        for (SingleSchemaTaskInfo taskInfo : this.singleSchemaTaskInfo.values()) {
            if (taskInfo.runningReadCount <= 0) continue;
            return true;
        }
        return false;
    }

    private boolean isAnySingleSchemaFrozen() {
        return !this.singleSchemaTaskInfoFrozen.isEmpty();
    }

    @Nullable
    private IcCubeServerTaskRunnableFuture pollNoLockSchemaCandidate() {
        IcCubeServerTaskRunnableFuture candidate = this.noLockSchemaTaskInfo.peek();
        if (candidate == null) {
            return null;
        }
        return candidate;
    }

    @Override
    public Iterator<IcCubeServerTaskRunnableFuture> iterator() {
        throw new RuntimeException("internal error: schema task queue inconsistent usage (iterator)");
    }

    private void cleanup(SingleSchemaTaskInfo info) {
        if (info.isDone() && this.singleSchemaTaskInfo.remove(info.schema) != info) {
            throw new RuntimeException("internal error: schema task queue inconsistent usage (missing info)");
        }
    }

    @Override
    public <T> T[] toArray(T[] a) {
        throw new RuntimeException("internal error: schema task queue inconsistent usage (toArray)");
    }

    public <T> T[] toArray_(T[] a) {
        int size = this.size();
        if (a.length < size) {
            a = (Object[])Array.newInstance(a.getClass().getComponentType(), size);
        }
        int pos = 0;
        for (TaskInfo taskInfo : this.singleSchemaTaskInfo.values()) {
            LinkedList<IcCubeServerTaskRunnableFuture> tasks = taskInfo.tasks;
            for (IcCubeServerTaskRunnableFuture task : tasks) {
                a[pos++] = task;
            }
        }
        for (IcCubeServerTaskRunnableFuture icCubeServerTaskRunnableFuture : this.allSchemaTaskInfo.tasks) {
            a[pos++] = icCubeServerTaskRunnableFuture;
        }
        for (IcCubeServerTaskRunnableFuture icCubeServerTaskRunnableFuture : this.noLockSchemaTaskInfo.tasks) {
            a[pos++] = icCubeServerTaskRunnableFuture;
        }
        return a;
    }

    private TaskInfo getOrCreateTaskInfo(boolean onOffer, IcCubeServerTaskRunnableFuture future) {
        SingleSchemaTaskInfo taskInfo;
        SingleSchemaTaskInfo taskInfoFrozen;
        IcCubeServerTask task = future.getTask();
        if (task.isSchemaNoneAccess()) {
            return this.noLockSchemaTaskInfo;
        }
        if (task.isAllSchema()) {
            if (onOffer && this.isAnySingleSchemaFrozen()) {
                return this.allSchemaTaskInfoFrozen;
            }
            return this.allSchemaTaskInfo;
        }
        String schema = this.getExistingSchema(future);
        if (onOffer && (taskInfoFrozen = this.singleSchemaTaskInfoFrozen.get(schema)) != null) {
            String reqUUID = task.getRequestClientUUID();
            if (!reqUUID.equals(taskInfoFrozen.freezingReqUUID)) {
                return taskInfoFrozen;
            }
            Logger logger = task.getLoggers().schemaLock();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("[tasks] offered task [w:" + task.isSchemaWriteAccess() + "][r:" + task.isSchemaReadAccess() + "][n:" + task.isSchemaNoneAccess() + "] for frozen schema [" + schema + "]"));
            }
        }
        if ((taskInfo = this.singleSchemaTaskInfo.get(schema)) == null) {
            taskInfo = new SingleSchemaTaskInfo(null, schema);
            this.singleSchemaTaskInfo.put(schema, taskInfo);
        }
        return taskInfo;
    }

    private TaskInfo getExistingTaskInfo(IcCubeServerTaskRunnableFuture future) {
        IcCubeServerTask task = future.getTask();
        if (task.isSchemaNoneAccess()) {
            return this.noLockSchemaTaskInfo;
        }
        if (task.isAllSchema()) {
            return this.allSchemaTaskInfo;
        }
        String schema = this.getExistingSchema(future);
        TaskInfo taskInfo = this.singleSchemaTaskInfo.get(schema);
        if (taskInfo == null) {
            throw new RuntimeException("internal error: schema task queue inconsistent usage (missing task info)");
        }
        return taskInfo;
    }

    private String getExistingSchema(IcCubeServerTaskRunnableFuture e) {
        IcCubeServerTask task = e.getTask();
        String schema = task.getSchema();
        if (schema == null) {
            throw new RuntimeException("internal error: schema task queue inconsistent usage (missing schema)");
        }
        return schema;
    }

    @Nullable
    private List<IcCubeServerTaskRunnableFuture> mergeCandidates(IcCubeServerTaskRunnableFuture[] candidates, @Nullable IcCubeServerTaskRunnableFuture extraCandidate1, @Nullable IcCubeServerTaskRunnableFuture extraCandidate2) {
        List<IcCubeServerTaskRunnableFuture> merged = null;
        if (candidates != null) {
            for (int cc = 0; cc < candidates.length; ++cc) {
                merged = this.addCandidateToMergedList(merged, candidates[cc]);
            }
        }
        merged = this.addCandidateToMergedList(merged, extraCandidate1);
        merged = this.addCandidateToMergedList(merged, extraCandidate2);
        return merged;
    }

    @Nullable
    private List<IcCubeServerTaskRunnableFuture> addCandidateToMergedList(@Nullable List<IcCubeServerTaskRunnableFuture> merged, @Nullable IcCubeServerTaskRunnableFuture candidate) {
        if (candidate != null) {
            if (merged == null) {
                merged = new ArrayList<IcCubeServerTaskRunnableFuture>();
            }
            merged.add(candidate);
        }
        return merged;
    }

    private IcCubeServerTaskRunnableFuture getEarliest(List<IcCubeServerTaskRunnableFuture> candidates) {
        Collections.sort(candidates, new Comparator<IcCubeServerTaskRunnableFuture>(this){
            {
                Objects.requireNonNull(this$0);
            }

            @Override
            public int compare(IcCubeServerTaskRunnableFuture o1, IcCubeServerTaskRunnableFuture o2) {
                IcCubeServerTask t1 = o1.getTask();
                IcCubeServerTask t2 = o2.getTask();
                return t1.getRequestStartDate().compareTo(t2.getRequestStartDate());
            }
        });
        return candidates.get(0);
    }

    @Override
    public String toString() {
        return "...";
    }

    static class AllSchemaTaskInfo
    extends TaskInfo<AllSchemaTaskInfo> {
        AllSchemaTaskInfo(@Nullable String freezingReqUUID) {
            super(freezingReqUUID);
        }

        @Override
        String getSchemaForFreeze() {
            return "all-schemas";
        }

        @Override
        void onSchemaTaskProcessingStarted(IcCubeServerTaskRunnableFuture task) {
            IcCubeServerTask icCubeTask = task.getTask();
            Logger logger = icCubeTask.getLoggers().schemaLock();
            if (!icCubeTask.isAllSchema()) {
                throw new RuntimeException("internal error: all-schema task queue inconsistent usage (received a schema task [" + icCubeTask.getSchema() + "])");
            }
            if (icCubeTask.isSchemaWriteAccess()) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("[tasks] [all-schemas] acquire WRITE-LOCK [running-write-count:" + this.runningWriteCount + "]"));
                }
                ++this.runningWriteCount;
            } else {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("[tasks] [all-schemas] acquire READ-LOCK [running-read-count:" + this.runningReadCount + "]"));
                }
                ++this.runningReadCount;
            }
        }

        @Override
        void onSchemaTaskProcessingCompleted(IcCubeServerTaskRunnableFuture task) {
            IcCubeServerTask icCubeTask = task.getTask();
            Logger logger = icCubeTask.getLoggers().schemaLock();
            if (!icCubeTask.isAllSchema()) {
                throw new RuntimeException("internal error: all-schema task queue inconsistent usage (received a schema task [" + icCubeTask.getSchema() + "])");
            }
            if (icCubeTask.isSchemaWriteAccess()) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("[tasks] [all-schemas] release WRITE-LOCK [running-write-count:" + this.runningWriteCount + "]"));
                }
                --this.runningWriteCount;
            } else {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("[tasks] [all-schemas] release READ-LOCK [running-read-count:" + this.runningReadCount + "]"));
                }
                --this.runningReadCount;
            }
        }
    }

    static class NoLockSchemaTaskInfo
    extends TaskInfo<NoLockSchemaTaskInfo> {
        NoLockSchemaTaskInfo() {
            super(null);
        }

        @Override
        String getSchemaForFreeze() {
            return "no-lock";
        }

        @Override
        void onSchemaTaskProcessingStarted(IcCubeServerTaskRunnableFuture task) {
            IcCubeServerTask icCubeTask = task.getTask();
            Logger logger = icCubeTask.getLoggers().schemaLock();
            if (logger.isDebugEnabled()) {
                String info = icCubeTask.isAllSchema() ? "all-schemas" : "schema:" + icCubeTask.getSchema();
                logger.debug((Object)("[tasks] [" + info + "] acquire NO-LOCK [running-no-lock-count:" + this.runningNoLockCount + "]"));
            }
            ++this.runningNoLockCount;
        }

        @Override
        void onSchemaTaskProcessingCompleted(IcCubeServerTaskRunnableFuture task) {
            IcCubeServerTask icCubeTask = task.getTask();
            Logger logger = icCubeTask.getLoggers().schemaLock();
            if (logger.isDebugEnabled()) {
                String info = icCubeTask.isAllSchema() ? "all-schemas" : "schema:" + icCubeTask.getSchema();
                logger.debug((Object)("[tasks] [" + info + "] release NO-LOCK [running-no-lock-count:" + this.runningNoLockCount + "]"));
            }
            --this.runningNoLockCount;
        }
    }

    static abstract class TaskInfo<T extends TaskInfo> {
        @Nullable
        final String freezingReqUUID;
        final LinkedList<IcCubeServerTaskRunnableFuture> tasks = new LinkedList();
        int runningReadCount;
        int runningWriteCount;
        int runningNoLockCount;

        TaskInfo(@Nullable String freezingReqUUID) {
            this.freezingReqUUID = freezingReqUUID;
        }

        void clear() {
            this.tasks.clear();
            this.runningReadCount = 0;
            this.runningWriteCount = 0;
            this.runningNoLockCount = 0;
        }

        boolean isDone() {
            return this.tasks.isEmpty() && this.runningReadCount <= 0 && this.runningWriteCount <= 0 && this.runningNoLockCount <= 0;
        }

        boolean isEmpty() {
            return this.tasks.isEmpty();
        }

        int size() {
            return this.tasks.size();
        }

        boolean isFrozen() {
            return this.freezingReqUUID != null;
        }

        void drainToForFreeze(Logger logger, T to) {
            if (this.tasks.isEmpty()) {
                return;
            }
            int count = 0;
            while (!this.tasks.isEmpty()) {
                ((TaskInfo)to).addLast(this.tasks.pollFirst());
                ++count;
            }
            if (logger.isDebugEnabled()) {
                if (!this.isFrozen()) {
                    logger.debug((Object)("[tasks] parked [" + count + "] active tasks for [" + this.getSchemaForFreeze() + "]"));
                } else {
                    logger.debug((Object)("[tasks] un-parked [" + count + "] active tasks for [" + this.getSchemaForFreeze() + "]"));
                }
            }
        }

        abstract String getSchemaForFreeze();

        @Nullable
        IcCubeServerTaskRunnableFuture peek() {
            return this.tasks.peek();
        }

        @Nullable
        IcCubeServerTaskRunnableFuture poll() {
            return this.tasks.poll();
        }

        void addLast(IcCubeServerTaskRunnableFuture task) {
            this.tasks.addLast(task);
        }

        boolean remove(Object o) {
            return this.tasks.remove(o);
        }

        abstract void onSchemaTaskProcessingStarted(IcCubeServerTaskRunnableFuture var1);

        abstract void onSchemaTaskProcessingCompleted(IcCubeServerTaskRunnableFuture var1);
    }

    static class SingleSchemaTaskInfo
    extends TaskInfo<SingleSchemaTaskInfo> {
        final String schema;

        SingleSchemaTaskInfo(@Nullable String freezingReqUUID, String schema) {
            super(freezingReqUUID);
            this.schema = schema;
        }

        @Override
        String getSchemaForFreeze() {
            return this.schema;
        }

        @Override
        void onSchemaTaskProcessingStarted(IcCubeServerTaskRunnableFuture task) {
            IcCubeServerTask icCubeTask = task.getTask();
            Logger logger = icCubeTask.getLoggers().schemaLock();
            String icCubeTaskSchema = icCubeTask.getSchema();
            if (!this.schema.equals(icCubeTaskSchema)) {
                throw new RuntimeException("internal error: schema [" + this.schema + "] task queue inconsistent usage (received task for schema [" + icCubeTaskSchema + "])");
            }
            if (icCubeTask.isSchemaWriteAccess()) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("[tasks] schema [" + this.schema + "] acquire WRITE-LOCK [running-write-count:" + this.runningWriteCount + "]"));
                }
                ++this.runningWriteCount;
            } else {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("[tasks] schema [" + this.schema + "] acquire READ-LOCK [running-read-count:" + this.runningReadCount + "]"));
                }
                ++this.runningReadCount;
            }
        }

        @Override
        void onSchemaTaskProcessingCompleted(IcCubeServerTaskRunnableFuture task) {
            IcCubeServerTask icCubeTask = task.getTask();
            Logger logger = icCubeTask.getLoggers().schemaLock();
            String icCubeTaskSchema = icCubeTask.getSchema();
            if (!this.schema.equals(icCubeTaskSchema)) {
                throw new RuntimeException("internal error: schema [" + this.schema + "] task queue inconsistent usage (received task for schema [" + icCubeTaskSchema + "])");
            }
            if (icCubeTask.isSchemaWriteAccess()) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("[tasks] schema [" + this.schema + "] release WRITE-LOCK [running-write-count:" + this.runningWriteCount + "]"));
                }
                --this.runningWriteCount;
            } else {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("[tasks] schema [" + this.schema + "] release READ-LOCK [running-read-count:" + this.runningReadCount + "]"));
                }
                --this.runningReadCount;
            }
        }
    }
}

