/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.server.repository.fs;

import crazydev.common.fs.CdVFileSystem;
import crazydev.iccube.authorizationx.flat.definition.docs.OlapRoleFlatDocsProfile;
import crazydev.iccube.fs.OlapAttachment;
import crazydev.iccube.fs.OlapFile;
import crazydev.iccube.fs.OlapPath;
import crazydev.iccube.gwt.server.reporting.model.OlapDocsDoc;
import crazydev.iccube.gwt.server.reporting.model.OlapDocsSharing;
import crazydev.iccube.gwt.server.reporting.repository.OlapDocsMimeTypes;
import crazydev.iccube.olap.loggers.OlapLoggers;
import crazydev.iccube.server.repository.Binary;
import crazydev.iccube.server.repository.NodeMeta;
import crazydev.iccube.server.repository.PathNotFoundException;
import crazydev.iccube.server.repository.RepositoryException;
import crazydev.iccube.server.repository.fs.FileNode;
import crazydev.iccube.server.repository.fs.FileNodeIterator;
import crazydev.iccube.server.repository.fs.FileNodeIteratorEmpty;
import crazydev.iccube.server.repository.fs.FilePathUtils;
import crazydev.iccube.server.repository.fs.FileRepository;
import crazydev.iccube.server.repository.fs.FileSession;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.function.Predicate;
import org.jetbrains.annotations.Nullable;

public class FileRepositoryEmpty
extends FileRepository {
    protected FileRepositoryEmpty(CdVFileSystem vfs, OlapDocsMimeTypes mimeTypes) {
        super(vfs, mimeTypes, false);
        OlapLoggers.DOC_REPOSITORY.info((Object)"[docs] starting the docs (file empty) repository");
        OlapLoggers.DOC_REPOSITORY.info((Object)"[docs] docs (file) repository started");
    }

    @Override
    public boolean isDocs() {
        return false;
    }

    @Override
    public void shutdown() {
    }

    @Override
    public void logConfiguration() {
    }

    @Override
    public OlapPath root() {
        return OlapPath.ROOT;
    }

    @Override
    public FileSession login(String userName, String roleName, boolean readOnly, @Nullable OlapRoleFlatDocsProfile profile) throws RepositoryException {
        return new FileSession(this, readOnly, userName, roleName, profile);
    }

    @Override
    @Nullable
    public OlapAttachment download(FileSession session, File tmpDirectory, OlapPath absPath, List<String> entries) throws IOException, RepositoryException {
        return null;
    }

    @Override
    public boolean isAncestorOf(FileSession session, OlapPath absPath1, OlapPath absPath2) throws RepositoryException {
        return false;
    }

    @Override
    public boolean nodeExists(FileSession session, OlapPath absPath) throws RepositoryException {
        return false;
    }

    @Override
    public FileNode getNode(FileSession session, OlapPath absPath) throws RepositoryException {
        if (absPath.isEmpty()) {
            OlapFile file = this.fs.create(FilePathUtils.toFilePath(absPath));
            return new FileNode(session, file);
        }
        throw new PathNotFoundException(absPath.toErrorPath());
    }

    @Override
    public void delete(FileSession session, OlapPath absPath) throws RepositoryException {
    }

    @Override
    public void move(FileSession session, OlapPath srcAbsPath, OlapPath destAbsPath) throws RepositoryException {
    }

    @Override
    public void copy(FileSession session, OlapPath srcAbsPath, OlapPath destAbsPath) throws RepositoryException {
    }

    @Override
    @Nullable
    public FileNode getParentX(FileSession session, FileNode node) throws RepositoryException {
        throw new PathNotFoundException("No parent for [" + String.valueOf(node.getPath()) + "]");
    }

    @Override
    public boolean isSame(FileSession session, FileNode node, FileNode other) throws RepositoryException {
        return false;
    }

    @Override
    public boolean isChildOf(FileSession session, FileNode node, FileNode other) throws RepositoryException {
        return false;
    }

    @Override
    public void deleteNode(FileSession session, FileNode node, OlapPath relPath) throws RepositoryException {
    }

    @Override
    public FileNodeIterator getChildNodes(FileSession session, FileNode node) throws RepositoryException {
        return new FileNodeIteratorEmpty();
    }

    @Override
    public FileNode addDirectory(FileSession session, FileNode node, OlapPath name) throws RepositoryException {
        throw new RepositoryException("Could not add the directory [" + String.valueOf(node.getPath()) + "] [" + String.valueOf(name) + "]");
    }

    @Override
    public FileNode addFile(FileSession session, FileNode node, OlapPath name, boolean applyInheritedPermissions, InputStream fileContent) throws RepositoryException {
        throw new RepositoryException("Could not add the file [" + String.valueOf(node.getPath()) + "]");
    }

    @Override
    public NodeMeta getMeta(FileSession session, FileNode node) throws RepositoryException {
        throw new RepositoryException("Could not retrieve meta-information for [" + String.valueOf(node.getPath()) + "]");
    }

    @Override
    public void updatePermissions(FileSession session, FileNode node, List<OlapDocsSharing> sharings) throws RepositoryException {
        throw new RepositoryException("Could not update permissions for [" + String.valueOf(node.getPath()) + "]");
    }

    @Override
    public void updatePermissions(FileSession session, FileNode node, boolean applyInheritedPermissions, List<OlapDocsSharing> sharings) throws RepositoryException {
        throw new RepositoryException("Could not update permissions for [" + String.valueOf(node.getPath()) + "]");
    }

    @Override
    public void updateDocContent(FileSession session, FileNode node, InputStream fileContent) throws RepositoryException {
        throw new RepositoryException("Could not update the file [" + String.valueOf(node.getPath()) + "]");
    }

    @Override
    public void getDocContent(FileSession session, FileNode node, OlapDocsDoc doc, boolean withFileData) throws RepositoryException {
        throw new PathNotFoundException(node.getPath().toErrorPath());
    }

    @Override
    public Binary getDocContent(FileSession session, FileNode node) throws RepositoryException {
        throw new PathNotFoundException(node.getPath().toErrorPath());
    }

    @Override
    public void installWebDashboards(FileSession session, OlapPath app, OlapPath backups, File zip, Predicate<String> filter, boolean backup) throws RepositoryException {
    }

    @Override
    public void installWebDashboardsFromBackup(FileSession session, OlapPath app, OlapPath backups, String timestamp) throws RepositoryException {
    }
}

