/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.server.repository.fs;

import crazydev.common.utils.CdPathEscapeUtils;
import crazydev.common.utils.CdStringUtils;
import crazydev.iccube.fs.OlapPath;
import crazydev.iccube.fs.OlapPathEntry;
import java.util.ArrayList;
import java.util.List;

public abstract class FilePathUtils {
    private FilePathUtils() {
    }

    public static OlapPathEntry createFromFileName(String name) {
        String name_ = CdPathEscapeUtils.unescapeFileName((String)name);
        return OlapPathEntry.create((String)name_);
    }

    public static String toFileName(OlapPathEntry path) {
        String name = path.getName();
        String name_ = CdPathEscapeUtils.escapeFileName((String)name);
        return name_;
    }

    public static OlapPath createFromFilePath(String path) {
        if (CdStringUtils.isNullOrBlank((String)path)) {
            return OlapPath.ROOT;
        }
        if (path.contains("\\")) {
            path = path.replace("\\", "/");
        }
        if (path.equals("/")) {
            return OlapPath.ROOT;
        }
        String[] parts = path.split("/");
        ArrayList<OlapPathEntry> entries = new ArrayList<OlapPathEntry>();
        for (int ii = 0; ii < parts.length; ++ii) {
            String part = parts[ii];
            if (CdStringUtils.isNullOrBlank((String)part)) continue;
            OlapPathEntry partF = FilePathUtils.createFromFileName(part);
            entries.add(partF);
        }
        return OlapPath.create(entries);
    }

    public static String toFilePath(OlapPath path) {
        List entries = path.getEntries();
        if (entries.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (int ii = 0; ii < entries.size(); ++ii) {
            OlapPathEntry entry = (OlapPathEntry)entries.get(ii);
            String entryF = FilePathUtils.toFileName(entry);
            if (CdStringUtils.isNullOrBlank((String)entryF)) continue;
            if (ii > 0) {
                sb.append("/");
            }
            sb.append(entryF);
        }
        return sb.toString();
    }
}

