/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.server.repository;

import crazydev.iccube.authorizationx.flat.definition.docs.OlapRoleFlatDocsProfile;
import crazydev.iccube.fs.OlapAttachment;
import crazydev.iccube.fs.OlapPath;
import crazydev.iccube.gwt.server.reporting.model.OlapDocsPermissions;
import crazydev.iccube.server.repository.Node;
import crazydev.iccube.server.repository.Repository;
import crazydev.iccube.server.repository.RepositoryException;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.jetbrains.annotations.Nullable;

public abstract class Session<NODE extends Node> {
    protected final Repository repository;
    protected final boolean readOnly;
    private final String requestUser;
    private final String requestUserRole;
    @Nullable
    private final OlapRoleFlatDocsProfile profile;

    protected Session(Repository repository, boolean readOnly, String requestUser, String requestUserRole, @Nullable OlapRoleFlatDocsProfile profile) {
        this.repository = repository;
        this.readOnly = readOnly;
        this.requestUser = requestUser;
        this.requestUserRole = requestUserRole;
        this.profile = profile;
    }

    public Repository repository() {
        return this.repository;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public String getRequestUser() {
        return this.requestUser;
    }

    public String getRequestUserRole() {
        return this.requestUserRole;
    }

    @Nullable
    public OlapRoleFlatDocsProfile getDocsProfile() {
        return this.profile;
    }

    public abstract void logout();

    public void commit() throws RepositoryException {
        this.assertReadWriteConnection("commit");
        this.doCommit();
    }

    protected abstract void doCommit() throws RepositoryException;

    public File createTmpFileForUpload(File tmpDirectory, String extension) throws IOException {
        return this.repository.createTmpFileForUpload(tmpDirectory, extension);
    }

    @Nullable
    public OlapAttachment download(File tmpDirectory, OlapPath absPath, List<String> entries) throws IOException, RepositoryException {
        return this.repository.download(this, tmpDirectory, absPath, entries);
    }

    public OlapDocsPermissions getPermissions(OlapPath absPath) throws RepositoryException {
        return this.repository.getPermissions(this, absPath);
    }

    public boolean isAncestorOf(OlapPath path1, OlapPath path2) throws RepositoryException {
        return this.repository.isAncestorOf(this, path1, path2);
    }

    public boolean nodeExists(OlapPath absPath) throws RepositoryException {
        return this.repository.nodeExists(this, absPath);
    }

    public NODE getNode(OlapPath absPath) throws RepositoryException {
        return this.repository.getNode(this, absPath);
    }

    public void removeItem(OlapPath absPath) throws RepositoryException {
        this.assertReadWriteConnection("remove");
        this.repository.delete(this, absPath);
    }

    public void move(OlapPath srcAbsPath, OlapPath destAbsPath) throws RepositoryException {
        this.assertReadWriteConnection("move");
        this.repository.move(this, srcAbsPath, destAbsPath);
    }

    public void copy(OlapPath srcAbsPath, OlapPath destAbsPath) throws RepositoryException {
        this.assertReadWriteConnection("copy");
        this.repository.copy(this, srcAbsPath, destAbsPath);
    }

    public void forEachNode(Node root, Consumer<Node> consumer) throws RepositoryException {
        this.repository.forEachNode(this, root, consumer);
    }

    public String getAllPermissions() throws RepositoryException {
        return this.repository.getAllPermissions(this);
    }

    private void assertReadWriteConnection(String operation) {
        if (this.readOnly) {
            throw new RuntimeException("internal error: read-only connection (" + operation + ")");
        }
    }

    public void installWebDashboards(OlapPath app, OlapPath backups, File zip, Predicate<String> filter, boolean backup) throws RepositoryException {
        this.repository.installWebDashboards(this, app, backups, zip, filter, backup);
    }

    public void installWebDashboardsFromBackup(OlapPath app, OlapPath backups, String timestamp) throws RepositoryException {
        this.repository.installWebDashboardsFromBackup(this, app, backups, timestamp);
    }
}

