/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.server.repository;

import crazydev.common.utils.CdStringUtils;
import crazydev.iccube.authorizationx.flat.definition.docs.OlapRoleFlatDocsProfile;
import crazydev.iccube.fs.OlapAttachment;
import crazydev.iccube.fs.OlapPath;
import crazydev.iccube.fs.OlapPathEntry;
import crazydev.iccube.gwt.server.reporting.model.OlapDocsDoc;
import crazydev.iccube.gwt.server.reporting.model.OlapDocsPermissions;
import crazydev.iccube.gwt.server.reporting.model.OlapDocsSharing;
import crazydev.iccube.gwt.server.reporting.repository.OlapDocsMimeTypes;
import crazydev.iccube.gwt.server.reporting.repository.common.OlapDocsHelper;
import crazydev.iccube.olap.loggers.OlapLoggers;
import crazydev.iccube.request.request.IcCubeRequest;
import crazydev.iccube.server.repository.Binary;
import crazydev.iccube.server.repository.Node;
import crazydev.iccube.server.repository.NodeIterator;
import crazydev.iccube.server.repository.NodeMeta;
import crazydev.iccube.server.repository.PathNotFoundException;
import crazydev.iccube.server.repository.RepositoryException;
import crazydev.iccube.server.repository.Session;
import crazydev.iccube.server.repository.fs.FileRepository;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.IOUtils;
import org.jetbrains.annotations.Nullable;

public abstract class Repository<SESSION extends Session, NODE extends Node> {
    public static final OlapPath FILE_REPOSITORY_LOCK_NAME = OlapPath.create((OlapPathEntry[])new OlapPathEntry[]{OlapPathEntry.create((String)".lock")});
    protected final OlapDocsMimeTypes mimeTypes;

    protected Repository(OlapDocsMimeTypes mimeTypes) {
        this.mimeTypes = mimeTypes;
    }

    public abstract boolean isDocs();

    public abstract void shutdown();

    public abstract void logConfiguration();

    public abstract OlapPath root();

    public abstract SESSION login(String var1, String var2, boolean var3, @Nullable OlapRoleFlatDocsProfile var4) throws RepositoryException;

    @Nullable
    public OlapAttachment download(SESSION session, File tmpDirectory, OlapPath absPath, List<String> entries) throws RepositoryException, IOException {
        NODE rootNode = this.getNode(session, absPath);
        ArrayList<Node> nodes = new ArrayList<Node>();
        for (String entry : entries) {
            Node node = ((Node)rootNode).getNode(OlapPathEntry.create((String)entry));
            nodes.add(node);
        }
        return this.downloadNodes(session, tmpDirectory, absPath, nodes);
    }

    private OlapAttachment downloadNodes(SESSION session, File tmpDirectory, OlapPath absPath, List<NODE> nodes) throws RepositoryException, IOException {
        if (nodes.size() == 1) {
            Node singleNode = (Node)nodes.get(0);
            if (!singleNode.isDirectory()) {
                File out = this.createTmpFileForDownload(tmpDirectory, singleNode.getFileExtension());
                String attachmentName = singleNode.getName().getName();
                this.downloadSingleFileNode(session, absPath, singleNode, out);
                return new OlapAttachment(out, attachmentName);
            }
            File out = this.createTmpFileForDownload(tmpDirectory, "zip");
            String attachmentName = singleNode.getName().getName() + ".zip";
            this.downloadSingleDirectoryNode(session, absPath, singleNode, out);
            return new OlapAttachment(out, attachmentName);
        }
        OlapPathEntry parentName = absPath.getName();
        File out = this.createTmpFileForDownload(tmpDirectory, "zip");
        String attachmentName = CdStringUtils.isNotNullAndNotBlank((String)parentName.getName()) ? parentName.getName() + ".zip" : "ic3docs.zip";
        this.downloadMultiNodes(session, absPath, nodes, out);
        return new OlapAttachment(out, attachmentName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void downloadSingleFileNode(SESSION session, OlapPath absPath, NODE node, File out) throws RepositoryException, IOException {
        if (OlapLoggers.DOC_REPOSITORY.isDebugEnabled()) {
            OlapLoggers.DOC_REPOSITORY.debug((Object)("[docs] >> " + String.valueOf(((Node)node).getPath())));
        }
        try {
            Binary content = this.getDocContent(session, node);
            try (InputStream in = content.createInputStream();
                 BufferedOutputStream bOut = new BufferedOutputStream(new FileOutputStream(out));){
                IOUtils.copy((InputStream)in, (OutputStream)bOut);
            }
            finally {
                content.dispose();
            }
        }
        catch (RepositoryException | IOException | RuntimeException ex) {
            OlapLoggers.DOC_REPOSITORY.error((Object)("[docs] could not download the file [" + String.valueOf(((Node)node).getPath()) + "]"), (Throwable)ex);
            throw ex;
        }
    }

    private void downloadSingleDirectoryNode(SESSION session, OlapPath absPath, NODE node, File out) throws RepositoryException, IOException {
        this.downloadMultiNodes(session, absPath, Collections.singletonList(node), out);
    }

    private void downloadMultiNodes(SESSION session, OlapPath absPath, List<NODE> nodes, File out) throws RepositoryException, IOException {
        try (FileOutputStream fOut = new FileOutputStream(out);
             BufferedOutputStream bOut = new BufferedOutputStream(fOut);
             ZipOutputStream zOut = new ZipOutputStream(bOut);){
            for (Node node : nodes) {
                this.exportNode(session, node, out, zOut);
            }
        }
    }

    protected abstract File createTmpFileForDownload(File var1, String var2) throws IOException;

    protected abstract File createTmpFileForUpload(File var1, String var2) throws IOException;

    protected void exportNode(SESSION session, NODE node, File zip, ZipOutputStream zOut) throws RepositoryException, IOException {
        OlapPath parentNodePath;
        Node parentNode = ((Node)node).getParentX();
        OlapPath prefix = parentNodePath = parentNode != null ? parentNode.getPath() : OlapPath.ROOT;
        this.exportNode(session, zip, zOut, prefix, parentNodePath, node);
    }

    protected void exportNode(SESSION session, File zip, ZipOutputStream out, OlapPath prefix, OlapPath parentNodePath, NODE node) throws RepositoryException, IOException {
        if (OlapLoggers.DOC_REPOSITORY.isDebugEnabled()) {
            OlapLoggers.DOC_REPOSITORY.debug((Object)("[docs] >> " + String.valueOf(((Node)node).getPath())));
        }
        if (((Node)node).isDirectory()) {
            this.exportDirectory(session, zip, out, prefix, parentNodePath, (Node)node);
        } else {
            this.exportFile(session, zip, out, prefix, parentNodePath, node);
        }
    }

    private void exportDirectory(SESSION session, File zip, ZipOutputStream out, OlapPath prefix, OlapPath parentNodePath, Node node) throws RepositoryException, IOException {
        try {
            this.unsafeExportDirectory(session, zip, out, prefix, parentNodePath, node);
        }
        catch (RepositoryException | IOException | RuntimeException ex) {
            OlapLoggers.DOC_REPOSITORY.error((Object)("[docs] could not export successfully the directory [" + String.valueOf(node.getPath()) + "]"), (Throwable)ex);
            throw ex;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unsafeExportDirectory(SESSION session, File zip, ZipOutputStream out, OlapPath prefix, OlapPath parentNodePath, Node node) throws RepositoryException, IOException {
        IcCubeRequest.assertNotCancelled((String)"docs-export");
        OlapPath directoryPath = node.getPath();
        ZipEntry dirEntry = Repository.zipEntry(zip, true, prefix, directoryPath);
        out.putNextEntry(dirEntry);
        out.closeEntry();
        NodeMeta meta = node.getMeta();
        if (!meta.isEmpty()) {
            OlapPath metaPath = directoryPath.append(new OlapPathEntry[]{FileRepository.META_FILE_EXTENSION});
            out.putNextEntry(Repository.zipEntry(zip, false, prefix, metaPath));
            try {
                meta.save(out, false);
            }
            finally {
                out.closeEntry();
            }
        }
        try (NodeIterator children = node.getNodes();){
            while (children.hasNext()) {
                Object child = children.nextNode();
                this.exportNode(session, zip, out, prefix, directoryPath, child);
            }
        }
    }

    private void exportFile(SESSION session, File zip, ZipOutputStream out, OlapPath prefix, OlapPath parentNodePath, NODE node) throws RepositoryException, IOException {
        try {
            this.unsafeExportFile(session, zip, out, prefix, parentNodePath, node);
        }
        catch (RepositoryException | IOException | RuntimeException ex) {
            OlapLoggers.DOC_REPOSITORY.error((Object)("[docs] could not export successfully the file [" + String.valueOf(((Node)node).getPath()) + "]"), (Throwable)ex);
            throw ex;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unsafeExportFile(SESSION session, File zip, ZipOutputStream out, OlapPath prefix, OlapPath parentNodePath, NODE node) throws RepositoryException, IOException {
        if (this.isDocs() && ((Node)node).getPath().endsWith(FileRepository.META_FILE_EXTENSION.toPath())) {
            return;
        }
        if (this.isDocs() && ((Node)node).getPath().equals((Object)FILE_REPOSITORY_LOCK_NAME)) {
            return;
        }
        Binary content = this.getDocContent(session, node);
        try (InputStream in = content.createInputStream();){
            OlapPath defPath = ((Node)node).getPath();
            out.putNextEntry(Repository.zipEntry(zip, false, prefix, defPath));
            try {
                IOUtils.copy((InputStream)in, (OutputStream)out);
            }
            finally {
                out.closeEntry();
            }
        }
        finally {
            content.dispose();
        }
        NodeMeta meta = ((Node)node).getMeta();
        if (!meta.isEmpty()) {
            OlapPath metaPath = parentNodePath.append(new OlapPathEntry[]{OlapPathEntry.create((String)(((Node)node).getName().getName() + String.valueOf(FileRepository.META_FILE_EXTENSION)))});
            out.putNextEntry(Repository.zipEntry(zip, false, prefix, metaPath));
            try {
                meta.save(out, false);
            }
            finally {
                out.closeEntry();
            }
        }
    }

    private static ZipEntry zipEntry(File zip, boolean isDirectory, OlapPath prefix, OlapPath path_) {
        path_ = path_.relativeTo(prefix);
        String path = path_.toZipPath(isDirectory);
        ZipEntry entry = new ZipEntry(path);
        return entry;
    }

    public abstract boolean isAncestorOf(SESSION var1, OlapPath var2, OlapPath var3) throws RepositoryException;

    public abstract boolean nodeExists(SESSION var1, OlapPath var2) throws RepositoryException;

    public abstract NODE getNode(SESSION var1, OlapPath var2) throws RepositoryException;

    public abstract void delete(SESSION var1, OlapPath var2) throws RepositoryException;

    public abstract void move(SESSION var1, OlapPath var2, OlapPath var3) throws RepositoryException;

    public abstract void copy(SESSION var1, OlapPath var2, OlapPath var3) throws RepositoryException;

    public NODE getParent(SESSION session, NODE node) throws RepositoryException {
        NODE parent = this.getParentX(session, node);
        if (parent == null) {
            throw new PathNotFoundException("No parent for [" + String.valueOf(((Node)node).getPath()) + "]");
        }
        return parent;
    }

    @Nullable
    public abstract NODE getParentX(SESSION var1, NODE var2) throws RepositoryException;

    public abstract boolean isSame(SESSION var1, NODE var2, NODE var3) throws RepositoryException;

    public abstract boolean isChildOf(SESSION var1, NODE var2, NODE var3) throws RepositoryException;

    public abstract void deleteNode(SESSION var1, NODE var2, OlapPath var3) throws RepositoryException;

    public boolean hasNode(SESSION session, NODE node, OlapPath relPath) throws RepositoryException {
        OlapPath absPath = ((Node)node).getPath().append(relPath);
        return this.nodeExists(session, absPath);
    }

    public NODE getNode(SESSION session, NODE node, OlapPath relPath) throws RepositoryException {
        OlapPath absPath = ((Node)node).getPath().append(relPath);
        return this.getNode(session, absPath);
    }

    public abstract NodeIterator getChildNodes(SESSION var1, NODE var2) throws RepositoryException;

    public NODE addDirectories(SESSION session, NODE node, boolean directory, OlapPath relPath) throws RepositoryException {
        List parts = relPath.getEntries();
        Object dir = node;
        for (int ii = 0; ii < parts.size(); ++ii) {
            OlapPathEntry part = (OlapPathEntry)parts.get(ii);
            if (!directory && ii == parts.size() - 1) break;
            dir = ((Node)dir).hasNode(part) ? ((Node)dir).getNode(part) : this.addDirectory(session, dir, OlapPath.create((OlapPathEntry[])new OlapPathEntry[]{part}));
        }
        return dir;
    }

    public abstract NODE addDirectory(SESSION var1, NODE var2, OlapPath var3) throws RepositoryException;

    public abstract NODE addFile(SESSION var1, NODE var2, OlapPath var3, boolean var4, InputStream var5) throws RepositoryException;

    public void forEachNode(SESSION session, NODE root, Consumer<NODE> consumer) throws RepositoryException {
    }

    public String getAllPermissions(SESSION session) throws RepositoryException {
        return "";
    }

    @Nullable
    public OlapDocsPermissions getPermissions(SESSION session, OlapPath absPath) throws RepositoryException {
        NODE node;
        boolean isEverybodyEnabled = true;
        for (Object parentNode = node = this.getNode(session, absPath); parentNode != null; parentNode = ((Node)parentNode).getParentX()) {
            if (!((Node)parentNode).getPrimaryNodeType().isNodeType("report:Label")) continue;
            NodeMeta meta = this.getMeta(session, parentNode);
            List<OlapDocsSharing> sharings = meta.getPermissions();
            OlapDocsSharing everybodySharing = null;
            boolean overridingEverybody = false;
            for (OlapDocsSharing sharing : sharings) {
                boolean isEverybody = OlapDocsHelper.isSharingEverybody(sharing);
                if (isEverybody) {
                    if (!isEverybodyEnabled) continue;
                    everybodySharing = sharing;
                    continue;
                }
                if (((Session)session).getRequestUserRole().equals(sharing.getRoleName())) {
                    return sharing.getPermissions();
                }
                overridingEverybody = true;
            }
            if (everybodySharing != null) {
                return everybodySharing.getPermissions();
            }
            if (!overridingEverybody) continue;
            isEverybodyEnabled = false;
        }
        return null;
    }

    public abstract NodeMeta getMeta(SESSION var1, NODE var2) throws RepositoryException;

    public abstract void updatePermissions(SESSION var1, NODE var2, List<OlapDocsSharing> var3) throws RepositoryException;

    public abstract void updatePermissions(SESSION var1, NODE var2, boolean var3, List<OlapDocsSharing> var4) throws RepositoryException;

    public void updatePermissionsX(SESSION session, NODE node, @Nullable Boolean applyInheritedPermissions, @Nullable List<OlapDocsSharing> sharings) throws RepositoryException {
        if (applyInheritedPermissions == null) {
            applyInheritedPermissions = true;
        }
        if (sharings == null) {
            sharings = new ArrayList<OlapDocsSharing>();
        }
        this.updatePermissions(session, node, applyInheritedPermissions, sharings);
    }

    public abstract void updateDocContent(SESSION var1, NODE var2, InputStream var3) throws RepositoryException;

    public abstract void getDocContent(SESSION var1, NODE var2, OlapDocsDoc var3, boolean var4) throws RepositoryException;

    public abstract Binary getDocContent(SESSION var1, NODE var2) throws RepositoryException;

    public abstract void installWebDashboards(SESSION var1, OlapPath var2, OlapPath var3, File var4, Predicate<String> var5, boolean var6) throws RepositoryException;

    public abstract void installWebDashboardsFromBackup(SESSION var1, OlapPath var2, OlapPath var3, String var4) throws RepositoryException;
}

