/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.server.repository;

import crazydev.iccube.gwt.server.reporting.model.OlapDocsPermissions;
import crazydev.iccube.gwt.server.reporting.model.OlapDocsSharing;
import crazydev.iccube.server.repository.fs.FileMeta;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;

public class NodeMeta {
    protected boolean applyInheritedPermissions = true;
    protected List<OlapDocsSharing> permissions = new ArrayList<OlapDocsSharing>();

    public NodeMeta() {
    }

    public NodeMeta(boolean applyInheritedPermissions, List<OlapDocsSharing> permissions) {
        this.applyInheritedPermissions = applyInheritedPermissions;
        this.permissions = permissions;
    }

    public boolean isEmpty() {
        return this.applyInheritedPermissions && this.permissions.isEmpty();
    }

    public boolean isApplyInheritedPermissions() {
        return this.applyInheritedPermissions;
    }

    public boolean hasPermissions() {
        return this.permissions != null && !this.permissions.isEmpty();
    }

    public List<OlapDocsSharing> getPermissions() {
        return this.permissions;
    }

    public void dumpForGetAllPermissions(StringBuilder sb, String scope, String lineSeparator) {
        if (!this.isEmpty()) {
            sb.append(lineSeparator);
            sb.append(":").append(scope).append(lineSeparator);
            if (!this.applyInheritedPermissions) {
                sb.append("  - inherit").append(lineSeparator);
            }
            for (OlapDocsSharing permission : this.permissions) {
                sb.append("  + [").append(permission.getRoleName()).append("]").append(" ").append(permission.getPermissions().name()).append(lineSeparator);
            }
        }
    }

    public void save(OutputStream out, boolean close) throws IOException {
        if (this.isEmpty()) {
            if (close) {
                out.close();
            }
            return;
        }
        OutputStreamWriter oWriter = new OutputStreamWriter(out, StandardCharsets.UTF_8);
        BufferedWriter writer = new BufferedWriter(oWriter);
        writer.write("apply-inherited-permissions:" + this.applyInheritedPermissions);
        writer.newLine();
        writer.write("permissions-count:" + this.permissions.size());
        writer.newLine();
        for (OlapDocsSharing permission : this.permissions) {
            writer.write("permission-role:" + permission.getRoleName());
            writer.newLine();
            writer.write("permission-name:" + permission.getPermissions().name());
            writer.newLine();
        }
        writer.flush();
        if (close) {
            writer.close();
        }
    }

    public static FileMeta restore(List<String> lines) throws IOException {
        if (lines.get(0).startsWith("caption:")) {
            return NodeMeta.restoreWithCaption(lines);
        }
        FileMeta meta = new FileMeta();
        meta.applyInheritedPermissions = Boolean.valueOf(NodeMeta.restore(lines, 0));
        meta.permissions = new ArrayList();
        int count = Integer.valueOf(NodeMeta.restore(lines, 1));
        int line = 2;
        for (int ii = 0; ii < count; ++ii) {
            String role = NodeMeta.restore(lines, line++);
            OlapDocsPermissions perms = OlapDocsPermissions.valueOf(NodeMeta.restore(lines, line++));
            meta.permissions.add(new OlapDocsSharing(role, perms));
        }
        return meta;
    }

    public static FileMeta restoreWithCaption(List<String> lines) throws IOException {
        FileMeta meta = new FileMeta();
        NodeMeta.restore(lines, 0);
        meta.applyInheritedPermissions = Boolean.valueOf(NodeMeta.restore(lines, 1));
        meta.permissions = new ArrayList();
        int count = Integer.valueOf(NodeMeta.restore(lines, 2));
        int line = 3;
        for (int ii = 0; ii < count; ++ii) {
            String role = NodeMeta.restore(lines, line++);
            OlapDocsPermissions perms = OlapDocsPermissions.valueOf(NodeMeta.restore(lines, line++));
            meta.permissions.add(new OlapDocsSharing(role, perms));
        }
        return meta;
    }

    private static String restore(List<String> lines, int pos) {
        String value = "";
        if (pos < lines.size()) {
            value = lines.get(pos);
            value = value.trim();
            value = value.substring(value.indexOf(":") + 1);
        }
        return value;
    }
}

