/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.server.repository;

import crazydev.iccube.fs.OlapPath;
import crazydev.iccube.fs.OlapPathEntry;
import crazydev.iccube.gwt.server.reporting.model.OlapDocsDoc;
import crazydev.iccube.gwt.server.reporting.model.OlapDocsSharing;
import crazydev.iccube.gwt.server.reporting.repository.OlapDocsRepository;
import crazydev.iccube.server.repository.NodeIterator;
import crazydev.iccube.server.repository.NodeMeta;
import crazydev.iccube.server.repository.NodeType;
import crazydev.iccube.server.repository.RepositoryException;
import crazydev.iccube.server.repository.Session;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.Date;
import java.util.List;
import org.apache.commons.io.FilenameUtils;
import org.jetbrains.annotations.Nullable;

public abstract class Node<SESSION extends Session> {
    protected final SESSION session;
    protected final boolean isDirectory;

    protected Node(SESSION session, boolean isDirectory) {
        this.session = session;
        this.isDirectory = isDirectory;
    }

    public SESSION session() {
        return this.session;
    }

    public NodeType getPrimaryNodeType() throws RepositoryException {
        return this.isDirectory() ? NodeType.LABEL : NodeType.DOC;
    }

    public String getFileExtension() {
        return FilenameUtils.getExtension((String)this.getName().getName());
    }

    public abstract OlapPathEntry getName();

    public abstract OlapPath getPath();

    public abstract Date getLastModified();

    public abstract Date getLastModifiedX();

    public abstract long getLastModifiedTS();

    public OlapPath getIdentifier() {
        return this.getPath();
    }

    public Node getParent() throws RepositoryException {
        return ((Session)this.session).repository.getParent(this.session, this);
    }

    @Nullable
    public Node getParentX() throws RepositoryException {
        return ((Session)this.session).repository.getParentX(this.session, this);
    }

    public boolean equals(Object obj) {
        if (obj instanceof Node) {
            try {
                return this.isSame((Node)obj);
            }
            catch (RepositoryException ex) {
                throw new RuntimeException(ex);
            }
        }
        return false;
    }

    public boolean isDirectory() throws RepositoryException {
        return this.isDirectory;
    }

    public boolean isSame(Node other) throws RepositoryException {
        return ((Session)this.session).repository.isSame(this.session, this, other);
    }

    public boolean isChildOf(Node other) throws RepositoryException {
        return ((Session)this.session).repository.isChildOf(this.session, this, other);
    }

    public Node addDirectory(OlapPath name) throws RepositoryException {
        this.assertReadWriteConnection("add-directory");
        return ((Session)this.session).repository.addDirectory(this.session, this, name);
    }

    public Node addDirectories(@Nullable OlapPath path) throws RepositoryException {
        if (path == null) {
            return this;
        }
        this.assertReadWriteConnection("add-directories");
        return ((Session)this.session).repository.addDirectories(this.session, this, true, path);
    }

    public Node addFile(OlapPath name, boolean applyInheritedPermissions, String fileContent) throws RepositoryException {
        this.assertReadWriteConnection("add-file [1]");
        try {
            String encoding = "UTF-8";
            ByteArrayInputStream stream = new ByteArrayInputStream(fileContent.getBytes("UTF-8"));
            return this.addFile(name, applyInheritedPermissions, stream);
        }
        catch (UnsupportedEncodingException ex) {
            throw new RepositoryException(ex);
        }
    }

    public Node addFile(OlapPath name, boolean applyInheritedPermissions, InputStream fileContent) throws RepositoryException {
        this.assertReadWriteConnection("add-file [2]");
        return ((Session)this.session).repository.addFile(this.session, this, name, applyInheritedPermissions, fileContent);
    }

    public boolean hasNode(OlapPath relPath) throws RepositoryException {
        return ((Session)this.session).repository.hasNode(this.session, this, relPath);
    }

    public boolean hasNode(OlapPathEntry relPath) throws RepositoryException {
        return ((Session)this.session).repository.hasNode(this.session, this, OlapPath.create((OlapPathEntry[])new OlapPathEntry[]{relPath}));
    }

    public Node getNode(OlapPath relPath) throws RepositoryException {
        return ((Session)this.session).repository.getNode(this.session, this, relPath);
    }

    public Node getNode(OlapPathEntry relPath) throws RepositoryException {
        return ((Session)this.session).repository.getNode(this.session, this, OlapPath.create((OlapPathEntry[])new OlapPathEntry[]{relPath}));
    }

    public NodeIterator getNodes() throws RepositoryException {
        return ((Session)this.session).repository.getChildNodes(this.session, this);
    }

    @Nullable
    public String getOwner(OlapPath[] users) throws RepositoryException {
        OlapPath path = this.getPath();
        for (OlapPath parentPath = path.getParent(); parentPath != null && !parentPath.isEmpty(); parentPath = parentPath.getParent()) {
            if (Node.isUsers(users, parentPath)) {
                String user = path.getName().getName();
                return user;
            }
            path = parentPath;
        }
        return null;
    }

    private static boolean isUsers(OlapPath[] users, OlapPath path) {
        String name = path.getName().getName();
        if (name.equals(OlapDocsRepository.NODE_IC3_REPORT_DATA_USERS_NAME.getName())) {
            for (OlapPath userP : users) {
                if (!path.endsWith(userP)) continue;
                return true;
            }
        }
        return false;
    }

    public NodeMeta getMeta() throws RepositoryException {
        return ((Session)this.session).repository.getMeta(this.session, this);
    }

    public boolean isApplyInheritedPermissions() throws RepositoryException {
        return this.getMeta().isApplyInheritedPermissions();
    }

    public boolean hasPermissions() throws RepositoryException {
        return this.getMeta().hasPermissions();
    }

    public void updatePermissions(List<OlapDocsSharing> sharings) throws RepositoryException {
        this.assertReadWriteConnection("update-permissions [1]");
        ((Session)this.session).repository.updatePermissions(this.session, this, sharings);
    }

    public void updatePermissions(boolean applyInheritedPermissions, List<OlapDocsSharing> sharings) throws RepositoryException {
        this.assertReadWriteConnection("update-permissions [2]");
        ((Session)this.session).repository.updatePermissions(this.session, this, applyInheritedPermissions, sharings);
    }

    public void updatePermissionsX(@Nullable Boolean applyInheritedPermissions, @Nullable List<OlapDocsSharing> sharings) throws RepositoryException {
        this.assertReadWriteConnection("update-permissions [3]");
        ((Session)this.session).repository.updatePermissionsX(this.session, this, applyInheritedPermissions, sharings);
    }

    public List<OlapDocsSharing> unmarshallPermissions() throws RepositoryException {
        return this.getMeta().getPermissions();
    }

    public void marshallDoc(String fileContent) throws RepositoryException {
        this.assertReadWriteConnection("save-content[ 1]");
        try {
            String encoding = "UTF-8";
            ByteArrayInputStream stream = new ByteArrayInputStream(fileContent.getBytes("UTF-8"));
            this.marshallDoc(stream);
        }
        catch (UnsupportedEncodingException ex) {
            throw new RepositoryException(ex);
        }
    }

    public void marshallDoc(InputStream fileContent) throws RepositoryException {
        this.assertReadWriteConnection("save-content [2]");
        ((Session)this.session).repository.updateDocContent(this.session, this, fileContent);
    }

    public void unmarshallDoc(OlapDocsDoc doc, boolean withFileData) throws RepositoryException {
        ((Session)this.session).repository.getDocContent(this.session, this, doc, withFileData);
    }

    private void assertReadWriteConnection(String operation) {
        if (((Session)this.session).isReadOnly()) {
            throw new RuntimeException("internal error: read-only connection (" + operation + ")");
        }
    }

    public String toString() {
        try {
            return this.getPath().toString();
        }
        catch (RuntimeException runtimeException) {
            return super.toString();
        }
    }
}

