/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.server.print;

import crazydev.common.utils.CdStringUtils;
import crazydev.iccube.configuration.OlapConfigurationErrorCode;
import crazydev.iccube.configuration.OlapConfigurationException;
import crazydev.iccube.server.request.processor.print.paper.IcCubePaperSizes;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlElementRef;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.Nullable;

@XmlRootElement(name="printComponentConfiguration")
public class IcCubePrintComponentConfiguration {
    private static final int DEFAULT_ACTIVE_COUNT = 4;
    @XmlElementRef(type=FilterParam.class, required=false)
    @Nullable
    private List<FilterParam> filterParams;
    @XmlAttribute(name="active", required=false)
    private Boolean active;
    @XmlElement(name="url", required=true)
    private String url;
    @XmlElement(name="printUrl", required=false)
    private String printUrl;
    @XmlElement(name="exec", required=false)
    private String exec;
    @XmlElement(name="execOptions", required=false)
    @Nullable
    private String execOptions;
    @XmlElement(name="timeout", required=false)
    private int timeout;
    @XmlElement(name="waitPeriodMS", required=false)
    @Nullable
    private Integer waitPeriodMS;
    @XmlElement(name="readingTimeoutMS", required=false)
    @Nullable
    private Integer readingTimeoutMS;
    @XmlElement(name="maxActiveCount", required=false, defaultValue="4")
    private int maxActiveCount;
    @XmlElement(name="paperSizes", required=false)
    @Nullable
    private IcCubePaperSizes paperSizes;

    protected IcCubePrintComponentConfiguration() {
    }

    public List<FilterParam> getFilterParams() {
        return this.filterParams != null ? this.filterParams : new ArrayList<FilterParam>();
    }

    public void validate() throws OlapConfigurationException {
        if (this.isPrintOnServerActive()) {
            if (CdStringUtils.isNullOrBlank((String)this.url)) {
                throw new OlapConfigurationException(OlapConfigurationErrorCode.COMPONENT_IS_MISSING, new Serializable[]{"url"});
            }
            if (this.paperSizes == null || this.paperSizes.isEmpty()) {
                throw new OlapConfigurationException(OlapConfigurationErrorCode.COMPONENT_IS_MISSING, new Serializable[]{"paperSizes"});
            }
            this.paperSizes.validate();
            if (this.maxActiveCount <= 0) {
                this.maxActiveCount = 4;
            }
            if ("chrome".equals(this.exec)) {
                this.exec = null;
            }
        }
    }

    public boolean isPrintOnServerActive() {
        return this.active == null || this.active != false;
    }

    public String getUrl() {
        return this.url.trim();
    }

    public String getPrintUrl() {
        return this.printUrl;
    }

    @Nullable
    public String getExec() {
        return this.exec;
    }

    @Nullable
    public String getExecOptions() {
        return this.execOptions;
    }

    public int getTimeout() {
        if (this.timeout <= 0) {
            return 120;
        }
        return this.timeout;
    }

    public IcCubePaperSizes getPaperSizes() {
        return this.paperSizes;
    }

    public int getWaitPeriodMS() {
        return this.waitPeriodMS == null || this.waitPeriodMS < 10 ? 1000 : this.waitPeriodMS;
    }

    public int getReadingTimeoutMS() {
        return this.readingTimeoutMS == null || this.readingTimeoutMS < 10000 ? 120000 : this.readingTimeoutMS;
    }

    public int getMaxActiveCount() {
        return this.maxActiveCount <= 0 ? 4 : this.maxActiveCount;
    }

    @XmlRootElement(name="filterParam")
    public static class FilterParam {
        @XmlElement(name="name", required=true)
        private String name;
        @XmlElement(name="value", required=true)
        private String value;

        public String getName() {
            return this.name;
        }

        public String getValue() {
            return this.value;
        }
    }
}

