/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.server.loggers;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import crazydev.iccube.server.loggers.OlapLoggerLevel;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public class OlapLoggerLevels {
    @Expose
    @SerializedName(value="loggers")
    private final List<OlapLoggerLevel> loggers;

    public OlapLoggerLevels() {
        this(new ArrayList<OlapLoggerLevel>());
    }

    public OlapLoggerLevels(List<OlapLoggerLevel> loggers) {
        this.loggers = loggers;
    }

    public List<OlapLoggerLevel> getLoggers() {
        return this.loggers;
    }

    public void update(Logger logger, @Nullable Level level) {
        String name = logger.getName();
        OlapLoggerLevel newLogger = new OlapLoggerLevel(name, level != null ? level.toString() : null);
        for (int ii = 0; ii < this.loggers.size(); ++ii) {
            OlapLoggerLevel loggerLevel = this.loggers.get(ii);
            if (!loggerLevel.getLogger().equalsIgnoreCase(name)) continue;
            this.loggers.set(ii, newLogger);
            return;
        }
        this.loggers.add(newLogger);
    }

    public static OlapLoggerLevels fromJson(Reader json) {
        Gson gson = new Gson();
        OlapLoggerLevels levels = (OlapLoggerLevels)gson.fromJson(json, OlapLoggerLevels.class);
        return levels;
    }

    public static String asJson(OlapLoggerLevels levels) {
        Gson gson = new GsonBuilder().excludeFieldsWithoutExposeAnnotation().create();
        String json = gson.toJson((Object)levels);
        return json;
    }
}

