/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.server.http;

import crazydev.common.babylon.CdBabylonService;
import crazydev.common.exception.CdError;
import crazydev.common.exception.ICdException;
import crazydev.iccube.babylon.OlapBabylonService;
import crazydev.iccube.gwt.server.reporting.repository.OlapDocsMimeTypes;
import crazydev.iccube.pub.principal.OlapPrincipal;
import crazydev.iccube.request.log.OlapRequestId;
import crazydev.iccube.runtime.OlapRuntime;
import crazydev.iccube.server.configuration.IcCubeMimeTypesConfiguration;
import crazydev.iccube.server.context.IcCubeServerApplicationContext;
import crazydev.iccube.server.context.IcCubeServerSessionContext;
import crazydev.iccube.server.http.IcCubeServlet;
import crazydev.iccube.server.request.request.common.IcCubeServerRequestContext;
import crazydev.iccube.server.request.request.other.IcCubeOtherServerRequest;
import crazydev.iccube.server.request.request.other.IcCubeOtherServerRequestContext;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import org.apache.log4j.Logger;
import org.eclipse.jetty.http.HttpHeader;
import org.jetbrains.annotations.Nullable;

public abstract class IcCubeResourceServlet
extends IcCubeServlet {
    protected final Logger logger;
    protected final String logPrefix;
    private final OlapDocsMimeTypes mimeTypes;

    protected IcCubeResourceServlet(Logger logger, String logPrefix, @Nullable IcCubeMimeTypesConfiguration mimeTypes) {
        this.logger = logger;
        this.logPrefix = logPrefix;
        this.mimeTypes = new OlapDocsMimeTypes(mimeTypes);
    }

    @Override
    protected final void doHandle(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        response.setCharacterEncoding(StandardCharsets.UTF_8.name());
        IcCubeOtherServerRequestContext requestContext = this.createRequestContext(request, response);
        try {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"%s request doc URI : %s".formatted(this.logPrefix, request.getRequestURI()));
            }
            this.doHandleUnsafe(request, response, requestContext);
        }
        catch (ServletException | IOException | RuntimeException ex) {
            this.logger.error((Object)"%s unexpected request error".formatted(this.logPrefix), ex);
            this.replyException(request, response, (IcCubeServerRequestContext)requestContext, (Exception)ex);
        }
    }

    protected abstract void doHandleUnsafe(HttpServletRequest var1, HttpServletResponse var2, IcCubeServerRequestContext var3) throws ServletException, IOException;

    protected IcCubeOtherServerRequestContext createRequestContext(HttpServletRequest request, HttpServletResponse response) {
        OlapRequestId requestId = OlapRequestId.getThreadRequestId(null);
        IcCubeServerSessionContext sContext = IcCubeServerSessionContext.getOrCreateSessionContext(request);
        IcCubeOtherServerRequest req = new IcCubeOtherServerRequest(requestId);
        return new IcCubeOtherServerRequestContext(sContext, req);
    }

    @Nullable
    protected String getCSRFToken(HttpServletRequest request) {
        OlapPrincipal principal;
        HttpSession session = request.getSession(false);
        if (session != null && (principal = (OlapPrincipal)session.getAttribute("icCube.principal")) != null) {
            return principal.getCSRFToken();
        }
        return null;
    }

    protected void setContentType(HttpServletResponse response, File resource) {
        this.setContentType(response, resource.getName());
    }

    protected void setContentType(HttpServletResponse response, String resource) {
        String mimeType = this.mimeTypes.getMimeTypeByExtension(resource);
        response.setContentType(mimeType);
    }

    protected void replyException(HttpServletRequest httpRequest, HttpServletResponse httpResponse, IcCubeServerRequestContext requestContext, Exception error) throws IOException {
        if (error instanceof ICdException) {
            ICdException ic3error = (ICdException)error;
            this.replyException(httpRequest, httpResponse, requestContext, ic3error.getError());
            return;
        }
        this.replyErrorPage(httpRequest, httpResponse, requestContext, 500, error.getMessage());
    }

    protected void replyException(HttpServletRequest httpRequest, HttpServletResponse httpResponse, IcCubeServerRequestContext requestContext, CdError error) throws IOException {
        OlapBabylonService babylon = requestContext.getBabylonService();
        String message = error.asMessage((CdBabylonService)babylon);
        this.replyErrorPage(httpRequest, httpResponse, requestContext, 500, message);
    }

    protected void replyNotFound(HttpServletRequest httpRequest, HttpServletResponse httpResponse, IcCubeServerRequestContext requestContext, String resourcePathInfo) throws IOException {
        OlapBabylonService babylon = requestContext.getBabylonService();
        String message = babylon.translate("rpt_DocNotFound", new Serializable[]{String.valueOf(resourcePathInfo)});
        this.replyErrorPage(httpRequest, httpResponse, requestContext, 404, message);
    }

    protected void replyErrorPage(HttpServletRequest httpRequest, HttpServletResponse httpResponse, IcCubeServerRequestContext requestContext, int code, String message) throws IOException {
        File file = 404 == code ? this.getErrorNotFoundPageHtml(requestContext) : this.getErrorPageHtml(requestContext);
        this.doReplyErrorPage(httpRequest, httpResponse, file, code, message);
    }

    private File getErrorNotFoundPageHtml(IcCubeServerRequestContext requestContext) {
        IcCubeServerApplicationContext applicationContext = requestContext.getApplicationContext();
        OlapRuntime runtime = applicationContext.getRuntime();
        return new File(runtime.getInstallWebDirectory(), "icCube_errorNotFound.html");
    }

    private File getErrorPageHtml(IcCubeServerRequestContext requestContext) {
        IcCubeServerApplicationContext applicationContext = requestContext.getApplicationContext();
        OlapRuntime runtime = applicationContext.getRuntime();
        return new File(runtime.getInstallWebDirectory(), "icCube_error.html");
    }

    protected void doReplyErrorPage(HttpServletRequest request, HttpServletResponse response, File errorFile, int code, String message) throws IOException {
        response.setStatus(code);
        response.setHeader(HttpHeader.EXPIRES.asString(), null);
        response.setHeader(HttpHeader.LAST_MODIFIED.asString(), null);
        response.setHeader(HttpHeader.CACHE_CONTROL.asString(), "must-revalidate,no-cache,no-store");
        this.setContentType(response, errorFile);
        PrintWriter out = response.getWriter();
        try (BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(errorFile), StandardCharsets.UTF_8));){
            String line;
            while ((line = in.readLine()) != null) {
                line = line.replace("'images/", "'/icCube/images/");
                line = line.replace("\"images/", "\"/icCube/images/");
                line = line.replace("$message$", message);
                ((Writer)out).write(line);
                ((Writer)out).write("\n");
            }
            ((Writer)out).close();
        }
    }
}

