/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.server.http;

import crazydev.iccube.http.OlapHttpUtils;
import crazydev.iccube.olap.loggers.OlapLoggers;
import jakarta.servlet.http.HttpServletRequest;
import java.security.Principal;
import org.apache.log4j.Logger;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.http.HttpURI;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.RequestLog;
import org.eclipse.jetty.server.Response;
import org.eclipse.jetty.util.Fields;
import org.eclipse.jetty.util.component.ContainerLifeCycle;
import org.jetbrains.annotations.Nullable;

public class IcCubeRequestLog
extends ContainerLifeCycle
implements RequestLog {
    public void log(Request request, Response response) {
        Logger log = OlapLoggers.HTTP_REQUEST;
        if (!log.isDebugEnabled()) {
            return;
        }
        Request requestU = Request.unWrap((Request)request);
        StringBuilder sb = new StringBuilder("-- HTTP request ----------------------------------------------- \n").append("HTTP request info : (").append(requestU.getMethod()).append(") ").append(IcCubeRequestLog.getURI(requestU)).append("\n").append("      client-addr : ").append(IcCubeRequestLog.getClientIpAddr(requestU)).append("\n").append("      remote-addr : ").append(IcCubeRequestLog.getRemoteAddr(requestU)).append("\n").append("      remote-port : ").append(IcCubeRequestLog.getRemotePort(requestU)).append("\n").append("      remote-user : ").append(IcCubeRequestLog.getRemoteUser(requestU)).append("\n").append("      length      : ").append(requestU.getLength()).append("\n");
        HttpFields headers = requestU.getHeaders();
        for (HttpField field : headers) {
            String header = field.getName();
            String value = !header.equals("Authorization") ? field.getValue() : "...";
            sb.append("           header : ").append(header).append(" : ").append(value).append("\n");
        }
        try {
            Fields params = Request.getParameters((Request)request);
            for (Fields.Field param : params) {
                String name = param.getName();
                String value = param.getValue();
                sb.append("            param : ").append(name).append(" : ").append(value).append("\n");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        log.debug((Object)sb.toString());
    }

    private static String getURI(Request request) {
        HttpURI uri = request.getHttpURI();
        return IcCubeRequestLog.nullable(uri != null ? uri.toString() : null);
    }

    private static String getClientIpAddr(Request request) {
        if (request instanceof HttpServletRequest) {
            HttpServletRequest http = (HttpServletRequest)request;
            return IcCubeRequestLog.nullable(OlapHttpUtils.getClientIpAddr((HttpServletRequest)http));
        }
        return "n/a";
    }

    private static String getRemoteAddr(Request request) {
        return IcCubeRequestLog.nullable(Request.getRemoteAddr((Request)request));
    }

    private static int getRemotePort(Request request) {
        return Request.getRemotePort((Request)request);
    }

    private static String getRemoteUser(Request request) {
        Request.AuthenticationState authenticationState = Request.getAuthenticationState((Request)request);
        Principal userPrincipal = authenticationState == null ? null : authenticationState.getUserPrincipal();
        return IcCubeRequestLog.nullable(userPrincipal != null ? userPrincipal.getName() : null);
    }

    private static String nullable(@Nullable String value) {
        return value != null ? value : "n/a";
    }
}

