/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.server.http;

import crazydev.iccube.olap.loggers.OlapLoggers;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.eclipse.jetty.http.HttpStatus;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.handler.ErrorHandler;

public class IcCubeHttpErrorHandler
extends ErrorHandler {
    private final File errorHtml;

    public IcCubeHttpErrorHandler(File installWebDirectory) {
        File errorFile = new File(installWebDirectory, "icCube_error.html");
        this.errorHtml = errorFile.isFile() && errorFile.exists() ? errorFile : null;
        this.setShowStacks(false);
    }

    protected void writeErrorHtml(Request request, Writer writer, Charset charset, int code, String message, Throwable cause) throws IOException {
        if (cause != null) {
            OlapLoggers.REQUEST.error((Object)"[request] unexpected HTTP request error", cause);
        }
        if (this.errorHtml == null) {
            super.writeErrorHtml(request, writer, charset, code, message, cause);
            return;
        }
        if (message == null) {
            message = HttpStatus.getMessage((int)code);
        }
        try (BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.errorHtml), StandardCharsets.UTF_8));){
            String line;
            while ((line = in.readLine()) != null) {
                line = line.replace("'images/", "'/icCube/images/");
                line = line.replace("\"images/", "\"/icCube/images/");
                line = line.replace("$message$", message);
                writer.write(line);
                writer.write("\n");
            }
        }
    }

    protected void writeErrorJson(Request request, PrintWriter writer, int code, String message, Throwable cause) {
        if (cause != null) {
            OlapLoggers.REQUEST.error((Object)"[request] unexpected HTTP request error", cause);
        }
        super.writeErrorJson(request, writer, code, message, cause);
    }

    protected void writeErrorPlain(Request request, PrintWriter writer, int code, String message, Throwable cause) {
        if (cause != null) {
            OlapLoggers.REQUEST.error((Object)"[request] unexpected HTTP request error", cause);
        }
        super.writeErrorPlain(request, writer, code, message, cause);
    }
}

