/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.server.http;

import crazydev.iccube.configuration.OlapConfigurationException;
import crazydev.iccube.server.http.IcCubeHttpCrossOriginHandler;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.time.Duration;
import java.util.Set;
import org.eclipse.jetty.util.StringUtil;
import org.jetbrains.annotations.Nullable;

@XmlRootElement(name="crossOriginConfiguration")
public class IcCubeCrossOriginConfiguration {
    @XmlElement(name="allowCredentials")
    @Nullable
    private Boolean allowCredentials;
    @XmlElement(name="allowedHeaders")
    @Nullable
    private String allowedHeaders;
    @XmlElement(name="allowedMethods")
    @Nullable
    private String allowedMethods;
    @XmlElement(name="allowedOriginPatterns")
    @Nullable
    private String allowedOriginPatterns;
    @XmlElement(name="allowedTimingOriginPatterns")
    @Nullable
    private String allowedTimingOriginPatterns;
    @XmlElement(name="deliverPreflightRequests")
    @Nullable
    private Boolean deliverPreflightRequests;
    @XmlElement(name="deliverNonAllowedOriginRequests")
    @Nullable
    private Boolean deliverNonAllowedOriginRequests;
    @XmlElement(name="deliverNonAllowedOriginWebSocketUpgradeRequests")
    @Nullable
    private Boolean deliverNonAllowedOriginWebSocketUpgradeRequests;
    @XmlElement(name="exposedHeaders")
    @Nullable
    private String exposedHeaders;
    @XmlElement(name="preflightMaxAge")
    @Nullable
    private Integer preflightMaxAge;

    public void validate() throws OlapConfigurationException {
    }

    public void configure(IcCubeHttpCrossOriginHandler handler) {
        if (this.allowCredentials != null) {
            handler.setAllowCredentials(this.allowCredentials);
        }
        if (this.allowedHeaders != null) {
            handler.setAllowedHeaders(IcCubeCrossOriginConfiguration.split(this.allowedHeaders));
        }
        if (this.allowedMethods != null) {
            handler.setAllowedMethods(IcCubeCrossOriginConfiguration.split(this.allowedMethods));
        }
        if (this.allowedOriginPatterns != null) {
            handler.setAllowedOriginPatterns(IcCubeCrossOriginConfiguration.split(this.allowedOriginPatterns));
        }
        if (this.allowedTimingOriginPatterns != null) {
            handler.setAllowedTimingOriginPatterns(IcCubeCrossOriginConfiguration.split(this.allowedTimingOriginPatterns));
        }
        if (this.deliverPreflightRequests != null) {
            handler.setDeliverPreflightRequests(this.deliverPreflightRequests);
        }
        if (this.deliverNonAllowedOriginRequests != null) {
            handler.setDeliverNonAllowedOriginRequests(this.deliverNonAllowedOriginRequests);
        }
        if (this.deliverNonAllowedOriginWebSocketUpgradeRequests != null) {
            handler.setDeliverNonAllowedOriginWebSocketUpgradeRequests(this.deliverNonAllowedOriginWebSocketUpgradeRequests);
        }
        if (this.exposedHeaders != null) {
            handler.setExposedHeaders(IcCubeCrossOriginConfiguration.split(this.exposedHeaders));
        }
        if (this.preflightMaxAge != null) {
            handler.setPreflightMaxAge(Duration.ofSeconds(this.preflightMaxAge.intValue()));
        }
    }

    private static Set<String> split(String values) {
        String[] parts = StringUtil.csvSplit((String)values);
        return Set.of(parts);
    }

    @Nullable
    public Boolean getAllowCredentials() {
        return this.allowCredentials;
    }

    @Nullable
    public String getAllowedHeaders() {
        return this.allowedHeaders;
    }

    @Nullable
    public String getAllowedMethods() {
        return this.allowedMethods;
    }

    @Nullable
    public String getAllowedOriginPatterns() {
        return this.allowedOriginPatterns;
    }

    @Nullable
    public String getAllowedTimingOriginPatterns() {
        return this.allowedTimingOriginPatterns;
    }

    @Nullable
    public Boolean getDeliverPreflightRequests() {
        return this.deliverPreflightRequests;
    }

    @Nullable
    public Boolean getDeliverNonAllowedOriginRequests() {
        return this.deliverNonAllowedOriginRequests;
    }

    @Nullable
    public Boolean getDeliverNonAllowedOriginWebSocketUpgradeRequests() {
        return this.deliverNonAllowedOriginWebSocketUpgradeRequests;
    }

    @Nullable
    public String getExposedHeaders() {
        return this.exposedHeaders;
    }

    @Nullable
    public Integer getPreflightMaxAge() {
        return this.preflightMaxAge;
    }
}

