/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.server.http;

import crazydev.common.utils.CdStringUtils;
import crazydev.iccube.olap.loggers.OlapLoggers;
import crazydev.iccube.request.log.OlapRequestType;
import crazydev.iccube.server.http.IcCubeServlet;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import org.apache.commons.text.StringEscapeUtils;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.MimeTypes;

public class IcCube404Servlet
extends IcCubeServlet {
    public static boolean missing = false;
    private static final long serialVersionUID = -3000284422795807870L;

    @Override
    public OlapRequestType getRequestType() {
        return OlapRequestType.UNKNOWN;
    }

    @Override
    protected void doHandle(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String uri = request.getRequestURI();
        if (CdStringUtils.isNullOrBlank((String)uri) || "/".equals(uri)) {
            response.sendRedirect(response.encodeRedirectURL("/icCube/console"));
            return;
        }
        response.setCharacterEncoding(StandardCharsets.UTF_8.name());
        ServletContext servletContext = this.getServletContext();
        URL pageNotFound = servletContext.getResource("/icCube_errorNotFound.html");
        if (pageNotFound == null) {
            response.sendError(404, "We're sorry, but the page you were looking for doesn't exist.");
            return;
        }
        try {
            IcCube404Servlet.doReplyIcCube404unsafe(request, response, pageNotFound);
        }
        catch (IOException | URISyntaxException ex) {
            OlapLoggers.REQUEST.warn((Object)"page not found unexpected error", (Throwable)ex);
        }
    }

    private static void doReplyIcCube404unsafe(HttpServletRequest request, HttpServletResponse response, URL pageNotFound) throws IOException, URISyntaxException {
        String line2;
        String line1;
        response.setStatus(404);
        response.setHeader(HttpHeader.EXPIRES.asString(), null);
        response.setHeader(HttpHeader.LAST_MODIFIED.asString(), null);
        response.setHeader(HttpHeader.CACHE_CONTROL.asString(), "must-revalidate,no-cache,no-store");
        response.setContentType(MimeTypes.Type.TEXT_HTML_UTF_8.toString());
        if (!missing) {
            String uri = request.getRequestURI();
            line1 = "We're sorry, but the page you were looking for doesn't exist.";
            line2 = uri != null ? "<br>Page : " + StringEscapeUtils.escapeHtml4((String)uri) : "";
        } else {
            line1 = "You are using an unlicensed version of icCube.";
            line2 = "<br>Please <a href='https://iccube.com/request-license' target='_blank'>contact</a> the icCube team to obtain a valid license.";
        }
        File errorFile = new File(pageNotFound.toURI());
        PrintWriter out = response.getWriter();
        try (BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(errorFile), StandardCharsets.UTF_8));){
            String line;
            while ((line = in.readLine()) != null) {
                line = line.replace("'images/", "'/icCube/images/");
                line = line.replace("\"images/", "\"/icCube/images/");
                line = line.replace("$message$", line1 + line2);
                ((Writer)out).write(line);
                ((Writer)out).write("\n");
            }
            ((Writer)out).close();
        }
    }
}

