/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.server.gvi.request.report;

import crazydev.iccube.gvi.table.GviColumnDescription;
import crazydev.iccube.gvi.table.GviTable;
import crazydev.iccube.gvi.table.GviTableRow;
import crazydev.iccube.olap.component.OlapEngineComponent;
import crazydev.iccube.olap.component.context.OlapEngineRequestContext;
import crazydev.iccube.olap.component.schemas.IOlapEngineSchemaDataUpdatedListener;
import crazydev.iccube.olap.loggers.OlapLoggers;
import crazydev.iccube.olap.schema.OlapSchemaDataUpdate;
import crazydev.iccube.server.context.IcCubeServerApplicationContext;
import crazydev.iccube.server.gvi.request.common.GviDataTableResponse;
import crazydev.iccube.server.gvi.request.common.GviQuery;
import crazydev.iccube.server.gvi.request.common.GviQueryContext;
import crazydev.iccube.server.gvi.request.common.GviResponse;
import crazydev.iccube.server.request.request.gvi.IcCubeGviServerRequestContext;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.commons.collections4.map.HashedMap;
import org.jetbrains.annotations.Nullable;

public class GviSchemaDataUpdateReportQuery
extends GviQuery {
    private final boolean longPolling;
    private final Map<String, SchemaDataUpdate> schemaDataUpdate;

    public GviSchemaDataUpdateReportQuery(String uuid, boolean longPolling, Map<String, SchemaDataUpdate> schemaDataUpdate) {
        super(uuid);
        this.longPolling = longPolling;
        this.schemaDataUpdate = schemaDataUpdate;
    }

    @Override
    public boolean isMonitored() {
        return false;
    }

    @Override
    @Nullable
    public String getSchema() {
        return null;
    }

    @Override
    public boolean isSchemaWrite() {
        return false;
    }

    @Override
    public String getUserFriendlyTypeName() {
        return "GVI Schema Data Update";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GviResponse execute(GviQueryContext queryContext) {
        IcCubeGviServerRequestContext requestContext = queryContext.getIcCubeServerRequestContext();
        IcCubeServerApplicationContext appContext = requestContext.getApplicationContext();
        appContext.incrSchemaDataUpdateLongPollingRequest();
        try {
            GviResponse gviResponse = this.doExecute(queryContext);
            return gviResponse;
        }
        finally {
            appContext.decrSchemaDataUpdateLongPollingRequest();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private GviResponse doExecute(GviQueryContext queryContext) {
        OlapEngineRequestContext engineRequestContext = queryContext.getOlapEngineRequestContext();
        OlapEngineComponent engine = engineRequestContext.getOlapEngineComponent();
        Map<String, SchemaDataUpdate> outdated = this.outdated(engineRequestContext);
        OlapLoggers.GVI_REQUEST.debug((Object)("[GVI] schema-update:outdated[" + (outdated != null) + "][longPolling:" + this.longPolling + "]"));
        if (outdated != null || !this.longPolling) {
            return this.response(queryContext, outdated);
        }
        CountDownLatch sync = new CountDownLatch(1);
        List<SchemaDataUpdatedListener> listeners = this.setupSchemaListeners(sync);
        String schemaNames = GviSchemaDataUpdateReportQuery.schemaNames(listeners);
        try {
            OlapLoggers.GVI_REQUEST.debug((Object)("[GVI] schema-update:listening[" + schemaNames + "]"));
            for (SchemaDataUpdatedListener listener : listeners) {
                engine.addSchemaDataUpdatedListener(engineRequestContext.getUserTenant(), (IOlapEngineSchemaDataUpdatedListener)listener);
            }
            try {
                int timeout = queryContext.getServerProperties().getReportRefreshOnDataUpdateWaitTimeout();
                OlapLoggers.GVI_REQUEST.debug((Object)("[GVI] schema-update:waiting[timeout:" + timeout + "][" + schemaNames + "]"));
                sync.await(timeout, TimeUnit.SECONDS);
                OlapLoggers.GVI_REQUEST.debug((Object)("[GVI] schema-update:waiting[" + schemaNames + "] done"));
            }
            catch (InterruptedException ex) {
                OlapLoggers.GVI_REQUEST.debug((Object)("[GVI] schema-update:interrupted[" + schemaNames + "]"));
            }
        }
        finally {
            for (SchemaDataUpdatedListener listener : listeners) {
                engine.removeSchemaDataUpdatedListener(engineRequestContext.getUserTenant(), (IOlapEngineSchemaDataUpdatedListener)listener);
            }
        }
        OlapLoggers.GVI_REQUEST.debug((Object)("[GVI] schema-update:done[" + schemaNames + "]"));
        return this.response(queryContext, this.outdated(engineRequestContext));
    }

    private static String schemaNames(List<SchemaDataUpdatedListener> listeners) {
        StringBuilder names = new StringBuilder();
        for (int ii = 0; ii < listeners.size(); ++ii) {
            SchemaDataUpdatedListener listener = listeners.get(ii);
            if (ii > 0) {
                names.append(",");
            }
            names.append(listener.schemaName);
        }
        return names.toString();
    }

    private List<SchemaDataUpdatedListener> setupSchemaListeners(CountDownLatch sync) {
        ArrayList<SchemaDataUpdatedListener> listeners = new ArrayList<SchemaDataUpdatedListener>();
        for (SchemaDataUpdate update : this.schemaDataUpdate.values()) {
            listeners.add(new SchemaDataUpdatedListener(this, sync, update.schema));
        }
        return listeners;
    }

    private GviResponse response(GviQueryContext queryContext, @Nullable Map<String, SchemaDataUpdate> res) {
        if (res == null) {
            res = Collections.emptyMap();
        }
        GviTable table = new GviTable();
        table.addColumn(new GviColumnDescription("schema-data-timestamp", "OBJECT", "Schema Data Timestamp"));
        GviTableRow row = new GviTableRow();
        row.addCell(res);
        table.addRow(row);
        return new GviDataTableResponse(queryContext, table);
    }

    @Nullable
    private Map<String, SchemaDataUpdate> outdated(OlapEngineRequestContext engineRequestContext) {
        HashedMap res = null;
        for (SchemaDataUpdate value : this.schemaDataUpdate.values()) {
            long schemaLastRefreshTimestamp;
            OlapSchemaDataUpdate update = engineRequestContext.getSchemaNullableLastDataUpdate(value.schema);
            long schemaLastDataUpdateTimestamp = update != null ? update.schemaLastDataUpdateTimestamp : -1L;
            long l = schemaLastRefreshTimestamp = update != null ? update.schemaLastRefreshTimestamp : -1L;
            if (schemaLastDataUpdateTimestamp == value.timestamp) continue;
            if (res == null) {
                res = new HashedMap();
            }
            res.put(value.schema, new SchemaDataUpdate(value.schema, schemaLastDataUpdateTimestamp, schemaLastRefreshTimestamp));
        }
        return res;
    }

    class SchemaDataUpdatedListener
    implements IOlapEngineSchemaDataUpdatedListener {
        final CountDownLatch sync;
        final String schemaName;

        public SchemaDataUpdatedListener(GviSchemaDataUpdateReportQuery this$0, CountDownLatch sync, String schemaName) {
            Objects.requireNonNull(this$0);
            this.sync = sync;
            this.schemaName = schemaName;
        }

        public void onSchemaDataUpdated(String schema) {
            if (this.schemaName.equals(schema)) {
                this.sync.countDown();
            }
        }
    }

    public static class SchemaDataUpdate {
        public final String schema;
        public final long timestamp;
        public final long timestampR;

        public SchemaDataUpdate(String schema, long timestamp, long timestampR) {
            this.schema = schema;
            this.timestamp = timestamp;
            this.timestampR = timestampR;
        }

        public String toString() {
            return this.schema + " [" + this.timestamp + "] [" + this.timestampR + "]";
        }
    }
}

