/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.server.gvi.request.report;

import crazydev.common.utils.CdStringUtils;
import crazydev.iccube.olap.loggers.OlapLoggers;
import java.util.Map;
import org.jetbrains.annotations.Nullable;

public class GviPrintParams {
    private final String appUrl;
    private final String appLocalUrl;
    private final String appCustomizationUrl;
    private final String reportPath;
    @Nullable
    private final String reportParams;
    @Nullable
    private final String patches;
    private final int timeout;
    private final int debugWaitingTime;
    private final double scale;
    private final String pageSizeUnits;
    private final double pageWidth;
    private final double pageHeight;
    private final double marginTop;
    private final double marginRight;
    private final double marginLeft;
    private final double marginBottom;
    @Nullable
    private final String fileName;
    private final Map<String, String> reportingOptions;

    public GviPrintParams(String appUrl, String appLocalUrl, String appCustomizationUrl, String reportPath, @Nullable String reportParams, @Nullable String patches, int timeout, @Nullable Integer debugWaitingTime, double scale, String pageSizeUnits, double pageWidth, double pageHeight, double marginTop, double marginRight, double marginLeft, double marginBottom, @Nullable String fileName, Map<String, String> reportingOptions) {
        this.appUrl = appUrl;
        this.appLocalUrl = appLocalUrl;
        this.appCustomizationUrl = appCustomizationUrl;
        this.reportPath = reportPath;
        this.reportParams = reportParams;
        this.patches = patches;
        this.timeout = timeout;
        this.debugWaitingTime = debugWaitingTime != null ? debugWaitingTime : 0;
        this.scale = scale;
        this.pageSizeUnits = pageSizeUnits;
        this.pageWidth = pageWidth;
        this.pageHeight = pageHeight;
        this.marginTop = marginTop;
        this.marginRight = marginRight;
        this.marginLeft = marginLeft;
        this.marginBottom = marginBottom;
        this.fileName = fileName;
        this.reportingOptions = reportingOptions;
    }

    public String getAppUrl() {
        return this.appUrl;
    }

    public String getAppLocalUrl() {
        return this.appLocalUrl;
    }

    public String getAppCustomizationUrl() {
        return this.appCustomizationUrl;
    }

    public String getReportPath() {
        return this.reportPath;
    }

    @Nullable
    public String getReportParams() {
        return this.reportParams;
    }

    @Nullable
    public String getPatches() {
        return this.patches;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public int getDebugWaitingTime() {
        return this.debugWaitingTime;
    }

    public double getScale() {
        return this.scale;
    }

    public String getPageSizeUnits() {
        return this.pageSizeUnits;
    }

    public double getPageWidth() {
        return this.pageWidth;
    }

    public double getPageHeight() {
        return this.pageHeight;
    }

    public double getMarginTop() {
        return this.marginTop;
    }

    public double getMarginRight() {
        return this.marginRight;
    }

    public double getMarginLeft() {
        return this.marginLeft;
    }

    public double getMarginBottom() {
        return this.marginBottom;
    }

    @Nullable
    public String getFileName() {
        return this.fileName;
    }

    public Map<String, String> getReportingOptions() {
        return this.reportingOptions;
    }

    public void print() {
        OlapLoggers.PRINT.info((Object)"[printing] ");
        OlapLoggers.PRINT.info((Object)"[printing] server options (MF)");
        OlapLoggers.PRINT.info((Object)"[printing] ");
        OlapLoggers.PRINT.info((Object)("[printing]            app URL : " + this.appUrl));
        OlapLoggers.PRINT.info((Object)("[printing]             report : " + this.reportPath));
        OlapLoggers.PRINT.info((Object)("[printing]            timeout : " + this.timeout));
        OlapLoggers.PRINT.info((Object)("[printing]   debugWaitingTime : " + this.debugWaitingTime));
        OlapLoggers.PRINT.info((Object)"[printing] ");
        OlapLoggers.PRINT.info((Object)("[printing]           fileName : " + this.fileName));
        OlapLoggers.PRINT.info((Object)"[printing] ");
        OlapLoggers.PRINT.info((Object)("[printing]            patches : " + this.patches));
        OlapLoggers.PRINT.info((Object)"[printing] ");
        OlapLoggers.PRINT.info((Object)("[printing]              scale : " + this.scale));
        OlapLoggers.PRINT.info((Object)("[printing]      pageSizeUnits : " + this.pageSizeUnits));
        OlapLoggers.PRINT.info((Object)("[printing]          pageWidth : " + this.pageWidth));
        OlapLoggers.PRINT.info((Object)("[printing]         pageHeight : " + this.pageHeight));
        OlapLoggers.PRINT.info((Object)("[printing]          marginTop : " + this.marginTop));
        OlapLoggers.PRINT.info((Object)("[printing]        marginRight : " + this.marginRight));
        OlapLoggers.PRINT.info((Object)("[printing]       marginBottom : " + this.marginBottom));
        OlapLoggers.PRINT.info((Object)("[printing]         marginLeft : " + this.marginLeft));
        OlapLoggers.PRINT.info((Object)"[printing] ");
        OlapLoggers.PRINT.info((Object)"[printing] reporting options (MF)");
        OlapLoggers.PRINT.info((Object)"[printing] ");
        for (Map.Entry<String, String> entry : this.reportingOptions.entrySet()) {
            OlapLoggers.PRINT.info((Object)("[printing] " + entry.getKey() + " : " + entry.getValue()));
        }
        OlapLoggers.PRINT.info((Object)"[printing] ");
    }

    public static int asInt(String value) {
        if (CdStringUtils.isNotNullAndNotBlank((String)value)) {
            return Integer.parseInt(value);
        }
        return 0;
    }

    public static double asDouble(String value) {
        if (CdStringUtils.isNotNullAndNotBlank((String)value)) {
            return Double.parseDouble(value);
        }
        return 0.0;
    }
}

