/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.server.gvi.request.report;

import crazydev.common.babylon.CdBabylonService;
import crazydev.common.exception.CdError;
import crazydev.iccube.authorization.permissions.applications.OlapRoleApplicationPermissions;
import crazydev.iccube.authorization.permissions.common.OlapRoleAuthorizationException;
import crazydev.iccube.authorization.permissions.common.OlapRoleAuthorizationRuntimeException;
import crazydev.iccube.gvi.table.GviColumnDescription;
import crazydev.iccube.gvi.table.GviTable;
import crazydev.iccube.gvi.table.GviTableRow;
import crazydev.iccube.gwt.server.reporting.errors.OlapDocsErrorException;
import crazydev.iccube.gwt.server.reporting.repository.IOlapDocsRequestContext;
import crazydev.iccube.gwt.server.reporting.repository.OlapDocsRepository;
import crazydev.iccube.gwt.server.requesthandler.reporting.OlapReportRepositoryRequestContext;
import crazydev.iccube.olap.loggers.OlapLoggers;
import crazydev.iccube.server.gvi.request.common.GviQuery;
import crazydev.iccube.server.gvi.request.common.GviQueryContext;
import crazydev.iccube.server.gvi.request.common.GviResponse;
import crazydev.iccube.server.gvi.request.common.errors.GviError;
import crazydev.iccube.server.gvi.request.common.errors.GviErrorCode;
import crazydev.iccube.server.request.request.gvi.IcCubeGviServerRequestContext;
import java.io.Serializable;
import java.util.HashMap;
import org.jetbrains.annotations.Nullable;

public abstract class GviAbstractReportQuery
extends GviQuery {
    public GviAbstractReportQuery(String uuid) {
        super(uuid);
    }

    @Override
    @Nullable
    public String getSchema() {
        return null;
    }

    @Override
    public boolean isSchemaWrite() {
        return false;
    }

    @Override
    public final GviResponse execute(GviQueryContext queryContext) {
        try {
            if (!queryContext.isReportServerLicensed()) {
                return GviAbstractReportQuery.asError(new GviError(GviErrorCode.NOT_AUTH_USER, new Serializable[]{queryContext.getUserName(), "Web Reporting"}));
            }
            OlapRoleApplicationPermissions perms = queryContext.getOlapEngineRequestContext().getApplicationPermissions();
            this.assertAccessRights(perms);
            return this.doExecute(queryContext);
        }
        catch (OlapDocsErrorException ex) {
            OlapLoggers.GVI_REQUEST.error((Object)"GVI reporting error", (Throwable)((Object)ex));
            CdError error = ex.getError();
            return GviAbstractReportQuery.asError(new GviError(error.getCode(), error.getParams()));
        }
        catch (OlapRoleAuthorizationException ex) {
            String error = ex.getError().asMessage((CdBabylonService)queryContext.getIcCubeServerRequestContext().getBabylonService());
            return GviAbstractReportQuery.asError(new GviError(GviErrorCode.NOT_AUTH, new Serializable[]{error}));
        }
        catch (OlapRoleAuthorizationRuntimeException ex) {
            String error = ex.getError().asMessage((CdBabylonService)queryContext.getIcCubeServerRequestContext().getBabylonService());
            return GviAbstractReportQuery.asError(new GviError(GviErrorCode.NOT_AUTH, new Serializable[]{error}));
        }
    }

    protected abstract void assertAccessRights(OlapRoleApplicationPermissions var1) throws OlapRoleAuthorizationException;

    protected void assertReadAccess(OlapRoleApplicationPermissions perms) throws OlapRoleAuthorizationException {
        perms.assertReportDashboardReaderEnabled();
    }

    protected void assertWriteAccess(OlapRoleApplicationPermissions perms) throws OlapRoleAuthorizationException {
        perms.assertReportDashboardWriterEnabled();
    }

    protected abstract GviResponse doExecute(GviQueryContext var1) throws OlapDocsErrorException;

    @Override
    protected IOlapDocsRequestContext createRepositoryContext(GviQueryContext queryContext) {
        IcCubeGviServerRequestContext serverRequestContext = queryContext.getIcCubeServerRequestContext();
        return new OlapReportRepositoryRequestContext(serverRequestContext, this.version, null);
    }

    @Override
    protected OlapDocsRepository getDocsRepository(GviQueryContext queryContext) {
        IcCubeGviServerRequestContext serverRequestContext = queryContext.getIcCubeServerRequestContext();
        return serverRequestContext.getApplicationContext().getDocsRepository(queryContext.asRuntimeContext());
    }

    protected GviTable askForConfirmationNG() {
        GviTable table = new GviTable();
        table.addColumn(new GviColumnDescription("report-info", "OBJECT", "Report Info."));
        HashMap<String, Boolean> sb = new HashMap<String, Boolean>();
        sb.put("existing", true);
        GviTableRow row = new GviTableRow();
        row.addCell(sb);
        table.addRow(row);
        return table;
    }
}

