/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.server.gvi.request.report;

import com.google.gson.GsonBuilder;
import crazydev.common.olap.OlapEntityType;
import crazydev.iccube.authorization.permissions.applications.OlapRoleApplicationPermissions;
import crazydev.iccube.authorization.permissions.common.OlapRoleAuthorizationException;
import crazydev.iccube.babylon.OlapBabylonService;
import crazydev.iccube.fs.OlapPath;
import crazydev.iccube.gvi.table.GviColumnDescription;
import crazydev.iccube.gvi.table.GviTable;
import crazydev.iccube.gvi.table.GviTableRow;
import crazydev.iccube.gwt.server.reporting.errors.OlapDocsErrorCode;
import crazydev.iccube.gwt.server.reporting.errors.OlapDocsErrorException;
import crazydev.iccube.gwt.server.reporting.repository.IOlapDocsRequestContext;
import crazydev.iccube.gwt.server.reporting.repository.OlapDocsRepository;
import crazydev.iccube.gwt.server.reporting.repository.gizmos.OlapDocsGizmoDefinition;
import crazydev.iccube.gwt.server.reporting.repository.gizmos.OlapDocsGizmoEntityOperation;
import crazydev.iccube.gwt.server.reporting.repository.gizmos.OlapDocsGizmoEntityType;
import crazydev.iccube.gwt.server.reporting.repository.gizmos.OlapDocsGizmoGadgetMeta;
import crazydev.iccube.gwt.server.reporting.repository.gizmos.OlapDocsGizmoName;
import crazydev.iccube.gwt.server.reporting.repository.gizmos.OlapDocsGizmoNode;
import crazydev.iccube.gwt.server.reporting.repository.gizmos.OlapDocsGizmoSaveMode;
import crazydev.iccube.gwt.server.reporting.repository.gizmos.OlapDocsGizmosRepository;
import crazydev.iccube.olap.component.OlapEngineComponent;
import crazydev.iccube.olap.component.context.OlapEngineRequestContext;
import crazydev.iccube.olap.entity.permissions.IOlapSchemasPermission;
import crazydev.iccube.olap.loggers.OlapLoggers;
import crazydev.iccube.olap.schema.OlapSchemaInfo;
import crazydev.iccube.server.gvi.request.common.GviDataTableResponse;
import crazydev.iccube.server.gvi.request.common.GviQueryContext;
import crazydev.iccube.server.gvi.request.common.GviResponse;
import crazydev.iccube.server.gvi.request.report.GviAbstractReportQuery;
import crazydev.iccube.ux.common.json.UxJsonParserUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.Nullable;

public abstract class GviAbstractReportGizmosQuery
extends GviAbstractReportQuery {
    protected final OlapDocsGizmoEntityType type;

    public GviAbstractReportGizmosQuery(String uuid, OlapDocsGizmoEntityType type) {
        super(uuid);
        this.type = type;
    }

    protected void assertGizmoReadAccess(OlapRoleApplicationPermissions perms, OlapDocsGizmoEntityType type) throws OlapRoleAuthorizationException {
        switch (type) {
            case APPLICATION: 
            case DASHBOARD: 
            case GADGET: 
            case QUERY: {
                this.assertReadAccess(perms);
                break;
            }
            default: {
                throw new RuntimeException("internal error: unexpected type [" + String.valueOf((Object)type) + "]");
            }
        }
    }

    protected void assertGizmoWriteAccess(OlapRoleApplicationPermissions perms, OlapDocsGizmoEntityType type, OlapDocsGizmoEntityOperation operation) throws OlapRoleAuthorizationException {
        switch (type) {
            case APPLICATION: {
                boolean isForCreate = operation == OlapDocsGizmoEntityOperation.saveAs || operation == OlapDocsGizmoEntityOperation.rename || operation == OlapDocsGizmoEntityOperation.move || operation == OlapDocsGizmoEntityOperation.moveFolder || operation == OlapDocsGizmoEntityOperation.createFolder;
                perms.assertReportDashboardApplicationWriterEnabled(isForCreate);
                break;
            }
            case DASHBOARD: {
                this.assertWriteAccess(perms);
                break;
            }
            case GADGET: {
                boolean isForRename = operation == OlapDocsGizmoEntityOperation.rename || operation == OlapDocsGizmoEntityOperation.move || operation == OlapDocsGizmoEntityOperation.moveFolder;
                perms.assertReportGadgetWriterEnabled(isForRename);
                break;
            }
            case QUERY: {
                this.assertReadAccess(perms);
                break;
            }
            default: {
                throw new RuntimeException("internal error: unexpected type [" + String.valueOf((Object)type) + "]");
            }
        }
    }

    public static List<Object> createBreadCrumb(OlapBabylonService babylonService, OlapDocsRepository repository, IOlapDocsRequestContext repositoryContext, boolean isMyDrive, @Nullable OlapPath path) {
        ArrayList<Object> sb = new ArrayList<Object>();
        if (path != null) {
            for (int ii = 1; ii < path.size() + 1; ++ii) {
                OlapPath p = path.subPath(0, ii);
                String iName = p.getName().getName();
                String iPath = p.toSimplePath();
                if (ii == 1 && isMyDrive) continue;
                String sPath = repository.toLogicalSimplePath(repositoryContext, isMyDrive, iPath);
                if (ii == 1) {
                    if (repository.isLogicalSharedSimplePath(repositoryContext, sPath)) {
                        iName = babylonService.translate("docsShared", new Serializable[0]);
                    }
                    if (repository.isLogicalUsersSimplePath(repositoryContext, sPath)) {
                        iName = babylonService.translate("docsUsers", new Serializable[0]);
                    }
                }
                if (ii == 2 && isMyDrive) {
                    iName = babylonService.translate("docsMyDrive", new Serializable[0]);
                }
                HashMap<String, String> obj = new HashMap<String, String>();
                obj.put("type", OlapEntityType.REPORT_FOLDER.getShortName());
                obj.put("name", iName);
                obj.put("path", sPath);
                sb.add(obj);
            }
        }
        return sb;
    }

    protected GviResponse searchGizmoNames(GviQueryContext queryContext, OlapDocsGizmoEntityType type, String path, String pattern, boolean folderOnly, boolean withImage) throws OlapDocsErrorException {
        IOlapDocsRequestContext repositoryContext = this.createRepositoryContext(queryContext);
        OlapDocsRepository repository = this.getDocsRepository(queryContext);
        OlapDocsGizmosRepository gizmos = repository.asGizmosRepository(type);
        OlapPath sPath = repository.fromLogicalSimplePath(repositoryContext, path);
        boolean isMyDrive = repository.isLogicalMyDriveSimplePath(repositoryContext, path);
        List<OlapDocsGizmoName> sorted = gizmos.searchGizmoNames(repositoryContext, sPath, pattern, folderOnly, 100, withImage);
        GviTable table = new GviTable();
        table.addColumn(new GviColumnDescription("type", "Type"));
        table.addColumn(new GviColumnDescription("name", "Name"));
        table.addColumn(new GviColumnDescription("path", "Path"));
        table.addColumn(new GviColumnDescription("modified", "Modified"));
        GviAbstractReportGizmosQuery.addTableColumnsMeta(table, type);
        for (OlapDocsGizmoName gizmo : sorted) {
            String reportPath = gizmo.path;
            String sReportPath = repository.toLogicalSimplePath(repositoryContext, isMyDrive, reportPath);
            GviTableRow row = new GviTableRow();
            row.addCell(gizmo.type);
            row.addCell(gizmo.name);
            row.addCell(sReportPath);
            row.addCell(gizmo.lastModified != null ? gizmo.lastModified : "");
            GviAbstractReportGizmosQuery.addTableRowMeta(row, type, gizmo);
            if (gizmo.perms != null) {
                row.setCustomProperty("perms", gizmo.perms.name());
            }
            table.addRow(row);
        }
        OlapEngineRequestContext requestContext = queryContext.getOlapEngineRequestContext();
        OlapBabylonService babylonService = requestContext.getBabylonService();
        table.setCustomProperty("breadcrumb", GviAbstractReportGizmosQuery.createBreadCrumb(babylonService, repository, repositoryContext, isMyDrive, sPath));
        return new GviDataTableResponse(queryContext, table);
    }

    protected GviResponse listGizmoNames(GviQueryContext queryContext, OlapDocsGizmoEntityType type, String path, boolean withImage) throws OlapDocsErrorException {
        IOlapDocsRequestContext repositoryContext = this.createRepositoryContext(queryContext);
        OlapDocsRepository repository = this.getDocsRepository(queryContext);
        OlapDocsGizmosRepository gizmos = repository.asGizmosRepository(type);
        OlapPath sPath = repository.fromLogicalSimplePath(repositoryContext, path);
        boolean isMyDrive = repository.isLogicalMyDriveSimplePath(repositoryContext, path);
        OlapDocsGizmoName namesR = gizmos.listGizmoNames(repositoryContext, false, sPath, withImage);
        ArrayList<OlapDocsGizmoName> names = namesR.children != null ? namesR.children : new ArrayList<OlapDocsGizmoName>();
        List<OlapDocsGizmoName> sorted = OlapDocsGizmoName.sort(names);
        GviTable table = new GviTable();
        table.addColumn(new GviColumnDescription("type", "Type"));
        table.addColumn(new GviColumnDescription("name", "Name"));
        table.addColumn(new GviColumnDescription("path", "Path"));
        table.addColumn(new GviColumnDescription("modified", "Modified"));
        GviAbstractReportGizmosQuery.addTableColumnsMeta(table, type);
        for (OlapDocsGizmoName gizmo : sorted) {
            GviTableRow row = new GviTableRow();
            row.addCell(gizmo.type);
            row.addCell(gizmo.name);
            row.addCell(repository.toLogicalSimplePath(repositoryContext, isMyDrive, gizmo.path));
            row.addCell(gizmo.lastModified != null ? gizmo.lastModified : "");
            GviAbstractReportGizmosQuery.addTableRowMeta(row, type, gizmo);
            if (gizmo.perms != null) {
                row.setCustomProperty("perms", gizmo.perms.name());
            }
            table.addRow(row);
        }
        OlapEngineRequestContext requestContext = queryContext.getOlapEngineRequestContext();
        OlapBabylonService babylonService = requestContext.getBabylonService();
        table.setCustomProperty("breadcrumb", GviAbstractReportGizmosQuery.createBreadCrumb(babylonService, repository, repositoryContext, isMyDrive, sPath));
        if (namesR.perms != null) {
            table.setCustomProperty("perms", (Object)namesR.perms.name());
        }
        return new GviDataTableResponse(queryContext, table);
    }

    private static void addTableColumnsMeta(GviTable table, OlapDocsGizmoEntityType type) {
        if (type == OlapDocsGizmoEntityType.GADGET) {
            table.addColumn(new GviColumnDescription("synopsis", "Synopsis"));
            table.addColumn(new GviColumnDescription("schema", "Schema"));
            table.addColumn(new GviColumnDescription("theme", "Theme"));
            table.addColumn(new GviColumnDescription("image", "Image"));
        }
    }

    private static void addTableRowMeta(GviTableRow row, OlapDocsGizmoEntityType type, OlapDocsGizmoName gizmo) {
        if (type == OlapDocsGizmoEntityType.GADGET && gizmo.meta instanceof OlapDocsGizmoGadgetMeta) {
            OlapDocsGizmoGadgetMeta meta = (OlapDocsGizmoGadgetMeta)gizmo.meta;
            row.addCell(meta.synopsis != null ? meta.synopsis : "");
            row.addCell(meta.schema != null ? meta.schema : "");
            row.addCell(meta.theme != null ? meta.theme : "");
            row.addCell(meta.image != null ? meta.image : "");
        }
    }

    protected GviResponse getGizmo(GviQueryContext queryContext, OlapDocsGizmoEntityType type, String path, boolean withAuthSchema) throws OlapDocsErrorException {
        IOlapDocsRequestContext repositoryContext = this.createRepositoryContext(queryContext);
        OlapDocsRepository repository = this.getDocsRepository(queryContext);
        OlapDocsGizmosRepository gizmos = repository.asGizmosRepository(type);
        OlapPath sPath = repository.fromLogicalSimplePath(repositoryContext, path);
        boolean isMyDrive = repository.isLogicalMyDriveSimplePath(repositoryContext, path);
        OlapDocsGizmoDefinition gizmo = gizmos.getGizmo(repositoryContext, sPath);
        GviTable table = new GviTable();
        table.addColumn(new GviColumnDescription(type.name(), "OBJECT", type.name()));
        HashMap<String, Object> sb = new HashMap<String, Object>();
        String entityName = gizmo.name.name;
        String entityPath = repository.toLogicalSimplePath(repositoryContext, isMyDrive, gizmo.name.path);
        String entityFolderPath = gizmo.name.parentPath != null ? repository.toLogicalSimplePath(repositoryContext, isMyDrive, gizmo.name.parentPath) : null;
        String entityJson = gizmo.json;
        String entityLastModified = gizmo.name.lastModified != null ? gizmo.name.lastModified : "";
        Long entityLastModifiedTS = gizmo.name.lastModifiedTS;
        if (type != OlapDocsGizmoEntityType.DASHBOARD) {
            sb.put("entityName", entityName);
            sb.put("entityPath", entityPath);
            sb.put("entityLastModified", entityLastModified);
            sb.put("entityLastModifiedTS", entityLastModifiedTS);
            if (gizmo.name.perms != null) {
                sb.put("entityPerms", gizmo.name.perms.name());
            }
            if (entityFolderPath != null) {
                sb.put("entityFolderPath", entityFolderPath);
            }
            sb.put("entityJson", entityJson);
        } else {
            String reportName = entityName;
            String reportPath = entityPath;
            String reportPathAudit = gizmo.name.path;
            String reportPermaLink = "?ic3report=" + reportPathAudit;
            sb.put("reportName", reportName);
            sb.put("reportPath", reportPath);
            sb.put("reportLastModified", entityLastModified);
            sb.put("reportLastModifiedTS", entityLastModifiedTS);
            if (gizmo.name.perms != null) {
                sb.put("reportPerms", gizmo.name.perms.name());
            }
            sb.put("reportPathAudit", reportPathAudit);
            sb.put("reportPermaLink", reportPermaLink);
            if (entityFolderPath != null) {
                sb.put("reportFolderPath", entityFolderPath);
            }
            String reportJson = entityJson;
            if (withAuthSchema) {
                SchemaInfo auth = this.isAuthSchema(queryContext.getOlapEngineRequestContext(), reportJson);
                if (!auth.auth) {
                    sb.put("reportSchemaName", auth.name);
                    sb.put("reportJson", "schemaNotAuth");
                } else {
                    sb.put("reportJson", reportJson);
                }
            } else {
                sb.put("reportJson", reportJson);
            }
        }
        GviTableRow row = new GviTableRow();
        row.addCell(sb);
        table.addRow(row);
        return new GviDataTableResponse(queryContext, table);
    }

    protected GviResponse saveGizmo(GviQueryContext queryContext, OlapDocsGizmoEntityType type, OlapDocsGizmoSaveMode mode, boolean overwrite, String path, @Nullable String name, String content) throws OlapDocsErrorException {
        try {
            IOlapDocsRequestContext repositoryContext = this.createRepositoryContext(queryContext);
            OlapDocsRepository repository = this.getDocsRepository(queryContext);
            OlapDocsGizmosRepository gizmos = repository.asGizmosRepository(type);
            OlapPath sPath = repository.fromLogicalSimplePath(repositoryContext, path);
            boolean isMyDrive = repository.isLogicalMyDriveSimplePath(repositoryContext, path);
            OlapDocsGizmoNode saved = gizmos.saveGizmo(repositoryContext, mode, overwrite, sPath, name, content);
            GviTable table = new GviTable();
            table.addColumn(new GviColumnDescription("report-info", "OBJECT", "Report Info."));
            Map sb = this.setupGizmoNodeInfo(repositoryContext, repository, saved, isMyDrive);
            GviTableRow row = new GviTableRow();
            row.addCell(sb);
            table.addRow(row);
            return new GviDataTableResponse(queryContext, table);
        }
        catch (OlapDocsErrorException ex) {
            if (ex.isCausedBy(OlapDocsErrorCode.REPORT_APP_LOCAL_ENTITY_EXISTING)) {
                GviTable table = this.askForConfirmationNG();
                return new GviDataTableResponse(queryContext, table);
            }
            throw ex;
        }
    }

    protected GviResponse moveGizmo(GviQueryContext queryContext, OlapDocsGizmoEntityType type, boolean overwrite, String path, @Nullable String nameTo, @Nullable String pathTo) throws OlapDocsErrorException {
        try {
            OlapDocsGizmoNode moved;
            IOlapDocsRequestContext repositoryContext = this.createRepositoryContext(queryContext);
            OlapDocsRepository repository = this.getDocsRepository(queryContext);
            OlapDocsGizmosRepository gizmos = repository.asGizmosRepository(type);
            OlapPath sPath = repository.fromLogicalSimplePath(repositoryContext, path);
            boolean isMyDrive = repository.isLogicalMyDriveSimplePath(repositoryContext, path);
            if (pathTo != null) {
                OlapPath sPathTo = repository.fromLogicalSimplePath(repositoryContext, pathTo);
                moved = gizmos.moveGizmo(repositoryContext, overwrite, sPath, sPathTo);
            } else if (nameTo != null) {
                moved = gizmos.renameGizmo(repositoryContext, overwrite, sPath, nameTo);
            } else {
                throw new OlapDocsErrorException(OlapDocsErrorCode.UNEXPECTED_REPOSITORY_ERROR, new Serializable[]{"inconsistent move parameter"});
            }
            GviTable table = new GviTable();
            table.addColumn(new GviColumnDescription("report-info", "OBJECT", "Report Info."));
            Map sb = this.setupGizmoNodeInfo(repositoryContext, repository, moved, isMyDrive);
            GviTableRow row = new GviTableRow();
            row.addCell(sb);
            table.addRow(row);
            return new GviDataTableResponse(queryContext, table);
        }
        catch (OlapDocsErrorException ex) {
            if (ex.isCausedBy(OlapDocsErrorCode.REPORT_RENAME_EXISTING)) {
                GviTable table = this.askForConfirmationNG();
                return new GviDataTableResponse(queryContext, table);
            }
            throw ex;
        }
    }

    protected GviResponse deleteGizmo(GviQueryContext queryContext, OlapDocsGizmoEntityType type, String path) throws OlapDocsErrorException {
        IOlapDocsRequestContext repositoryContext = this.createRepositoryContext(queryContext);
        OlapDocsRepository repository = this.getDocsRepository(queryContext);
        OlapDocsGizmosRepository gizmos = repository.asGizmosRepository(type);
        OlapPath sPath = repository.fromLogicalSimplePath(repositoryContext, path);
        gizmos.deleteGizmo(repositoryContext, sPath);
        return new GviDataTableResponse(queryContext, new GviTable());
    }

    private String trimGizmoExtension(String name) {
        if (name.endsWith(this.type.extension)) {
            return name.substring(0, name.length() - this.type.extension.length());
        }
        return name;
    }

    protected Map setupGizmoNodeInfo(IOlapDocsRequestContext repositoryContext, OlapDocsRepository repository, OlapDocsGizmoNode node, boolean isMyDrive) {
        String sPPath;
        OlapPath pPath;
        HashMap<String, String> sb = new HashMap<String, String>();
        OlapPath path = node.path.relativeTo(node.root);
        String sPath = repository.toLogicalSimplePath(repositoryContext, isMyDrive, path.toSimplePath());
        String name = node.name;
        sb.put("path", this.trimGizmoExtension(sPath));
        sb.put("name", this.trimGizmoExtension(name));
        if (this.type == OlapDocsGizmoEntityType.DASHBOARD) {
            String pathAudit = path.toSimplePath();
            String permaLink = "?ic3report=" + pathAudit;
            sb.put("pathAudit", this.trimGizmoExtension(pathAudit));
            sb.put("permaLink", this.trimGizmoExtension(permaLink));
        }
        if ((pPath = path.getParent()) != null && (sPPath = repository.toLogicalSimplePath(repositoryContext, isMyDrive, pPath.toSimplePath())) != null) {
            sb.put("parentPath", this.trimGizmoExtension(sPPath));
        }
        return sb;
    }

    protected GviResponse createGizmoFolder(GviQueryContext queryContext, OlapDocsGizmoEntityType type, String path, String name) throws OlapDocsErrorException {
        try {
            IOlapDocsRequestContext repositoryContext = this.createRepositoryContext(queryContext);
            OlapDocsRepository repository = this.getDocsRepository(queryContext);
            OlapDocsGizmosRepository gizmos = repository.asGizmosRepository(type);
            OlapPath sPath = repository.fromLogicalSimplePath(repositoryContext, path);
            boolean isMyDrive = repository.isLogicalMyDriveSimplePath(repositoryContext, path);
            OlapPath sName = OlapPath.createFromRawPath((String[])new String[]{name});
            OlapDocsGizmoNode created = gizmos.createGizmoFolder(repositoryContext, sPath, name, sName);
            GviTable table = new GviTable();
            table.addColumn(new GviColumnDescription("folder-info", "OBJECT", "Folder Info."));
            Map sb = this.setupGizmoNodeInfo(repositoryContext, repository, created, isMyDrive);
            GviTableRow row = new GviTableRow();
            row.addCell(sb);
            table.addRow(row);
            return new GviDataTableResponse(queryContext, table);
        }
        catch (OlapDocsErrorException ex) {
            if (ex.isCausedBy(OlapDocsErrorCode.REPORT_FOLDER_EXISTING)) {
                GviTable table = this.askForConfirmationNG();
                return new GviDataTableResponse(queryContext, table);
            }
            throw ex;
        }
    }

    protected GviResponse moveGizmoFolder(GviQueryContext queryContext, OlapDocsGizmoEntityType type, String path, @Nullable String nameTo, @Nullable String pathTo) throws OlapDocsErrorException {
        try {
            OlapDocsGizmoNode moved;
            IOlapDocsRequestContext repositoryContext = this.createRepositoryContext(queryContext);
            OlapDocsRepository repository = this.getDocsRepository(queryContext);
            OlapDocsGizmosRepository gizmos = repository.asGizmosRepository(type);
            OlapPath sPath = repository.fromLogicalSimplePath(repositoryContext, path);
            boolean isMyDrive = repository.isLogicalMyDriveSimplePath(repositoryContext, path);
            if (pathTo != null) {
                OlapPath sPathTo = repository.fromLogicalSimplePath(repositoryContext, pathTo);
                moved = gizmos.moveGizmoFolder(repositoryContext, sPathTo, sPath);
            } else {
                moved = gizmos.renameGizmoFolder(repositoryContext, sPath, OlapPath.createFromRawPath((String[])new String[]{nameTo}));
            }
            GviTable table = new GviTable();
            table.addColumn(new GviColumnDescription("folder-info", "OBJECT", "Folder Info."));
            Map sb = this.setupGizmoNodeInfo(repositoryContext, repository, moved, isMyDrive);
            GviTableRow row = new GviTableRow();
            row.addCell(sb);
            table.addRow(row);
            return new GviDataTableResponse(queryContext, table);
        }
        catch (OlapDocsErrorException ex) {
            if (ex.isCausedBy(OlapDocsErrorCode.REPORT_FOLDER_EXISTING)) {
                GviTable table = this.askForConfirmationNG();
                return new GviDataTableResponse(queryContext, table);
            }
            throw ex;
        }
    }

    protected GviResponse deleteGizmoFolder(GviQueryContext queryContext, OlapDocsGizmoEntityType type, String path) throws OlapDocsErrorException {
        IOlapDocsRequestContext repositoryContext = this.createRepositoryContext(queryContext);
        OlapDocsRepository repository = this.getDocsRepository(queryContext);
        OlapDocsGizmosRepository gizmos = repository.asGizmosRepository(type);
        OlapPath sPath = repository.fromLogicalSimplePath(repositoryContext, path);
        gizmos.deleteGizmoFolder(repositoryContext, sPath);
        return new GviDataTableResponse(queryContext, new GviTable());
    }

    protected SchemaInfo isAuthSchema(OlapEngineRequestContext context, String json) {
        try {
            Map gson = (Map)new GsonBuilder().create().fromJson(json, Map.class);
            Map<?, ?> defaults = UxJsonParserUtils.parseAsMap(gson, "report.guts.defaults");
            if (defaults != null) {
                String schemaName = UxJsonParserUtils.parseAsString(defaults, "schemaName");
                if (schemaName != null) {
                    return this.isAuthSchemaEx(context, schemaName);
                }
                return new SchemaInfo("", true);
            }
        }
        catch (RuntimeException ex) {
            OlapLoggers.GVI_REQUEST.warn((Object)"[GVI] could not retrieve schema auth.", (Throwable)ex);
        }
        return new SchemaInfo("", true);
    }

    private SchemaInfo isAuthSchemaEx(OlapEngineRequestContext context, String schemaName) {
        OlapRoleApplicationPermissions applicationPermissions = context.getApplicationPermissions();
        IOlapSchemasPermission schemasPermissions = context.getSchemasPermissions();
        OlapEngineComponent engine = context.getOlapEngineComponent();
        OlapSchemaInfo info = engine.getAuthorizedSchemaInfo(context, applicationPermissions, schemasPermissions, schemaName);
        if (info == null) {
            OlapLoggers.GVI_REQUEST.info((Object)("[GVI] open report: the schema [" + schemaName + "] is not authorized"));
            return new SchemaInfo(schemaName, false);
        }
        if (info.hasNoCube()) {
            OlapLoggers.GVI_REQUEST.info((Object)("[GVI] open report: the schema [" + schemaName + "] has no cube authorized"));
            return new SchemaInfo(schemaName, false);
        }
        return new SchemaInfo(schemaName, true);
    }

    static class SchemaInfo {
        final String name;
        final boolean auth;

        public SchemaInfo(String name, boolean auth) {
            this.name = name;
            this.auth = auth;
        }
    }
}

