/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.server.gvi.request.parseMdx;

import crazydev.common.utils.CdStringUtils;
import crazydev.iccube.olap.component.context.OlapEngineRequestContext;
import crazydev.iccube.olap.component.naming.OlapNameContext;
import crazydev.iccube.olap.component.naming.OlapRequestNamesContext;
import crazydev.iccube.olap.cube.OlapCube;
import crazydev.iccube.olap.entity.permissions.IOlapSchemaPermission;
import crazydev.iccube.olap.entity.permissions.IOlapSchemasPermission;
import crazydev.iccube.olap.schema.OlapSchema;
import crazydev.iccube.request.task.IcCubeSchemaAccessLockMode;
import crazydev.iccube.server.gvi.request.common.GviPayloadResponse;
import crazydev.iccube.server.gvi.request.common.GviQueryContext;
import crazydev.iccube.server.gvi.request.common.GviQueryKind;
import crazydev.iccube.server.gvi.request.common.GviResponse;
import crazydev.iccube.server.gvi.request.common.GviSchemaOlapEngineQuery;
import crazydev.iccube.server.gvi.request.common.errors.GviException;
import crazydev.iccube.server.gvi.request.parseMdx.GviParsedMdxResult;
import crazydev.iccube.server.gvi.request.parseMdx.OlapParsedMdxQuery;

public class GviParseMdxQuery
extends GviSchemaOlapEngineQuery {
    private final String schema;
    private final String cube;
    private final String mdx;
    private final int mdxVersion;

    public GviParseMdxQuery(String uuid, String schema, String cube, String mdx, int mdxVersion) {
        super(uuid, schema);
        this.schema = schema;
        this.cube = cube;
        this.mdx = mdx;
        this.mdxVersion = mdxVersion;
    }

    @Override
    public boolean isMonitored() {
        return false;
    }

    @Override
    public boolean isForMdxConsole() {
        return true;
    }

    @Override
    public GviQueryKind getKind() {
        return GviQueryKind.OTHER;
    }

    @Override
    public String getUserFriendlyTypeName() {
        return "GVI Parse MDX";
    }

    @Override
    protected GviResponse doExecute(GviQueryContext queryContext) throws GviException {
        OlapRequestNamesContext nameContext;
        IOlapSchemasPermission schemasPermissions;
        IOlapSchemaPermission schemaPermissions;
        OlapCube loadedCube;
        OlapEngineRequestContext eContext = queryContext.getOlapEngineRequestContext();
        OlapSchema loadedSchema = this.getLoadedSchema(eContext, IcCubeSchemaAccessLockMode.READ);
        GviParsedMdxResult result = new GviParsedMdxResult(this.mdxVersion, this.schema, this.cube);
        if (loadedSchema != null && CdStringUtils.isNotNullAndNotBlank((String)this.mdx) && (loadedCube = loadedSchema.lookupCubeByName(schemaPermissions = (schemasPermissions = eContext.getSchemasPermissions()).getSchemaPermissions(eContext, loadedSchema, true), (OlapNameContext)(nameContext = eContext.getNameContext()), this.cube)) != null) {
            result = OlapParsedMdxQuery.getResult(eContext, loadedSchema, this.schema, loadedCube, this.cube, this.mdx, this.mdxVersion);
        }
        return new GviPayloadResponse(result);
    }
}

