/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.server.gvi.request.getmembers;

import crazydev.iccube.gvi.table.GviColumnDescription;
import crazydev.iccube.gvi.table.GviTable;
import crazydev.iccube.gvi.table.GviTableRow;
import crazydev.iccube.server.context.IcCubeServerSessionContext;
import crazydev.iccube.server.gvi.request.common.GviDataTableResponse;
import crazydev.iccube.server.gvi.request.common.GviGenericErrorResponse;
import crazydev.iccube.server.gvi.request.common.GviQuery;
import crazydev.iccube.server.gvi.request.common.GviQueryContext;
import crazydev.iccube.server.gvi.request.common.GviResponse;
import crazydev.iccube.server.gvi.request.common.errors.GviError;
import crazydev.iccube.server.gvi.request.common.errors.GviErrorCode;
import java.io.Serializable;
import java.util.Locale;
import org.jetbrains.annotations.Nullable;

public class GviLoginQuery
extends GviQuery {
    private final String userName;
    private final boolean userNameCheck;

    public GviLoginQuery(String uuid, String userName, boolean userNameCheck) {
        super(uuid);
        this.userName = userName;
        this.userNameCheck = userNameCheck;
    }

    @Override
    public boolean isForMdxConsole() {
        return true;
    }

    @Override
    @Nullable
    public String getSchema() {
        return null;
    }

    @Override
    public boolean isSchemaWrite() {
        return false;
    }

    @Override
    public String getUserFriendlyTypeName() {
        return "GVI Login";
    }

    @Override
    public GviResponse execute(GviQueryContext queryContext) {
        String currentUserName;
        if (this.userNameCheck && !(currentUserName = queryContext.getIcCubeServerRequestContext().getSessionContext().getUserName()).equals(this.userName)) {
            return new GviGenericErrorResponse(new GviError(GviErrorCode.USER_MISMATCH, new Serializable[]{this.userName, currentUserName}));
        }
        IcCubeServerSessionContext sessionContext = queryContext.getIcCubeServerRequestContext().getSessionContext();
        String authUserName = sessionContext.getUserName();
        String authUserRole = sessionContext.getUserRoleName();
        Locale authUserLocale = sessionContext.getUserLocale();
        GviTable table = new GviTable();
        table.addColumn(new GviColumnDescription("auth-user-name", "Auth User Name"));
        table.addColumn(new GviColumnDescription("auth-user-role", "Auth User Role"));
        table.addColumn(new GviColumnDescription("auth-user-locale", "Auth User Locale"));
        GviTableRow row = new GviTableRow();
        row.addCell(authUserName);
        row.addCell(authUserRole);
        row.addCell(authUserLocale.toString());
        table.addRow(row);
        return new GviDataTableResponse(queryContext, table);
    }
}

