/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.server.gvi.request.common;

import crazydev.iccube.babylon.OlapBabylonService;
import crazydev.iccube.olap.loggers.OlapLoggers;
import crazydev.iccube.server.gvi.request.common.GviResponse;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public abstract class GviRegularResponse
extends GviResponse {
    protected boolean isStream;

    @Override
    public void writeResponse(HttpServletRequest request, HttpServletResponse response, OlapBabylonService babylon) throws IOException {
        boolean bl = this.isStream = request.getHeader("X-STREAM") != null;
        if (OlapLoggers.GVI_RESPONSE.isDebugEnabled()) {
            this.doWriteResponseDebug(OlapBabylonService.ENGLISH);
        }
        this.doWriteResponse(request, response, babylon);
    }

    protected void doWriteResponseDebug(OlapBabylonService babylon) {
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            this.doWriteResponseBody(out, babylon);
            out.flush();
            String debug = new String(out.toByteArray(), this.getCharsetEncoding());
            if (OlapLoggers.GVI_RESPONSE.isDebugEnabled()) {
                OlapLoggers.GVI_RESPONSE.debug((Object)("GVI response : " + debug));
            }
        }
        catch (IOException ignored) {
            OlapLoggers.GVI_RESPONSE.warn((Object)"Could not write debug response", (Throwable)ignored);
        }
    }

    protected void doWriteResponse(HttpServletRequest request, HttpServletResponse response, OlapBabylonService babylon) throws IOException {
        this.doWriteResponseHeader(response);
        ServletOutputStream out = response.getOutputStream();
        this.doWriteResponseBody((OutputStream)out, babylon);
        out.flush();
    }

    protected void doWriteResponseHeader(HttpServletResponse response) {
        response.setContentType("text/plain; charset=" + this.getCharsetEncoding());
    }

    protected abstract void doWriteResponseBody(OutputStream var1, OlapBabylonService var2) throws IOException;
}

