/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.server.gvi.request.common;

import com.google.gson.Gson;
import crazydev.common.babylon.CdBabylonService;
import crazydev.iccube.babylon.OlapBabylonService;
import crazydev.iccube.gvi.GviMaterializedDataTableErrorResponse;
import crazydev.iccube.server.gvi.request.chat.GviAIChatErrorChunk;
import crazydev.iccube.server.gvi.request.common.GviRegularResponse;
import crazydev.iccube.server.gvi.request.common.errors.GviError;
import crazydev.iccube.server.gvi.request.common.errors.GviErrorCode;
import crazydev.iccube.server.gvi.tidy.serialize.GviTidySerializerUtils;
import crazydev.iccube.ux.common.validation.UxMdxRange;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import org.jetbrains.annotations.Nullable;

public abstract class GviErrorResponse
extends GviRegularResponse {
    protected final GviError error;
    @Nullable
    private final String additionalInformation;
    @Nullable
    private final UxMdxRange range;

    public GviErrorResponse(GviError error, @Nullable String additionalInformation) {
        this(error, additionalInformation, null);
    }

    public GviErrorResponse(GviError error, @Nullable String additionalInformation, @Nullable UxMdxRange range) {
        this.error = error;
        this.additionalInformation = additionalInformation;
        this.range = range;
    }

    @Override
    protected void doWriteResponseBody(OutputStream out, OlapBabylonService babylon) throws IOException {
        this.writeResponseBody(out, babylon);
    }

    private void writeResponseBody(OutputStream out, OlapBabylonService babylon) throws IOException {
        if (this.isStream) {
            String errorCode = this.error.getCode().getValue();
            String errorMessage = this.error.asMessage((CdBabylonService)babylon);
            GviAIChatErrorChunk chunk = new GviAIChatErrorChunk(errorCode, errorMessage);
            String json = new Gson().toJson((Object)chunk) + "\n";
            out.write(json.getBytes(StandardCharsets.UTF_8));
            out.flush();
            return;
        }
        String message = this.error.asMessage((CdBabylonService)babylon);
        Serializable schema = null;
        if (((Object)((Object)GviErrorCode.MISSING_SCHEMA)).equals(this.error.getCode())) {
            schema = this.error.getFirstParam();
        }
        String location = this.setupLocation();
        String payload = GviTidySerializerUtils.asErrorResponse(new GviMaterializedDataTableErrorResponse(schema != null ? schema.toString() : null, this.error.getCode(), message, this.additionalInformation, location));
        byte[] content = payload.getBytes(this.getCharsetEncoding());
        out.write(content);
    }

    @Nullable
    private String setupLocation() {
        if (this.range == null) {
            return null;
        }
        return new Gson().toJson((Object)this.range);
    }
}

