/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.server.gvi.request.common;

import com.google.gson.Gson;
import crazydev.iccube.babylon.OlapBabylonService;
import crazydev.iccube.common.IOlapCancellingContext;
import crazydev.iccube.gvi.table.GviTable;
import crazydev.iccube.server.gvi.request.common.GviRegularResponse;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class GviDataTableResponse
extends GviRegularResponse {
    private final IOlapCancellingContext context;
    @Nullable
    private final GviTable dataTable;

    public GviDataTableResponse(IOlapCancellingContext context, @Nullable GviTable dataTable) {
        this.context = context;
        this.dataTable = dataTable;
    }

    @Override
    public String getFriendlyType() {
        return "table";
    }

    @Override
    protected void doWriteResponseBody(OutputStream out, OlapBabylonService babylon) throws IOException {
        this.writeResponseBody(out, babylon);
    }

    private void writeResponseBody(OutputStream out, OlapBabylonService babylon) throws IOException {
        GviTable table = this.dataTable;
        if (table != null) {
            List columns = table.getColumnDescriptions();
            List rows = table.getRows();
            if ((columns == null || columns.isEmpty()) && (rows == null || rows.isEmpty())) {
                table = null;
            }
        }
        Gson gson = new Gson();
        String json = gson.toJson((Object)new Response(table));
        byte[] jsonB = json.getBytes(StandardCharsets.UTF_8);
        out.write(jsonB);
        out.flush();
    }

    private static class Response {
        final String version = "1";
        final String status = "ok";
        @Nullable
        final GviTable table;

        Response(@Nullable GviTable table) {
            this.table = table;
        }
    }
}

